<?php
require 'config.php';

// جلب البيانات من قاعدة البيانات
$services = $pdo->query("SELECT * FROM services")->fetchAll(PDO::FETCH_ASSOC);
$team = $pdo->query("SELECT * FROM team")->fetchAll(PDO::FETCH_ASSOC);
$testimonials = $pdo->query("SELECT * FROM testimonials")->fetchAll(PDO::FETCH_ASSOC);
$slider = $pdo->query("SELECT * FROM slider")->fetchAll(PDO::FETCH_ASSOC);
$settings = $pdo->query("SELECT * FROM settings LIMIT 1")->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title><?= $settings['site_title'] ?? "مكتب المحامي" ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <!-- خط كايرو وأيقونات فونت أوسوم -->
  <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
    body {font-family: 'Cairo', sans-serif; margin:0; background:#f5f7f7;}
    /* بقية التنسيقات ... ضع CSS الذي أرسلته لك من قبل هنا */
	.about-cards-wrapper {
  display: flex;
  flex-wrap: wrap;
  gap: 30px;
  justify-content: center;
  align-items: flex-start;
  margin: 40px 0 50px 0;
}
.about-card {
  background: #fff;
  border-radius: 1.3rem;
  box-shadow: 0 2px 16px #17483222;
  padding: 38px 28px 25px 28px;
  max-width: 340px;
  flex: 1 1 300px;
  display: flex;
  flex-direction: column;
  align-items: center;
  transition: box-shadow .22s;
  border-top: 6px solid #ffd700;
}
.about-card:hover {
  box-shadow: 0 8px 24px #17483235;
  border-top-color: #174832;
}
.icon-wrap {
  width: 74px; height: 74px;
  border-radius: 50%;
  background: linear-gradient(135deg,#ffd700 60%,#174832 100%);
  display: flex; align-items: center; justify-content: center;
  font-size: 2.4rem; color: #fff;
  margin-bottom: 13px;
  box-shadow: 0 2px 12px #ffd70040;
}
.about-icon2 { background: linear-gradient(135deg,#174832 70%,#ffd700 100%);}
.about-icon3 { background: linear-gradient(135deg,#ffd700 40%,#2e8654 100%);}
.about-card h3 {
  color: #174832;
  font-size: 1.23rem;
  margin-bottom: 13px;
  margin-top: 0;
  font-weight: bold;
  letter-spacing: .5px;
}
.about-card p {
  color: #333;
  font-size: 1.04rem;
  text-align: center;
  line-height: 2;
  margin-bottom: 0;
}
@media (max-width:900px){
  .about-cards-wrapper {flex-direction:column;align-items:center;}
  .about-card {max-width:98%;}
}

	.whatsapp-float {
  position: fixed;
  bottom: 25px;
  left: 24px;
  background: #25d366;
  color: #fff;
  border-radius: 50%;
  width: 53px;
  height: 53px;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 2rem;
  z-index: 1000;
  box-shadow: 0 2px 12px #0003;
  transition: background .2s;
}
.whatsapp-float:hover {
  background: #1ebe57;
  color: #fff;
}

	.footer {
  background: #174832;
  color: #fff;
  padding: 30px 0 10px 0;
  margin-top:40px;
}
.footer-content {
  display: flex;
  justify-content: space-between;
  gap: 25px;
  max-width: 1200px;
  margin: auto;
  flex-wrap: wrap;
}
.footer-section {
  flex: 1;
  min-width: 200px;
  margin-bottom: 18px;
}
.footer-section h4 {
  margin-bottom: 10px;
  color: #ffd700;
  font-size: 1.12rem;
  display: flex; align-items: center; gap:6px;
}
.footer-section a {
  color: #ffd700;
  text-decoration: none;
  margin-right: 8px;
}
.footer-social a {
  color: #fff;
  background: #25d366;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  margin-left: 7px;
  border-radius: 50%;
  width: 30px; height: 30px;
  font-size: 1.2rem;
  transition: background .2s;
}
.footer-social a:hover { background: #174832; color:#ffd700; }
.footer-bottom {
  border-top: 1.5px solid #1d573b;
  text-align: center;
  margin-top: 15px;
  padding-top: 10px;
  color: #ffd700;
  font-size: 1.05rem;
}
@media (max-width: 900px){
  .footer-content {flex-direction:column; gap:0;}
  .footer-section {margin-bottom:22px;}
}

	.appointment-section {
  max-width: 500px;
  margin: 40px auto 50px auto;
  background: #fff;
  padding: 30px 26px 20px 26px;
  border-radius: 1.1rem;
  box-shadow: 0 2px 16px #17483220;
  text-align: center;
}
.appointment-section h2 {
  color: #174832;
  margin-bottom: 16px;
  font-size: 1.3rem;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 7px;
}
.success-msg {
  background: #e4ffea;
  color: #185334;
  border: 1.5px solid #45c975;
  padding: 9px 0;
  border-radius: .6rem;
  font-weight: bold;
  margin-bottom: 14px;
  display: flex; align-items: center; justify-content: center; gap:7px;
}
.appointment-form {display: flex; flex-direction: column; gap: 12px;}
.appointment-form .form-group {
  display: flex; gap: 7px;
}
.appointment-form input, .appointment-form select, .appointment-form textarea {
  font-family: 'Cairo', Tahoma, Arial;
  padding: 11px;
  border: 1.5px solid #ddd;
  border-radius: .7rem;
  font-size: 1.03rem;
  background: #f8f9f8;
  outline: none;
  transition: border-color .2s;
  margin-bottom: 0;
  width: 100%;
}
.appointment-form textarea { resize: vertical; }
.appointment-form input:focus, .appointment-form select:focus, .appointment-form textarea:focus {
  border-color: #185334;
}
.appointment-form button {
  background: #174832;
  color: #fff;
  padding: 12px;
  border-radius: .8rem;
  font-weight: bold;
  border: none;
  font-size: 1.08rem;
  transition: background .2s;
  cursor: pointer;
  margin-top: 8px;
  display:flex;align-items:center;gap:7px;justify-content:center;
}
.appointment-form button:hover {
  background: #2b6d49;
}

	body { font-family: 'Cairo', Tahoma, Arial, sans-serif; margin:0; background:#f5f7f7;}
.main-header {
  background: linear-gradient(90deg, #174832 85%, #ffd700 100%);
  box-shadow: 0 2px 8px #0002;
  position: sticky; top:0; z-index:50;
}
.header-inner {
  display: flex; align-items: center; justify-content: space-between;
  max-width: 1200px; margin: auto; padding: 0 16px; height: 70px;
}
.header-right { display:flex; align-items:center; gap:10px; }
.logo-img {height: 46px; border-radius:50%; background:#fff;}
.site-title {font-size: 1.45rem; font-weight: bold; color: #ffd700;}
.main-nav {
  display:flex; align-items:center; gap:18px; transition:.4s;
}
.main-nav a {
  color:#fff; font-weight:500; text-decoration:none; font-size:1rem;
  padding:6px 10px; border-radius:0.5rem; display:flex; align-items:center; gap:5px; transition:.2s;
}
.main-nav a:hover, .main-nav a.active { background:#ffd700; color:#174832;}
.header-actions { display:flex; align-items:center; gap:10px;}
.header-actions a, .header-actions button {
  color: #ffd700; font-size: 1.28rem; background: none; border: none; cursor:pointer; padding:6px;
  transition:.2s;
}
.header-actions a:hover, .header-actions button:hover {color:#fff;}
.menu-btn { display:none;}
@media (max-width:900px) {
  .main-nav { position: fixed; right:-220px; top:70px; background:#174832; flex-direction:column; align-items:flex-start;
    width: 200px; height:100vh; z-index:999; gap:12px; padding:18px 0 0 0; box-shadow:-6px 0 20px #0003; transition:.4s;}
  .main-nav.open { right:0;}
  .menu-btn { display:inline;}
}
.about-section {
  background:#fff; max-width:800px; margin:38px auto 0 auto; padding:32px 28px 26px 28px;
  border-radius:1.3rem; box-shadow:0 2px 18px #0001; margin-bottom:18px;
}
.about-section h2 {
  color: #174832; font-size: 1.4rem; margin-bottom:14px; display:flex; align-items:center; gap:7px;
}
.about-section p {
  color: #333; font-size:1.12rem; margin-bottom:0; display:flex; align-items:flex-start; gap:7px; line-height:2.05;
}
.about-section i { color:#ffd700; font-size:1.15rem;}

    /* يمكنك نسخ كامل CSS من الردود السابقة */
  </style>
</head>
<body>

<!-- الهيدر العصري -->
<header class="main-header">
  <div class="header-inner">
    <div class="header-right">
      <img src="<?= $settings['logo'] ?>" alt="شعار" class="logo-img">
      <span class="site-title"><?= $settings['site_title'] ?></span>
    </div>
    <nav class="main-nav" id="mainNav">
      <a href="#about"><i class="fas fa-user-tie"></i> من نحن</a>
      <a href="#vision"><i class="fas fa-eye"></i> الرؤية</a>
      <a href="#mission"><i class="fas fa-bullseye"></i> الرسالة</a>
      <a href="#services"><i class="fas fa-gavel"></i> الخدمات</a>
      <a href="#team"><i class="fas fa-users"></i> الفريق</a>
      <a href="#testimonials"><i class="fas fa-comments"></i> آراء العملاء</a>
      <a href="#appointment"><i class="fas fa-calendar-check"></i> حجز موعد</a>
    </nav>
    <div class="header-actions">
      <a href="tel:<?= $settings['phone'] ?>" title="اتصل الآن"><i class="fas fa-phone"></i></a>
      <a href="mailto:<?= $settings['email'] ?>" title="راسلنا"><i class="fas fa-envelope"></i></a>
      <button id="translateBtn" title="تغيير اللغة"><i class="fas fa-globe"></i></button>
      <button id="menuBtn" class="menu-btn"><i class="fas fa-bars"></i></button>
    </div>
  </div>
</header>

  <!-- سلايدر ترحيبي -->
  <div style="background:#174832; color:#ffd700; padding:50px 0; text-align:center;">
    <h2 style="margin:0;">
      <?= htmlspecialchars($slider[0]['phrase'] ?? 'مرحباً بكم في مكتب المحامي') ?>
    </h2>
  </div>
</header>

<div class="about-cards-wrapper">
  <!-- بطاقة من نحن -->
  <div class="about-card" id="about">
    <div class="icon-wrap about-icon1">
      <i class="fas fa-user-tie"></i>
    </div>
    <h3>من نحن</h3>
    <p><?= nl2br(htmlspecialchars($settings['about_us'] ?? '')) ?></p>
  </div>
  <!-- بطاقة الرؤية -->
  <div class="about-card" id="vision">
    <div class="icon-wrap about-icon2">
      <i class="fas fa-eye"></i>
    </div>
    <h3>الرؤية</h3>
    <p><?= nl2br(htmlspecialchars($settings['vision'] ?? '')) ?></p>
  </div>
  <!-- بطاقة الرسالة -->
  <div class="about-card" id="mission">
    <div class="icon-wrap about-icon3">
      <i class="fas fa-bullseye"></i>
    </div>
    <h3>الرسالة</h3>
    <p><?= nl2br(htmlspecialchars($settings['mission'] ?? '')) ?></p>
  </div>
</div>

<!-- الخدمات -->
<section id="services" style="max-width:1200px;margin:30px auto;">
  <h2>خدماتنا</h2>
  <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(270px,1fr));gap:20px;">
    <?php foreach($services as $srv): ?>
      <div style="background:#fff;padding:25px 17px;border-radius:1.2rem;box-shadow:0 2px 14px #0002;text-align:center;">
        <div style="font-size:2.2rem;color:#174832;background:#ffd700;width:48px;height:48px;border-radius:50%;margin:0 auto 12px;display:flex;align-items:center;justify-content:center;">
          <i class="<?=htmlspecialchars($srv['icon'])?>"></i>
        </div>
        <div style="font-weight:700;color:#174832;font-size:1.12rem;"><?=htmlspecialchars($srv['title'])?></div>
        <div style="color:#444a;"><?=htmlspecialchars($srv['description'])?></div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<!-- الفريق -->
<section id="team" style="max-width:1200px;margin:30px auto;">
  <h2>أعضاء الفريق</h2>
  <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(210px,1fr));gap:17px;">
    <?php foreach($team as $member): ?>
      <div style="background:#fff;padding:18px 7px 13px 7px;border-radius:1.1rem;box-shadow:0 2px 10px #0001;text-align:center;">
        <img src="<?=htmlspecialchars($member['image'])?>" style="width:64px;height:64px;border-radius:50%;border:3px solid #ffd700;margin-bottom:8px;">
        <div style="font-weight:700;color:#174832;"><?=htmlspecialchars($member['name'])?></div>
        <div style="color:#ffd700;font-size:.99rem;"><?=htmlspecialchars($member['role'])?></div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<!-- آراء العملاء -->
<section id="testimonials" style="max-width:1200px;margin:30px auto;">
  <h2>آراء العملاء</h2>
  <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(270px,1fr));gap:18px;">
    <?php foreach($testimonials as $test): ?>
      <div style="background:#fffbe7;padding:19px 13px;border-radius:1rem;box-shadow:0 2px 12px #0001;">
        <div style="color:#ffd700;font-size:1.2rem;margin-bottom:7px;">
          <?php for($i=1;$i<=5;$i++): ?>
            <?php if($i <= $test['stars']): ?>
              <i class="fas fa-star"></i>
            <?php else: ?>
              <i class="far fa-star"></i>
            <?php endif; ?>
          <?php endfor; ?>
        </div>
        <div style="margin-bottom:6px;"><?=htmlspecialchars($test['comment'])?></div>
        <div style="color:#174832;font-weight:700;">— <?=htmlspecialchars($test['name'])?></div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<!-- نموذج حجز موعد -->
<section id="appointment" class="appointment-section">
  <h2><i class="fas fa-calendar-check"></i> حجز موعد</h2>
  <?php
  if($_SERVER['REQUEST_METHOD']=='POST' && isset($_POST['appointment'])) {
    $stmt = $pdo->prepare("INSERT INTO appointments (name, phone, email, type, details) VALUES (?,?,?,?,?)");
    $stmt->execute([
      $_POST['name'], $_POST['phone'], $_POST['email'], $_POST['type'], $_POST['details']
    ]);
    echo "<div class='success-msg'><i class='fas fa-check-circle'></i> تم إرسال طلبك بنجاح، سيتم التواصل معك قريبًا.</div>";
  }
  ?>
  <form method="post" class="appointment-form">
    <input type="hidden" name="appointment" value="1">
    <div class="form-group">
      <input type="text" name="name" placeholder="الاسم الكامل" required>
      <input type="tel" name="phone" placeholder="رقم الجوال" required>
    </div>
    <div class="form-group">
      <input type="email" name="email" placeholder="البريد الإلكتروني" required>
      <select name="type" required>
        <option value="">نوع الاستشارة</option>
        <option>قضية أسرية</option>
        <option>قضية تجارية</option>
        <option>عقد أو استشارة قانونية</option>
        <option>أخرى</option>
      </select>
    </div>
    <textarea name="details" placeholder="وصف مختصر لموضوع الاستشارة" rows="2"></textarea>
    <button type="submit"><i class="fas fa-paper-plane"></i> إرسال الطلب</button>
  </form>
</section>


<!-- فوتر مختصر -->
<footer class="footer">
  <div class="footer-content">
    <div class="footer-section">
      <h4><i class="fas fa-balance-scale"></i> <?= htmlspecialchars($settings['footer_title'] ?? 'مكتب المحامي') ?></h4>
      <p>
        <?= nl2br(htmlspecialchars($settings['footer_desc'] ?? '')) ?><br>
        <?php if(!empty($settings['footer_address'])): ?>
          <b>العنوان:</b> <?= htmlspecialchars($settings['footer_address']) ?>
        <?php endif; ?>
      </p>
    </div>
    <div class="footer-section">
      <h4><i class="fas fa-phone"></i> تواصل معنا</h4>
      <p>
        <?php if(!empty($settings['footer_phone'])): ?>
          <a href="tel:<?= htmlspecialchars($settings['footer_phone']) ?>"><i class="fas fa-phone"></i> <?= htmlspecialchars($settings['footer_phone']) ?></a><br>
        <?php endif; ?>
        <?php if(!empty($settings['footer_email'])): ?>
          <a href="mailto:<?= htmlspecialchars($settings['footer_email']) ?>"><i class="fas fa-envelope"></i> <?= htmlspecialchars($settings['footer_email']) ?></a>
        <?php endif; ?>
      </p>
      <div class="footer-social">
        <?php if(!empty($settings['footer_whatsapp'])): ?>
          <a href="<?= htmlspecialchars($settings['footer_whatsapp']) ?>" target="_blank"><i class="fab fa-whatsapp"></i></a>
        <?php endif; ?>
        <?php if(!empty($settings['footer_twitter'])): ?>
          <a href="<?= htmlspecialchars($settings['footer_twitter']) ?>" target="_blank"><i class="fab fa-x-twitter"></i></a>
        <?php endif; ?>
        <?php if(!empty($settings['footer_facebook'])): ?>
          <a href="<?= htmlspecialchars($settings['footer_facebook']) ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
        <?php endif; ?>
        <?php if(!empty($settings['footer_linkedin'])): ?>
          <a href="<?= htmlspecialchars($settings['footer_linkedin']) ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
        <?php endif; ?>
      </div>
    </div>
    <div class="footer-section">
      <h4><i class="fas fa-map-marker-alt"></i> موقع المكتب</h4>
      <div>
        <?php if(!empty($settings['footer_map'])): ?>
          <iframe src="<?= htmlspecialchars($settings['footer_map']) ?>" width="200" height="90" style="border-radius:8px;border:none;"></iframe>
        <?php else: ?>
          <span>لم يتم إضافة موقع بالخريطة.</span>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="footer-bottom">
    <?= htmlspecialchars($settings['footer_copyright'] ?? 'جميع الحقوق محفوظة &copy; ' . date('Y') . ' مكتب المحامي') ?>
  </div>
</footer>

    جميع الحقوق محفوظة &copy; <?=date('Y')?> مكتب المحامي – تصميم وتطوير
  </div>
</footer>
<a href="https://wa.me/966565877252" target="_blank" class="whatsapp-float" title="تواصل واتساب">
  <i class="fab fa-whatsapp"></i>
</a>
<script>
document.getElementById('menuBtn').onclick = function() {
  document.getElementById('mainNav').classList.toggle('open');
};
</script>
</body>
</html>
