<?php
session_start();
if(!isset($_SESSION['admin'])) header("Location: login.php");
require '../config.php';

// إضافة رأي
if(isset($_POST['add'])){
  $stmt = $pdo->prepare("INSERT INTO testimonials (name, comment, stars) VALUES (?,?,?)");
  $stmt->execute([$_POST['name'], $_POST['comment'], $_POST['stars']]);
}

// حذف رأي
if(isset($_GET['delete'])){
  $stmt = $pdo->prepare("DELETE FROM testimonials WHERE id=?");
  $stmt->execute([$_GET['delete']]);
}

// جلب الآراء
$testimonials = $pdo->query("SELECT * FROM testimonials")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>آراء العملاء</title>
  <style>
    body { font-family: Tahoma, Arial; background:#f7f8fa;}
    .menu { background:#174832; color:#fff; padding:13px 0; text-align:center; }
    .menu a { color:#ffd700; margin:0 17px; text-decoration:none; font-size:1.2rem;}
    .box { background:#fff; margin:35px auto; padding:33px 22px; border-radius:1.1rem; box-shadow:0 3px 18px #0001; width:90%; max-width:850px;}
    table { width:100%; border-collapse:collapse;}
    th, td { border-bottom:1px solid #eee; padding:10px 7px;}
    th { background:#f4f4e8;}
    .btn { padding:5px 13px; background:#ffd700; color:#174832; border:none; border-radius:.5rem; cursor:pointer;}
  </style>
</head>
<body>
  <div class="menu">
    <a href="index.php">الرئيسية</a>
    <a href="services.php">الخدمات</a>
    <a href="team.php">الفريق</a>
    <a href="testimonials.php">آراء العملاء</a>
    <a href="slider.php">السلايدر</a>
    <a href="appointments.php">الحجوزات</a>
    <a href="settings.php">الإعدادات</a>
    <a href="logout.php">خروج</a>
  </div>
  <div class="box">
    <h2>إدارة آراء العملاء</h2>
    <form method="post" style="margin-bottom:20px;">
      <input type="text" name="name" placeholder="اسم العميل" required>
      <input type="text" name="comment" placeholder="الرأي/التعليق" required style="width:220px;">
      <select name="stars" required>
        <option value="5">★★★★★</option>
        <option value="4">★★★★☆</option>
        <option value="3">★★★☆☆</option>
        <option value="2">★★☆☆☆</option>
        <option value="1">★☆☆☆☆</option>
      </select>
      <button name="add" class="btn">إضافة</button>
    </form>
    <table>
      <tr>
        <th>النجوم</th><th>الاسم</th><th>الرأي</th><th>خيارات</th>
      </tr>
      <?php foreach($testimonials as $row): ?>
        <tr>
          <td>
            <?php for($i=1;$i<=5;$i++): ?>
              <?= $i <= $row['stars'] ? "★" : "☆"; ?>
            <?php endfor; ?>
          </td>
          <td><?=htmlspecialchars($row['name'])?></td>
          <td><?=htmlspecialchars($row['comment'])?></td>
          <td>
            <a href="?delete=<?=$row['id']?>" onclick="return confirm('تأكيد الحذف؟')" class="btn">حذف</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </table>
  </div>
</body>
</html>
