<?php
session_start();
if(!isset($_SESSION['admin'])) header("Location: login.php");
require '../config.php';

// إضافة عبارة
if(isset($_POST['add'])){
  $stmt = $pdo->prepare("INSERT INTO slider (phrase) VALUES (?)");
  $stmt->execute([$_POST['phrase']]);
}

// حذف عبارة
if(isset($_GET['delete'])){
  $stmt = $pdo->prepare("DELETE FROM slider WHERE id=?");
  $stmt->execute([$_GET['delete']]);
}

// جلب العبارات
$slider = $pdo->query("SELECT * FROM slider")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>عبارات السلايدر</title>
  <style>
    body { font-family: Tahoma, Arial; background:#f7f8fa;}
    .menu { background:#174832; color:#fff; padding:13px 0; text-align:center; }
    .menu a { color:#ffd700; margin:0 17px; text-decoration:none; font-size:1.2rem;}
    .box { background:#fff; margin:35px auto; padding:33px 22px; border-radius:1.1rem; box-shadow:0 3px 18px #0001; width:90%; max-width:850px;}
    table { width:100%; border-collapse:collapse;}
    th, td { border-bottom:1px solid #eee; padding:10px 7px;}
    th { background:#f4f4e8;}
    .btn { padding:5px 13px; background:#ffd700; color:#174832; border:none; border-radius:.5rem; cursor:pointer;}
  </style>
</head>
<body>
  <div class="menu">
    <a href="index.php">الرئيسية</a>
    <a href="services.php">الخدمات</a>
    <a href="team.php">الفريق</a>
    <a href="testimonials.php">آراء العملاء</a>
    <a href="slider.php">السلايدر</a>
    <a href="appointments.php">الحجوزات</a>
    <a href="settings.php">الإعدادات</a>
    <a href="logout.php">خروج</a>
  </div>
  <div class="box">
    <h2>إدارة عبارات السلايدر</h2>
    <form method="post" style="margin-bottom:20px;">
      <input type="text" name="phrase" placeholder="نص العبارة" required style="width:300px;">
      <button name="add" class="btn">إضافة</button>
    </form>
    <table>
      <tr>
        <th>العبارة</th><th>خيارات</th>
      </tr>
      <?php foreach($slider as $row): ?>
        <tr>
          <td><?=htmlspecialchars($row['phrase'])?></td>
          <td>
            <a href="?delete=<?=$row['id']?>" onclick="return confirm('تأكيد الحذف؟')" class="btn">حذف</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </table>
  </div>
</body>
</html>
