<?php
session_start();
if(!isset($_SESSION['admin'])) header("Location: login.php");
require '../config.php';

// عند الحفظ
if(isset($_POST['save'])){
    // معالجة الشعار
    $logo = $_POST['current_logo'];
    if(isset($_FILES['logo']) && $_FILES['logo']['name'] != "") {
        $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
        $allow = ['jpg','jpeg','png','gif','webp'];
        if(in_array($ext, $allow)){
            $new_name = 'logo_'.time().'.'.$ext;
            move_uploaded_file($_FILES['logo']['tmp_name'], "../uploads/$new_name");
            $logo = "uploads/$new_name";
        }
    }

    $stmt = $pdo->prepare("UPDATE settings SET 
        site_title=?,
        email=?,
        phone=?,
        logo=?,
        footer_title=?,
        footer_desc=?,
        footer_phone=?,
        footer_email=?,
        footer_whatsapp=?,
        footer_twitter=?,
        footer_facebook=?,
        footer_linkedin=?,
        footer_map=?,
        footer_copyright=?,
        about_us=?,
        vision=?,
        mission=?
        WHERE id=1
    ");
    $stmt->execute([
        $_POST['site_title'],
        $_POST['email'],
        $_POST['phone'],
        $logo,
        $_POST['footer_title'],
        $_POST['footer_desc'],
        $_POST['footer_phone'],
        $_POST['footer_email'],
        $_POST['footer_whatsapp'],
        $_POST['footer_twitter'],
        $_POST['footer_facebook'],
        $_POST['footer_linkedin'],
        $_POST['footer_map'],
        $_POST['footer_copyright'],
        $_POST['about_us'],
        $_POST['vision'],
        $_POST['mission'],
    ]);
    $msg = "تم حفظ الإعدادات بنجاح.";
}

// جلب الإعدادات
$settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>الإعدادات العامة</title>
  <style>
    body { font-family: Tahoma, Arial; background:#f7f8fa;}
    .menu { background:#174832; color:#fff; padding:13px 0; text-align:center; }
    .menu a { color:#ffd700; margin:0 17px; text-decoration:none; font-size:1.2rem;}
    .box { background:#fff; margin:35px auto; padding:33px 22px; border-radius:1.1rem; box-shadow:0 3px 18px #0001; width:90%; max-width:700px;}
    label {font-weight:bold;}
    input, textarea {width:95%;margin-bottom:12px;padding:7px;}
    textarea {resize:vertical;min-height:55px;}
    .btn { padding:8px 17px; background:#ffd700; color:#174832; border:none; border-radius:.7rem; cursor:pointer;}
    .cur-logo {display:flex;align-items:center;gap:9px;margin-bottom:13px;}
    .cur-logo img {height:40px; background:#fff; border-radius:8px;}
    .section-title {margin-top:28px;color:#174832;}
    .success {color:green;margin-bottom:8px;font-weight:bold;}
  </style>
</head>
<body>
  <div class="menu">
    <a href="index.php">الرئيسية</a>
    <a href="services.php">الخدمات</a>
    <a href="team.php">الفريق</a>
    <a href="testimonials.php">آراء العملاء</a>
    <a href="slider.php">السلايدر</a>
    <a href="appointments.php">الحجوزات</a>
    <a href="settings.php">الإعدادات</a>
    <a href="logout.php">خروج</a>
  </div>
  <div class="box">
    <h2>الإعدادات العامة</h2>
    <?php if(isset($msg)) echo "<div class='success'>$msg</div>"; ?>
    <form method="post" enctype="multipart/form-data">
      <label>اسم الموقع:</label>
      <input type="text" name="site_title" value="<?=htmlspecialchars($settings['site_title'] ?? '')?>" required>
      
      <label>البريد الإلكتروني:</label>
      <input type="email" name="email" value="<?=htmlspecialchars($settings['email'] ?? '')?>" required>
      
      <label>رقم الجوال:</label>
      <input type="text" name="phone" value="<?=htmlspecialchars($settings['phone'] ?? '')?>" required>
      
      <label>شعار الموقع:</label>
      <div class="cur-logo">
        <?php if(!empty($settings['logo'])): ?>
        <img src="../<?=htmlspecialchars($settings['logo'] ?? '')?>" alt="الشعار">
        <?php endif; ?>
        <input type="file" name="logo" accept="image/*">
      </div>
      <input type="hidden" name="current_logo" value="<?=htmlspecialchars($settings['logo'] ?? '')?>">
      
      <h3 class="section-title">إعدادات الفوتر</h3>
      <label>عنوان الفوتر:</label>
      <input type="text" name="footer_title" value="<?=htmlspecialchars($settings['footer_title'] ?? '')?>">
      
      <label>وصف قصير (تعريف المكتب):</label>
      <textarea name="footer_desc"><?=htmlspecialchars($settings['footer_desc'] ?? '')?></textarea>
      
      <label>رقم الجوال في الفوتر:</label>
      <input type="text" name="footer_phone" value="<?=htmlspecialchars($settings['footer_phone'] ?? '')?>">
      
      <label>البريد الإلكتروني في الفوتر:</label>
      <input type="email" name="footer_email" value="<?=htmlspecialchars($settings['footer_email'] ?? '')?>">
      
      <label>رابط الواتساب (مثال: https://wa.me/966XXXXXXXXX):</label>
      <input type="text" name="footer_whatsapp" value="<?=htmlspecialchars($settings['footer_whatsapp'] ?? '')?>">
      
      <label>رابط تويتر:</label>
      <input type="text" name="footer_twitter" value="<?=htmlspecialchars($settings['footer_twitter'] ?? '')?>">
      
      <label>رابط فيسبوك:</label>
      <input type="text" name="footer_facebook" value="<?=htmlspecialchars($settings['footer_facebook'] ?? '')?>">
      
      <label>رابط لينكدإن:</label>
      <input type="text" name="footer_linkedin" value="<?=htmlspecialchars($settings['footer_linkedin'] ?? '')?>">
      
      <label>رابط خريطة جوجل (Google Maps):</label>
      <input type="text" name="footer_map" value="<?=htmlspecialchars($settings['footer_map'] ?? '')?>">
      
      <label>نص الحقوق (©):</label>
      <input type="text" name="footer_copyright" value="<?=htmlspecialchars($settings['footer_copyright'] ?? '')?>">
      
      <h3 class="section-title">محتوى الصفحات التعريفية</h3>
      <label>من نحن:</label>
      <textarea name="about_us"><?=htmlspecialchars($settings['about_us'] ?? '')?></textarea>
      
      <label>الرؤية:</label>
      <textarea name="vision"><?=htmlspecialchars($settings['vision'] ?? '')?></textarea>
      
      <label>الرسالة:</label>
      <textarea name="mission"><?=htmlspecialchars($settings['mission'] ?? '')?></textarea>
      
      <button name="save" class="btn">حفظ التعديلات</button>
    </form>
  </div>
</body>
</html>
