<?php
session_start();
if(!isset($_SESSION['admin'])) header("Location: login.php");
require '../config.php';

// جلب الإحصائيات من القاعدة
$services_count = $pdo->query("SELECT COUNT(*) FROM services")->fetchColumn();
$team_count = $pdo->query("SELECT COUNT(*) FROM team")->fetchColumn();
$testimonials_count = $pdo->query("SELECT COUNT(*) FROM testimonials")->fetchColumn();
$appointments_count = $pdo->query("SELECT COUNT(*) FROM appointments")->fetchColumn();
?>

<head>
  <meta charset="UTF-8">
  <title>لوحة التحكم</title>
  <style>
    body { font-family: Tahoma, Arial; background:#f7f8fa;}
    .menu { background:#174832; color:#fff; padding:13px 0; text-align:center; }
    .menu a { color:#ffd700; margin:0 17px; text-decoration:none; font-size:1.2rem;}
    .box { background:#fff; margin:35px auto; padding:33px 22px; border-radius:1.1rem; box-shadow:0 3px 18px #0001; width:90%; max-width:650px;}
    h2 { color:#174832;}
	.dashboard-wrapper {
  max-width: 1200px;
  margin: 40px auto 0 auto;
  padding: 0 18px;
}
.dashboard-cards {
  display: flex;
  flex-wrap: wrap;
  gap: 25px;
  margin-top: 35px;
  margin-bottom: 35px;
}
.dash-card {
  background: #fff;
  border-radius: 1.2rem;
  box-shadow: 0 2px 16px #17483213;
  padding: 25px 24px 18px 24px;
  flex: 1 1 210px;
  display: flex;
  align-items: center;
  min-width: 210px;
  gap: 18px;
  transition: box-shadow .19s;
  border-top: 5px solid #ffd700;
}
.dash-card:hover { box-shadow: 0 6px 18px #17483233; }
.dash-icon {
  width: 64px;
  height: 64px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 2.1rem;
}
.dash-info {
  display: flex;
  flex-direction: column;
  align-items: flex-start;
  gap: 5px;
}
.dash-num {
  font-size: 2.1rem;
  font-weight: bold;
  color: #174832;
}
.dash-title {
  color: #666;
  font-size: 1.09rem;
  font-weight: 600;
  margin-top: 4px;
}
@media (max-width:900px){
  .dashboard-cards { flex-direction:column; gap:17px; }
  .dash-card { min-width: 90%; }
}

  </style>
</head>
<body>
  <div class="menu">
    <a href="index.php">الرئيسية</a>
    <a href="services.php">الخدمات</a>
    <a href="team.php">الفريق</a>
    <a href="testimonials.php">آراء العملاء</a>
    <a href="slider.php">السلايدر</a>
    <a href="appointments.php">الحجوزات</a>
    <a href="settings.php">الإعدادات</a>
    <a href="logout.php">خروج</a>
  </div>
  <div class="box">
    <h2>مرحبا بك في لوحة تحكم مكتب المحامي</h2>
    <p>اختر القسم المطلوب من القائمة بالأعلى لإدارة محتوى الموقع.</p>
	<div class="dashboard-wrapper">
  <h2>لوحة تحكم مكتب المحامي</h2>
  <div class="dashboard-cards">
    <div class="dash-card">
      <div class="dash-icon" style="background:#ffd70020;"><i class="fas fa-gavel" style="color:#ffd700"></i></div>
      <div class="dash-info">
        <div class="dash-num"><?= $services_count ?></div>
        <div class="dash-title">عدد الخدمات</div>
      </div>
    </div>
    <div class="dash-card">
      <div class="dash-icon" style="background:#17483220;"><i class="fas fa-users" style="color:#174832"></i></div>
      <div class="dash-info">
        <div class="dash-num"><?= $team_count ?></div>
        <div class="dash-title">عدد أعضاء الفريق</div>
      </div>
    </div>
    <div class="dash-card">
      <div class="dash-icon" style="background:#15c97c22;"><i class="fas fa-comments" style="color:#15c97c"></i></div>
      <div class="dash-info">
        <div class="dash-num"><?= $testimonials_count ?></div>
        <div class="dash-title">آراء العملاء</div>
      </div>
    </div>
    <div class="dash-card">
      <div class="dash-icon" style="background:#fa585822;"><i class="fas fa-calendar-check" style="color:#fa5858"></i></div>
      <div class="dash-info">
        <div class="dash-num"><?= $appointments_count ?></div>
        <div class="dash-title">الحجوزات</div>
      </div>
    </div>
  </div>
</div>

  </div>
</body>
</html>
