<?php
require_once 'db.php';

// جلب إعدادات الموقع
$settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// جلب الخدمات
$services = $pdo->query("SELECT * FROM services ORDER BY id DESC LIMIT 8")->fetchAll(PDO::FETCH_ASSOC);

// جلب المشاريع
$projects = $pdo->query("SELECT * FROM projects ORDER BY id DESC LIMIT 6")->fetchAll(PDO::FETCH_ASSOC);

// جلب الأخبار
$news = $pdo->query("SELECT * FROM news ORDER BY id DESC LIMIT 3")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= htmlspecialchars($settings['site_name'] ?? 'الشركة الوطنية للبناء') ?></title>
  <link href="https://fonts.googleapis.com/css?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/style.css"><!-- مسار ملف CSS الخاص بك -->
   <style>
    body {
      font-family: 'Cairo', Arial, sans-serif;
      margin: 0;
      background: #f8f9fa;
      color: #222;
      direction: rtl;
    }
    /* الشريط العلوي */
    .navbar {
      background: #fff;
      box-shadow: 0 2px 8px rgba(0,0,0,0.04);
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 18px 32px;
      position: sticky;
      top: 0;
      z-index: 1000;
    }
    .navbar .logo {
      font-weight: bold;
      font-size: 1.6rem;
      color: #013574;
      letter-spacing: 1px;
    }
    .navbar ul {
      list-style: none;
      display: flex;
      gap: 28px;
      margin: 0;
      padding: 0;
    }
    .navbar ul li {
      display: inline-block;
    }
    .navbar a {
      color: #222;
      text-decoration: none;
      font-weight: 500;
      transition: color 0.2s;
    }
    .navbar a:hover, .navbar .active {
      color: #0157a7;
    }
    .lang-btn {
      background: #ececec;
      color: #013574;
      padding: 7px 20px;
      border-radius: 22px;
      border: none;
      cursor: pointer;
      margin-right: 14px;
      font-weight: bold;
    }

    /* بانر رئيسي */
    .hero {
      background: linear-gradient(rgba(1,53,116,0.7), rgba(0,0,0,0.3)), url('https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=1600&q=80') center/cover no-repeat;
      color: #fff;
      text-align: center;
      padding: 90px 10px 110px 10px;
      position: relative;
    }
    .hero h1 {
      font-size: 2.5rem;
      font-weight: bold;
      margin-bottom: 16px;
      letter-spacing: 1.5px;
    }
    .hero p {
      font-size: 1.3rem;
      margin-bottom: 28px;
    }
    .hero .cta-btn {
      background: #FFD700;
      color: #013574;
      font-size: 1.1rem;
      border: none;
      border-radius: 30px;
      padding: 15px 40px;
      font-weight: bold;
      cursor: pointer;
      transition: background 0.2s;
    }
    .hero .cta-btn:hover {
      background: #013574;
      color: #FFD700;
    }

    /* نبذة عن الشركة */
    .about {
      padding: 60px 20px;
      background: #fff;
      text-align: center;
    }
    .about h2 {
      font-size: 2rem;
      color: #013574;
      margin-bottom: 22px;
    }
    .about p {
      font-size: 1.1rem;
      margin-bottom: 36px;
      color: #444;
      max-width: 700px;
      margin-left: auto;
      margin-right: auto;
    }
    .about-icons {
      display: flex;
      justify-content: center;
      gap: 35px;
      flex-wrap: wrap;
    }
    .about-icon {
      background: #f2f6fa;
      border-radius: 16px;
      padding: 26px 28px;
      min-width: 170px;
      text-align: center;
      margin-bottom: 18px;
    }
    .about-icon i {
      font-size: 2.2rem;
      color: #FFD700;
      margin-bottom: 8px;
    }
    .about-icon span {
      display: block;
      font-weight: bold;
      margin-bottom: 7px;
      color: #013574;
    }
    .about-icon small {
      color: #888;
      font-size: 0.95rem;
    }

    /* الخدمات */
    .services {
      padding: 55px 20px 30px 20px;
      background: #f8fafd;
    }
    .services h2 {
      color: #013574;
      text-align: center;
      font-size: 2rem;
      margin-bottom: 34px;
    }
    .service-cards {
      display: flex;
      gap: 28px;
      flex-wrap: wrap;
      justify-content: center;
    }
    .service-card {
      background: #fff;
      box-shadow: 0 2px 8px rgba(1,53,116,0.05);
      border-radius: 16px;
      padding: 36px 28px;
      min-width: 210px;
      text-align: center;
      transition: transform 0.18s;
    }
    .service-card:hover {
      transform: translateY(-7px) scale(1.03);
      box-shadow: 0 6px 18px rgba(1,53,116,0.08);
    }
    .service-card i {
      font-size: 2rem;
      color: #0157a7;
      margin-bottom: 10px;
    }
    .service-card h3 {
      margin: 13px 0 7px 0;
      font-size: 1.15rem;
      color: #013574;
    }
    .service-card p {
      color: #666;
      font-size: 1rem;
      margin: 0;
    }

    /* المشاريع */
    .projects {
      padding: 55px 20px 30px 20px;
      background: #fff;
    }
    .projects h2 {
      color: #013574;
      text-align: center;
      font-size: 2rem;
      margin-bottom: 34px;
    }
    .project-gallery {
      display: flex;
      gap: 24px;
      flex-wrap: wrap;
      justify-content: center;
    }
    .project-card {
      background: #f7f7fb;
      border-radius: 14px;
      box-shadow: 0 2px 8px rgba(1,53,116,0.04);
      min-width: 260px;
      max-width: 320px;
      overflow: hidden;
      margin-bottom: 18px;
      display: flex;
      flex-direction: column;
    }
    .project-card img {
      width: 100%;
      height: 165px;
      object-fit: cover;
    }
    .project-info {
      padding: 17px 16px 13px 16px;
      flex: 1;
    }
    .project-info h4 {
      color: #013574;
      margin: 0 0 7px 0;
      font-size: 1.08rem;
    }
    .project-info p {
      color: #888;
      margin: 0 0 11px 0;
      font-size: 0.96rem;
    }
    .project-info .details-btn {
      background: #013574;
      color: #FFD700;
      border: none;
      border-radius: 20px;
      padding: 7px 24px;
      font-weight: bold;
      cursor: pointer;
      font-size: 0.99rem;
    }

    /* لماذا نحن؟ */
    .whyus {
      background: #f8fafd;
      padding: 50px 20px 35px 20px;
    }
    .whyus h2 {
      color: #013574;
      text-align: center;
      font-size: 2rem;
      margin-bottom: 30px;
    }
    .whyus-cards {
      display: flex;
      justify-content: center;
      gap: 38px;
      flex-wrap: wrap;
    }
    .whyus-card {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 2px 8px rgba(1,53,116,0.06);
      text-align: center;
      padding: 30px 28px;
      min-width: 170px;
    }
    .whyus-card .number {
      font-size: 2.4rem;
      font-weight: bold;
      color: #FFD700;
      margin-bottom: 8px;
    }
    .whyus-card span {
      color: #0157a7;
      font-size: 1.04rem;
    }

    /* آراء العملاء */
    .testimonials {
      background: #fff;
      padding: 50px 20px 30px 20px;
    }
    .testimonials h2 {
      color: #013574;
      text-align: center;
      font-size: 2rem;
      margin-bottom: 35px;
    }
    .testimonial-slider {
      display: flex;
      gap: 18px;
      justify-content: center;
      flex-wrap: wrap;
    }
    .testimonial {
      background: #f8f6ea;
      border-radius: 15px;
      box-shadow: 0 2px 8px rgba(1,53,116,0.04);
      padding: 28px 24px;
      min-width: 230px;
      max-width: 330px;
      text-align: right;
    }
    .testimonial .name {
      color: #013574;
      font-weight: bold;
      margin-top: 11px;
    }
    .testimonial .role {
      color: #888;
      font-size: 0.93rem;
      margin-bottom: 5px;
    }

    /* اتصل بنا */
    .contact {
      background: #f8fafd;
      padding: 60px 20px 40px 20px;
    }
    .contact h2 {
      color: #013574;
      text-align: center;
      font-size: 2rem;
      margin-bottom: 28px;
    }
    .contact-content {
      display: flex;
      flex-wrap: wrap;
      gap: 42px;
      justify-content: center;
      align-items: flex-start;
      margin-top: 30px;
    }
    .contact-form {
      background: #fff;
      border-radius: 13px;
      padding: 36px 28px;
      min-width: 270px;
      box-shadow: 0 2px 8px rgba(1,53,116,0.05);
    }
    .contact-form input, .contact-form textarea {
      width: 100%;
      margin-bottom: 16px;
      padding: 12px;
      border-radius: 9px;
      border: 1px solid #e4e4e4;
      font-size: 1rem;
      font-family: 'Cairo', Arial, sans-serif;
      box-sizing: border-box;
      background: #fafbfc;
    }
    .contact-form textarea { resize: vertical; min-height: 90px; }
    .contact-form button {
      background: #013574;
      color: #FFD700;
      font-weight: bold;
      border: none;
      border-radius: 22px;
      padding: 11px 36px;
      cursor: pointer;
      font-size: 1.04rem;
      transition: background 0.2s;
    }
    .contact-form button:hover { background: #0157a7; }
    .contact-details {
      background: #fff;
      border-radius: 13px;
      padding: 36px 28px;
      min-width: 210px;
      box-shadow: 0 2px 8px rgba(1,53,116,0.05);
      font-size: 1.1rem;
      color: #222;
    }
    .contact-details .item {
      margin-bottom: 18px;
      display: flex;
      align-items: center;
      gap: 10px;
      color: #013574;
    }
    .contact-details .item i {
      font-size: 1.3rem;
      color: #FFD700;
    }
    .map {
      margin-top: 16px;
      width: 100%;
      height: 180px;
      border-radius: 10px;
      border: none;
    }

    /* الفوتر */
    footer {
      background: #013574;
      color: #fff;
      padding: 28px 0 20px 0;
      text-align: center;
    }
    footer .footer-links {
      margin-bottom: 12px;
    }
    footer .footer-links a {
      color: #FFD700;
      margin: 0 12px;
      text-decoration: none;
      font-weight: bold;
      font-size: 1.01rem;
    }
    footer .footer-links a:hover {
      text-decoration: underline;
      color: #fff;
    }
    footer .footer-social {
      margin-bottom: 14px;
    }
    footer .footer-social a {
      display: inline-block;
      margin: 0 7px;
      color: #FFD700;
      font-size: 1.24rem;
      transition: color 0.2s;
    }
    footer .footer-social a:hover { color: #fff; }

    /* واتساب عائم */
    .whatsapp-float {
      position: fixed;
      bottom: 28px;
      left: 28px;
      background: #25d366;
      color: #fff;
      border-radius: 50%;
      width: 58px;
      height: 58px;
      display: flex;
      justify-content: center;
      align-items: center;
      font-size: 2rem;
      box-shadow: 0 4px 18px rgba(0,0,0,0.17);
      z-index: 999;
      cursor: pointer;
    }

    /* استجابة للموبايل */
    @media (max-width: 900px) {
      .about-icons, .service-cards, .whyus-cards, .project-gallery, .testimonial-slider, .contact-content {
        flex-direction: column;
        align-items: center;
        gap: 18px !important;
      }
      .navbar {
        flex-direction: column;
        gap: 14px;
        padding: 13px 7px;
      }
      .navbar ul {
        gap: 14px;
      }
      .hero {
        padding: 70px 7px 65px 7px;
      }
    }
  </style>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
</head>
<body>

<!-- الشريط العلوي -->
<nav class="navbar">
  <div class="logo">
    <?php if (!empty($settings['logo'])): ?>
      <img src="uploads/<?= htmlspecialchars($settings['logo']) ?>" style="height:36px;vertical-align:middle;margin-left:8px;border-radius:6px;">
    <?php endif; ?>
    <?= htmlspecialchars($settings['site_name'] ?? "الشركة الوطنية للبناء") ?>
  </div>
  <ul>
    <li><a href="#about">من نحن</a></li>
    <li><a href="#services">الخدمات</a></li>
    <li><a href="#projects">المشاريع</a></li>
    <li><a href="#news">الأخبار</a></li>
    <li><a href="#contact">اتصل بنا</a></li>
  </ul>
  <button class="lang-btn">EN</button>
</nav>

<!-- بانر رئيسي -->
<section class="hero">
  <h1><?= htmlspecialchars($settings['site_headline'] ?? "نحو بناء مستقبل مشرق") ?></h1>
  <p><?= htmlspecialchars($settings['site_subtitle'] ?? "نلتزم بالاحترافية والجودة في تقديم حلول البناء والمقاولات لعملائنا الكرام في مختلف أنحاء المملكة.") ?></p>
  <button class="cta-btn" onclick="window.location='#contact'">تواصل معنا</button>
</section>

<!-- من نحن -->
<section id="about" class="about">
  <h2>من نحن</h2>
  <p><?= nl2br(htmlspecialchars($settings['about_us'] ?? "الشركة الوطنية للبناء تقدم خبرة عريقة في تنفيذ المشاريع الإنشائية المتنوعة، مع التركيز على الإبداع والجودة والالتزام بمواعيد التسليم.")) ?></p>
  <div class="about-icons">
    <div class="about-icon">
      <i class="fas fa-eye"></i>
      <span>رؤيتنا</span>
      <small><?= htmlspecialchars($settings['vision'] ?? "") ?></small>
    </div>
    <div class="about-icon">
      <i class="fas fa-bullseye"></i>
      <span>رسالتنا</span>
      <small><?= htmlspecialchars($settings['mission'] ?? "") ?></small>
    </div>
    <div class="about-icon">
      <i class="fas fa-handshake"></i>
      <span>قيمنا</span>
      <small><?= htmlspecialchars($settings['values'] ?? "") ?></small>
    </div>
  </div>
</section>

<!-- خدماتنا -->
<section id="services" class="services">
  <h2>خدماتنا</h2>
  <div class="service-cards">
    <?php foreach($services as $srv): ?>
      <div class="service-card">
        <i class="fa-solid fa-<?= htmlspecialchars($srv['icon']) ?>"></i>
        <h3><?= htmlspecialchars($srv['name']) ?></h3>
        <p><?= htmlspecialchars($srv['short_desc']) ?></p>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<!-- مشاريعنا -->
<section id="projects" class="projects">
  <h2>مشاريعنا</h2>
  <div class="project-gallery">
    <?php foreach($projects as $proj): ?>
      <div class="project-card">
        <img src="uploads/projects/<?= htmlspecialchars($proj['image']) ?>" alt="<?= htmlspecialchars($proj['title']) ?>">
        <div class="project-info">
          <h4><?= htmlspecialchars($proj['title']) ?></h4>
          <p><?= htmlspecialchars($proj['city']) ?></p>
          <button class="details-btn" onclick="window.location='project.php?id=<?= $proj['id'] ?>'">تفاصيل</button>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<!-- الأخبار -->
<section id="news" class="projects">
  <h2>الأخبار</h2>
  <div class="project-gallery">
    <?php foreach($news as $item): ?>
      <div class="project-card">
        <?php if (!empty($item['image'])): ?>
          <img src="uploads/news/<?= htmlspecialchars($item['image']) ?>" alt="<?= htmlspecialchars($item['title']) ?>">
        <?php endif; ?>
        <div class="project-info">
          <h4><?= htmlspecialchars($item['title']) ?></h4>
          <p><?= htmlspecialchars(mb_substr(strip_tags($item['details']),0,60)).' ...' ?></p>
          <button class="details-btn" onclick="window.location='news.php?id=<?= $item['id'] ?>'">تفاصيل</button>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<!-- اتصل بنا -->
<section id="contact" class="contact">
  <h2>اتصل بنا</h2>
  <div class="contact-content">
    <form class="contact-form" method="post" action="contact_send.php">
      <input type="text" name="name" placeholder="الاسم الكامل" required>
      <input type="email" name="email" placeholder="البريد الإلكتروني" required>
      <textarea name="message" placeholder="رسالتك" required></textarea>
      <button type="submit">إرسال</button>
    </form>
    <div class="contact-details">
      <div class="item"><i class="fas fa-phone"></i> <?= htmlspecialchars($settings['phone'] ?? "") ?></div>
      <div class="item"><i class="fas fa-envelope"></i> <?= htmlspecialchars($settings['email'] ?? "") ?></div>
      <div class="item"><i class="fas fa-map-marker-alt"></i> <?= htmlspecialchars($settings['address'] ?? "") ?></div>
      <iframe class="map" src="https://maps.google.com/maps?q=<?= urlencode($settings['address'] ?? 'riyadh, saudi arabia') ?>&t=&z=13&ie=UTF8&iwloc=&output=embed"></iframe>
    </div>
  </div>
</section>

<!-- الفوتر -->
<footer>
  <div class="footer-links">
    <a href="#about">من نحن</a> |
    <a href="#services">الخدمات</a> |
    <a href="#projects">المشاريع</a> |
    <a href="#news">الأخبار</a> |
    <a href="#contact">اتصل بنا</a>
  </div>
  <div class="footer-social">
    <?php if (!empty($settings['whatsapp'])): ?>
      <a href="https://wa.me/<?= htmlspecialchars($settings['whatsapp']) ?>" target="_blank"><i class="fab fa-whatsapp"></i></a>
    <?php endif; ?>
    <?php if (!empty($settings['twitter'])): ?>
      <a href="<?= htmlspecialchars($settings['twitter']) ?>" target="_blank"><i class="fab fa-twitter"></i></a>
    <?php endif; ?>
    <?php if (!empty($settings['linkedin'])): ?>
      <a href="<?= htmlspecialchars($settings['linkedin']) ?>" target="_blank"><i class="fab fa-linkedin"></i></a>
    <?php endif; ?>
    <?php if (!empty($settings['facebook'])): ?>
      <a href="<?= htmlspecialchars($settings['facebook']) ?>" target="_blank"><i class="fab fa-facebook"></i></a>
    <?php endif; ?>
    <?php if (!empty($settings['instagram'])): ?>
      <a href="<?= htmlspecialchars($settings['instagram']) ?>" target="_blank"><i class="fab fa-instagram"></i></a>
    <?php endif; ?>
  </div>
  <div>
    <?= htmlspecialchars($settings['footer_text'] ?? "جميع الحقوق محفوظة &copy; 2025 الشركة الوطنية للبناء") ?>
  </div>
</footer>

<!-- زر واتساب عائم -->
<?php if (!empty($settings['whatsapp'])): ?>
<a href="https://wa.me/<?= htmlspecialchars($settings['whatsapp']) ?>" target="_blank" class="whatsapp-float">
  <i class="fab fa-whatsapp"></i>
</a>
<?php endif; ?>
</body>
</html>
