<?php
// الاتصال بقاعدة البيانات
require_once 'db.php';

// استقبال البيانات من النموذج
$name    = trim($_POST['name'] ?? '');
$email   = trim($_POST['email'] ?? '');
$message = trim($_POST['message'] ?? '');

// تحقق من الحقول المطلوبة
$errors = [];
if (empty($name))    $errors[] = "يرجى إدخال الاسم";
if (empty($email))   $errors[] = "يرجى إدخال البريد الإلكتروني";
if (empty($message)) $errors[] = "يرجى كتابة الرسالة";
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "البريد الإلكتروني غير صحيح";

if (count($errors) > 0) {
    // إعادة التوجيه مع رسالة خطأ (يمكنك التعديل حسب واجهتك)
    header("Location: contact.php?error=" . urlencode(implode(", ", $errors)));
    exit;
}

// إدراج الرسالة في قاعدة البيانات
$stmt = $pdo->prepare("INSERT INTO contact_messages (name, email, message, created_at) VALUES (?, ?, ?, NOW())");
$stmt->execute([$name, $email, $message]);

// (اختياري) إرسال إشعار عبر الإيميل
// mail('youremail@example.com', "رسالة جديدة من الموقع", "من: $name\nالبريد: $email\n\nالمحتوى:\n$message");

// إعادة التوجيه لصفحة الشكر
header("Location: contact.php?success=1");
exit;
?>
