<?php
require_once '../db.php';
$edit = null;

// التحقق من وجود عملية تعديل
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $stmt = $pdo->prepare("SELECT * FROM team WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch();
}

// إضافة أو تعديل عضو فريق
if (isset($_POST['save_team'])) {
    $name = trim($_POST['name']);
    $role = trim($_POST['role']);
    $bio = trim($_POST['bio']);

    // صورة العضو
    $image = $edit['image'] ?? '';
    if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
        $file = $_FILES['image'];
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp','gif'];
        if (in_array($ext, $allowed)) {
            $filename = uniqid('team_') . '.' . $ext;
            $path = "../uploads/team/" . $filename;
            if (move_uploaded_file($file['tmp_name'], $path)) {
                $image = $filename;
            }
        }
    }

    if ($edit) {
        $stmt = $pdo->prepare("UPDATE team SET name=?, role=?, image=?, bio=? WHERE id=?");
        $stmt->execute([$name, $role, $image, $bio, $edit['id']]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO team (name, role, image, bio, created_at) VALUES (?, ?, ?, ?, NOW())");
        $stmt->execute([$name, $role, $image, $bio]);
    }
    echo "<script>location.href='team.php';</script>";
    exit;
}

// حذف عضو
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM team WHERE id=?");
    $stmt->execute([$id]);
    echo "<script>location.href='team.php';</script>";
    exit;
}

// جلب كل الأعضاء
$stmt = $pdo->query("SELECT * FROM team ORDER BY id DESC");
$teamList = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة فريق العمل</title>
    <link rel="stylesheet" href="../admin-style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body { font-family: 'Cairo', Arial, sans-serif; background: #f8fafd; margin: 0; }
        .manage-box { background: #fff; margin: 40px auto 0; border-radius: 18px; max-width: 650px; padding: 36px 30px 28px 30px; box-shadow: 0 2px 16px rgba(1,53,116,0.08);}
        .manage-box h2 { margin-bottom: 18px; color: #013574; font-size: 1.45rem; text-align:right;}
        .manage-box input, .manage-box textarea { width: 100%; margin-bottom: 13px; border-radius: 8px; border: 1px solid #e3e3e3; padding: 11px; font-size: 1rem; background: #f7f8fa;}
        .manage-box button { background: #FFD700; color: #013574; border: none; border-radius: 25px; padding: 11px 40px; font-size: 1.1rem; font-weight: bold; cursor: pointer; transition: 0.2s;}
        .manage-box button:hover { background: #013574; color: #FFD700; }
        .manage-box label { font-weight:bold; margin-bottom:5px; display:block; color:#555;}
        .table-wrap { background:#fff; margin:35px auto; border-radius: 18px; box-shadow:0 2px 10px rgba(1,53,116,0.05); max-width:1100px; padding:26px 25px;}
        table { width:100%; border-collapse:collapse;}
        th, td { padding:13px 8px; border-bottom:1px solid #f1f1f1;}
        th { background:#f8fafd; color:#013574; font-weight:bold;}
        td img { width:50px; border-radius:8px;}
        .actions button, .actions a { background:#FFD700; color:#013574; border:none; border-radius:14px; padding:7px 15px; font-weight:bold; margin-left:5px; text-decoration:none; }
        .actions button:hover, .actions a:hover { background:#013574; color:#FFD700;}
        @media(max-width:700px){ .table-wrap, .manage-box{padding:12px 7px;} th,td{font-size:0.98rem;} }
    </style>
</head>
<body>
    <div class="manage-box">
        <h2><?= $edit ? "تعديل عضو" : "إضافة عضو جديد" ?></h2>
        <form method="post" enctype="multipart/form-data">
            <label>اسم العضو</label>
            <input type="text" name="name" required value="<?= $edit['name'] ?? '' ?>">
            <label>الوظيفة</label>
            <input type="text" name="role" required value="<?= $edit['role'] ?? '' ?>">
            <label>نبذة قصيرة</label>
            <textarea name="bio" rows="2"><?= $edit['bio'] ?? '' ?></textarea>
            <label>الصورة الشخصية</label>
            <input type="file" name="image">
            <?php if($edit && $edit['image']) { ?>
                <img src="../uploads/team/<?= $edit['image'] ?>" style="width:50px;border-radius:8px;">
            <?php } ?>
            <button type="submit" name="save_team"><?= $edit ? "تعديل العضو" : "إضافة العضو" ?></button>
            <?php if($edit){ ?>
                <a href="team.php" style="margin-right:14px;">إلغاء</a>
            <?php } ?>
        </form>
    </div>

    <div class="table-wrap">
        <h3 style="margin-bottom:18px;color:#013574;">قائمة فريق العمل</h3>
        <table>
            <tr>
                <th>م</th>
                <th>الصورة</th>
                <th>الاسم</th>
                <th>الوظيفة</th>
                <th>نبذة</th>
                <th>إجراءات</th>
            </tr>
            <?php $i=1; foreach($teamList as $member): ?>
            <tr>
                <td><?= $i++ ?></td>
                <td><?php if($member['image']){ ?><img src="../uploads/team/<?= $member['image'] ?>"><?php } ?></td>
                <td><?= htmlspecialchars($member['name']) ?></td>
                <td><?= htmlspecialchars($member['role']) ?></td>
                <td><?= htmlspecialchars($member['bio']) ?></td>
                <td class="actions">
                    <a href="team.php?edit=<?= $member['id'] ?>">تعديل</a>
                    <a href="team.php?delete=<?= $member['id'] ?>" onclick="return confirm('هل أنت متأكد من حذف العضو؟')">حذف</a>
                </td>
            </tr>
            <?php endforeach; ?>
            <?php if(!$teamList){ ?>
            <tr><td colspan="6" style="text-align:center;">لا يوجد أعضاء حالياً.</td></tr>
            <?php } ?>
        </table>
    </div>
</body>
</html>
