<?php
require_once '../db.php';
$settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

if (isset($_POST['save'])) {
    $site_name = $_POST['site_name'];
    $logo = $settings['logo'];
    if (isset($_FILES['logo']) && $_FILES['logo']['name'] != '') {
        $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
        $logo = uniqid().'.'.$ext;
        move_uploaded_file($_FILES['logo']['tmp_name'], "../uploads/".$logo);
    }
    $phone = $_POST['phone'];
    $email = $_POST['site_email'];
    $address = $_POST['address'];
    $facebook = $_POST['facebook'];
    $twitter = $_POST['twitter'];
    $instagram = $_POST['instagram'];
    $linkedin = $_POST['linkedin'];
    $whatsapp = $_POST['whatsapp'];
    $footer_text = $_POST['footer_text'];

    // الحقول الجديدة
    $about = $_POST['about'];
    $about_icon = $_POST['about_icon'];
    $vision = $_POST['vision'];
    $vision_icon = $_POST['vision_icon'];
    $mission = $_POST['mission'];
    $mission_icon = $_POST['mission_icon'];
    $values = $_POST['values'];
    $values_icon = $_POST['values_icon'];

 $stmt = $pdo->prepare("UPDATE settings SET 
    site_name=?, logo=?, phone=?, site_email=?, address=?, facebook=?, twitter=?, instagram=?, linkedin=?, whatsapp=?, footer_text=?,
    about=?, about_icon=?, vision=?, vision_icon=?, mission=?, mission_icon=?, `values`=?, values_icon=?
    WHERE id=1
");
    $stmt->execute([
        $site_name, $logo, $phone, $email, $address, $facebook, $twitter, $instagram, $linkedin, $whatsapp, $footer_text,
        $about, $about_icon, $vision, $vision_icon, $mission, $mission_icon, $values, $values_icon
    ]);
    header("Location: settings.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إعدادات الموقع</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Cairo', Arial, sans-serif; background: #f5f6fa; margin:0; padding:0;}
        form { background: #fff; max-width: 600px; margin: 40px auto; padding: 32px 24px 18px 24px; border-radius: 14px; box-shadow:0 2px 12px #0002; }
        label { margin: 6px 0 2px 0; display:block; font-size:1.1em; color:#107452; font-weight:bold;}
        input, button { display:block; width:100%; margin-bottom:18px; padding:9px 12px; font-size:1.05em; border-radius:8px; border:1px solid #d1d7e0;}
        input[type=file] { border: none; }
        button { background:#107452; color:#fff; border:none; font-weight:bold; letter-spacing:2px; transition:.2s;}
        button:hover { background:#0c5d41; }
        .logo-preview {margin-bottom:15px;}
        .logo-preview img {max-width:120px; max-height:60px; border-radius: 5px;}
    </style>
</head>
<body>
<form method="post" enctype="multipart/form-data">
    <label>اسم الموقع</label>
    <input type="text" name="site_name" value="<?= htmlspecialchars($settings['site_name'] ?? '') ?>" placeholder="اسم موقعك">

    <label>شعار الموقع (Logo)</label>
    <?php if(!empty($settings['logo'])): ?>
      <div class="logo-preview"><img src="../uploads/<?= htmlspecialchars($settings['logo']) ?>" alt="شعار الموقع"></div>
    <?php endif; ?>
    <input type="file" name="logo">
<!-- من نحن -->
<label>من نحن</label>
<textarea name="about"><?= htmlspecialchars($settings['about'] ?? '') ?></textarea>
<label>أيقونة من نحن (مثال: fa-building)</label>
<input type="text" name="about_icon" value="<?= htmlspecialchars($settings['about_icon'] ?? 'fa-building') ?>">

<!-- رؤيتنا -->
<label>رؤيتنا</label>
<textarea name="vision"><?= htmlspecialchars($settings['vision'] ?? '') ?></textarea>
<label>أيقونة الرؤية (مثال: fa-eye)</label>
<input type="text" name="vision_icon" value="<?= htmlspecialchars($settings['vision_icon'] ?? 'fa-eye') ?>">

<!-- رسالتنا -->
<label>رسالتنا</label>
<textarea name="mission"><?= htmlspecialchars($settings['mission'] ?? '') ?></textarea>
<label>أيقونة الرسالة (مثال: fa-bullseye)</label>
<input type="text" name="mission_icon" value="<?= htmlspecialchars($settings['mission_icon'] ?? 'fa-bullseye') ?>">

<!-- قيمنا -->
<label>قيمنا</label>
<textarea name="values"><?= htmlspecialchars($settings['values'] ?? '') ?></textarea>
<label>أيقونة القيم (مثال: fa-handshake)</label>
<input type="text" name="values_icon" value="<?= htmlspecialchars($settings['values_icon'] ?? 'fa-handshake') ?>">

    <label>الجوال</label>
    <input name="phone" value="<?= htmlspecialchars($settings['phone'] ?? '') ?>" placeholder="الجوال">

    <label>البريد الإلكتروني</label>
    <input type="text" name="site_email" value="<?= htmlspecialchars($settings['site_email'] ?? '') ?>" placeholder="البريد الإلكتروني">

    <label>العنوان</label>
    <input name="address" value="<?= htmlspecialchars($settings['address'] ?? '') ?>" placeholder="العنوان">

    <label>فيسبوك</label>
    <input type="text" name="facebook" value="<?= htmlspecialchars($settings['facebook'] ?? '') ?>" placeholder="facebook">

    <label>تويتر</label>
    <input name="twitter" value="<?= htmlspecialchars($settings['twitter'] ?? '') ?>" placeholder="Twitter">

    <label>انستجرام</label>
    <input name="instagram" value="<?= htmlspecialchars($settings['instagram'] ?? '') ?>" placeholder="Instagram">

    <label>لينكدإن</label>
    <input name="linkedin" value="<?= htmlspecialchars($settings['linkedin'] ?? '') ?>" placeholder="Linkedin">

    <label>واتساب</label>
    <input name="whatsapp" value="<?= htmlspecialchars($settings['whatsapp'] ?? '') ?>" placeholder="Whatsapp">

    <label>نص الفوتر</label>
    <input name="footer_text" value="<?= htmlspecialchars($settings['footer_text'] ?? '') ?>" placeholder="نص الفوتر">

    <button name="save">حفظ</button>
</form>
</body>
</html>
