<?php
require_once '../db.php';

// --- إضافة أو تعديل خدمة ---
$edit = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $stmt = $pdo->prepare("SELECT * FROM services WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch();
}
if (isset($_POST['save_service'])) {
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    $icon = isset($_POST['icon']) ? trim($_POST['icon']) : '';
    $short_desc = isset($_POST['short_desc']) ? trim($_POST['short_desc']) : '';
    $details = isset($_POST['details']) ? trim($_POST['details']) : '';

    $stmt = $pdo->prepare("INSERT INTO services (name, icon, short_desc, details) VALUES (?, ?, ?, ?)");
    $stmt->execute([$name, $icon, $short_desc, $details]);

    echo "<script>location.href='services.php';</script>";
    exit;
}

// --- حذف خدمة ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM services WHERE id=?");
    $stmt->execute([$id]);
    echo "<script>location.href='services.php';</script>";
    exit;
}

// --- جلب جميع الخدمات للعرض ---
$stmt = $pdo->query("SELECT * FROM services ORDER BY id DESC");
$services = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة الخدمات</title>
    <link rel="stylesheet" href="../assets/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        .manage-box { max-width: 600px; margin: 40px auto; background: #fff; border-radius: 13px; box-shadow: 0 2px 8px #0a224010; padding: 32px 24px; }
        .manage-box h2 { margin-bottom: 22px; color: #013574; }
        .manage-box input, .manage-box textarea { width: 100%; margin-bottom: 13px; padding: 10px; border-radius: 8px; border: 1px solid #eee; font-family: 'Cairo', Arial, sans-serif;}
        .manage-box button, .manage-box a { background: #FFD700; color: #0a2240; border: none; border-radius: 13px; padding: 8px 24px; font-weight: bold; font-size: 1rem; cursor: pointer; text-decoration: none; margin-top: 6px;}
        .manage-box button:hover { background: #0a2240; color: #FFD700;}
        .manage-box table { width: 100%; border-collapse: collapse; margin-top: 28px;}
        .manage-box th, .manage-box td { padding: 9px 5px; border-bottom: 1px solid #eee;}
        .manage-box th { background: #f8fafd; color: #0a2240;}
        .manage-box tr:last-child td { border-bottom: none;}
        .manage-box i.fa-solid { font-size: 1.4rem; color: #0157a7; }
        .manage-box .actions a { margin-left: 7px; }
    </style>
</head>
<body>
    <div class="manage-box">
        <h2><?= $edit ? "تعديل خدمة" : "إضافة خدمة جديدة" ?></h2>
        <form method="post">
            <input type="text" name="title" placeholder="اسم الخدمة" required value="<?= $edit['name'] ?? '' ?>">
            <input type="text" name="icon" placeholder="أيقونة (مثال: fa-solid fa-star)" value="<?= $edit['icon'] ?? '' ?>">
            <textarea name="short_desc" placeholder="وصف مختصر"><?= $edit['short_desc'] ?? '' ?></textarea>
            <textarea name="details" placeholder="تفاصيل الخدمة"><?= $edit['details'] ?? '' ?></textarea>
            <button name="save_service" type="submit"><?= $edit ? 'تحديث الخدمة' : 'إضافة خدمة' ?></button>
            <?php if ($edit): ?>
                <a href="services.php">إلغاء</a>
            <?php endif; ?>
        </form>
        <h3 style="margin-top:35px;">قائمة الخدمات</h3>
        <table>
            <tr>
                <th>م</th>
                <th>اسم الخدمة</th>
                <th>الأيقونة</th>
                <th>الوصف المختصر</th>
                <th>إجراءات</th>
            </tr>
            <?php foreach ($services as $srv): ?>
            <tr>
                <td><?= $srv['id'] ?></td>
<td><?= htmlspecialchars($srv['name'] ?? '') ?></td>
                <td><?php if($srv['icon']): ?><i class="<?= htmlspecialchars($srv['icon']) ?>"></i><?php endif; ?></td>
                <td><?= htmlspecialchars($srv['short_desc']) ?></td>
                <td class="actions">
                    <a href="?edit=<?= $srv['id'] ?>">تعديل</a>
                    <a href="?delete=<?= $srv['id'] ?>" onclick="return confirm('حذف الخدمة؟')">حذف</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
