<?php
require_once '../db.php';

// عملية الحذف
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM projects WHERE id=?");
    $stmt->execute([$id]);
    echo "<script>location.href='projects.php';</script>";
    exit;
}

// إضافة مشروع جديد
if (isset($_POST['add'])) {
    $name = trim($_POST['name']);
    $city = trim($_POST['city']);
    $short_desc = trim($_POST['short_desc']);
    $details = trim($_POST['details']);
    $image = '';

    // معالجة الصورة
    if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
        $file = $_FILES['image'];
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp','gif'];
        if (in_array($ext, $allowed)) {
            $filename = uniqid('proj_') . '.' . $ext;
            $path = "../uploads/projects/" . $filename;
            if (move_uploaded_file($file['tmp_name'], $path)) {
                $image = $filename;
            }
        }
    }

    $stmt = $pdo->prepare("INSERT INTO projects (title, city, image, short_desc, details) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$name, $city, $image, $short_desc, $details]);
    echo "<script>location.href='projects.php';</script>";
    exit;
}

// جلب جميع المشاريع
$stmt = $pdo->query("SELECT * FROM projects ORDER BY id DESC");
$projects = $stmt->fetchAll();
?>

<!-- تنسيقات بسيطة -->
<link href="https://fonts.googleapis.com/css?family=Cairo:400,600,700&display=swap" rel="stylesheet">
<style>
body { font-family: 'Cairo', Arial, sans-serif; background: #f6f7fa; }
.form-box { background: #fff; border-radius: 10px; padding: 18px 14px; margin: 22px 0; box-shadow: 0 2px 7px #eee;}
.form-box input, .form-box textarea { width:100%; margin-bottom:13px; padding:8px 10px; border-radius:7px; border:1px solid #eee;}
.form-box button { background:#013574; color:#FFD700; padding: 8px 26px; border-radius: 12px; border:none; font-weight:bold;}
.table-box { background:#fff; border-radius:10px; box-shadow:0 2px 7px #eee; padding:12px; }
table { width:100%; border-collapse:collapse;}
th, td { padding:10px; border-bottom:1px solid #f1f1f1; text-align:center;}
th { background:#f8f9fa; color:#013574; }
.img-thumb { width:54px; height:44px; object-fit:cover; border-radius:5px; }
.btn { padding:5px 16px; border-radius:9px; border:none; background:#FFD700; color:#013574; font-weight:bold; }
.btn:hover { background:#013574; color:#FFD700;}
</style>

<div class="form-box">
  <h2>إضافة مشروع جديد</h2>
  <form method="post" enctype="multipart/form-data">
    <input type="text" name="name" placeholder="اسم المشروع" required>
    <input type="text" name="city" placeholder="المدينة" required>
    <input type="file" name="image" accept="image/*">
    <textarea name="short_desc" placeholder="وصف مختصر للمشروع" required></textarea>
    <textarea name="details" placeholder="تفاصيل المشروع" rows="4" required></textarea>
    <button type="submit" name="add">إضافة</button>
  </form>
</div>

<div class="table-box">
  <h3>قائمة المشاريع</h3>
  <table>
    <tr>
      <th>صورة المشروع</th>
      <th>اسم المشروع</th>
      <th>المدينة</th>
      <th>وصف مختصر</th>
      <th>إجراءات</th>
    </tr>
    <?php foreach($projects as $row): ?>
      <tr>
        <td>
          <?php if($row['image']): ?>
            <img src="../uploads/projects/<?= htmlspecialchars($row['image']) ?>" class="img-thumb">
          <?php else: ?>
            -
          <?php endif; ?>
        </td>
        <td><?= htmlspecialchars($row['title']) ?></td>
        <td><?= htmlspecialchars($row['city']) ?></td>
        <td><?= htmlspecialchars($row['short_desc']) ?></td>
        <td>
          <a href="?edit=<?= $row['id'] ?>" class="btn">تعديل</a>
          <a href="?delete=<?= $row['id'] ?>" class="btn" onclick="return confirm('تأكيد الحذف؟')">حذف</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </table>
</div>
