<?php
require_once '../db.php';

// عملية تعديل
$edit = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $stmt = $pdo->prepare("SELECT * FROM gallery WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch();
}

// إضافة أو تعديل صورة
if (isset($_POST['save_gallery'])) {
    $title = trim($_POST['title']);
    $image = $edit['image'] ?? '';
    if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
        $file = $_FILES['image'];
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp','gif'];
        if (in_array($ext, $allowed)) {
            $filename = uniqid('gallery_') . '.' . $ext;
            $path = "../uploads/gallery/" . $filename;
            if (move_uploaded_file($file['tmp_name'], $path)) {
                $image = $filename;
            }
        }
    }
    if ($edit) {
        $stmt = $pdo->prepare("UPDATE gallery SET title=?, image=? WHERE id=?");
        $stmt->execute([$title, $image, $edit['id']]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO gallery (title, image, created_at) VALUES (?, ?, NOW())");
        $stmt->execute([$title, $image]);
    }
    echo "<script>location.href='gallery.php';</script>";
    exit;
}

// حذف صورة
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM gallery WHERE id=?");
    $stmt->execute([$id]);
    echo "<script>location.href='gallery.php';</script>";
    exit;
}

$stmt = $pdo->query("SELECT * FROM gallery ORDER BY id DESC");
$galleryList = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة معرض الصور</title>
    <link rel="stylesheet" href="../admin-style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body { font-family: 'Cairo', Arial, sans-serif; background: #f8fafd; margin: 0; }
        .manage-box { background: #fff; margin: 40px auto 0; border-radius: 18px; max-width: 650px; padding: 36px 30px 28px 30px; box-shadow: 0 2px 16px rgba(1,53,116,0.08);}
        .manage-box h2 { margin-bottom: 18px; color: #013574; font-size: 1.45rem; text-align:right;}
        .manage-box input { width: 100%; margin-bottom: 13px; border-radius: 8px; border: 1px solid #e3e3e3; padding: 11px; font-size: 1rem; background: #f7f8fa;}
        .manage-box button { background: #FFD700; color: #013574; border: none; border-radius: 25px; padding: 11px 40px; font-size: 1.1rem; font-weight: bold; cursor: pointer; transition: 0.2s;}
        .manage-box button:hover { background: #013574; color: #FFD700; }
        .manage-box label { font-weight:bold; margin-bottom:5px; display:block; color:#555;}
        .manage-box img { margin-bottom:10px; border-radius:8px; width: 50px; }
        .table-wrap { background:#fff; margin:35px auto; border-radius: 18px; box-shadow:0 2px 10px rgba(1,53,116,0.05); max-width:1100px; padding:26px 25px;}
        table { width:100%; border-collapse:collapse;}
        th, td { padding:13px 8px; border-bottom:1px solid #f1f1f1;}
        th { background:#f8fafd; color:#013574; font-weight:bold;}
        td img { width:60px; border-radius:8px;}
        .actions a { background:#FFD700; color:#013574; border:none; border-radius:14px; padding:7px 15px; font-weight:bold; margin-left:5px; text-decoration:none; }
        .actions a:hover { background:#013574; color:#FFD700;}
        @media(max-width:700px){ .table-wrap, .manage-box{padding:12px 7px;} th,td{font-size:0.98rem;} }
    </style>
</head>
<body>
    <div class="manage-box">
        <h2><?= $edit ? "تعديل صورة" : "إضافة صورة جديدة" ?></h2>
        <form method="post" enctype="multipart/form-data">
            <label>عنوان الصورة</label>
            <input type="text" name="title" required value="<?= $edit['title'] ?? '' ?>">
            <label>الصورة</label>
            <input type="file" name="image">
            <?php if($edit && $edit['image']) { ?>
                <img src="../uploads/gallery/<?= $edit['image'] ?>">
            <?php } ?>
            <button type="submit" name="save_gallery"><?= $edit ? "تعديل الصورة" : "إضافة الصورة" ?></button>
            <?php if($edit){ ?>
                <a href="gallery.php" style="margin-right:14px;">إلغاء</a>
            <?php } ?>
        </form>
    </div>

    <div class="table-wrap">
        <h3 style="margin-bottom:18px;color:#013574;">معرض الصور</h3>
        <table>
            <tr>
                <th>م</th>
                <th>الصورة</th>
                <th>عنوان الصورة</th>
                <th>إجراءات</th>
            </tr>
            <?php $i=1; foreach($galleryList as $img): ?>
            <tr>
                <td><?= $i++ ?></td>
                <td><?php if($img['image']){ ?><img src="../uploads/gallery/<?= $img['image'] ?>"><?php } ?></td>
                <td><?= htmlspecialchars($img['title']) ?></td>
                <td class="actions">
                    <a href="gallery.php?edit=<?= $img['id'] ?>">تعديل</a>
                    <a href="gallery.php?delete=<?= $img['id'] ?>" onclick="return confirm('حذف الصورة؟')">حذف</a>
                </td>
            </tr>
            <?php endforeach; ?>
            <?php if(!$galleryList){ ?>
            <tr><td colspan="4" style="text-align:center;">لا توجد صور حالياً.</td></tr>
            <?php } ?>
        </table>
    </div>
</body>
</html>
