<?php
require_once '../db.php';

// إضافة أو تعديل صفحة
$page = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $stmt = $pdo->prepare("SELECT * FROM content_pages WHERE id=?");
    $stmt->execute([$id]);
    $page = $stmt->fetch();
}

if (isset($_POST['save_page'])) {
    $title = trim($_POST['title']);
    $slug = trim($_POST['slug']);
    $content = trim($_POST['content']);

    if ($page) {
        // تعديل
        $stmt = $pdo->prepare("UPDATE content_pages SET title=?, slug=?, content=? WHERE id=?");
        $stmt->execute([$title, $slug, $content, $page['id']]);
    } else {
        // إضافة
        $stmt = $pdo->prepare("INSERT INTO content_pages (title, slug, content) VALUES (?, ?, ?)");
        $stmt->execute([$title, $slug, $content]);
    }
    echo "<script>location.href='content_pages.php';</script>";
    exit;
}

// حذف صفحة
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM content_pages WHERE id=?");
    $stmt->execute([$id]);
    echo "<script>location.href='content_pages.php';</script>";
    exit;
}

// جلب جميع الصفحات
$stmt = $pdo->query("SELECT * FROM content_pages ORDER BY id DESC");
$pages = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<style>
.cke_notification, .cke_notification_info, .cke_notification_warning, .cke_notification_close {
    display: none !important;
}
</style>
<head>
    <meta charset="UTF-8">
    <title>إدارة الصفحات الثابتة</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body { background: #f5f6fa; }
        .container { margin-top: 40px; }
        .table th, .table td { vertical-align: middle; }
    </style>
<script src="https://cdn.ckeditor.com/4.22.1/full/ckeditor.js"></script></head>
<body>
<div class="container">
    <h3 class="mb-4"><?= $page ? "تعديل صفحة" : "إضافة صفحة جديدة" ?></h3>
    <form method="post" class="mb-4">
        <div class="mb-2">
            <input type="text" name="title" class="form-control" required placeholder="عنوان الصفحة" value="<?= htmlspecialchars($page['title'] ?? '') ?>">
        </div>
        <div class="mb-2">
            <input type="text" name="slug" class="form-control" required placeholder="الرابط (مثال: about-us)" value="<?= htmlspecialchars($page['slug'] ?? '') ?>">
        </div>
        <div class="mb-2">
<textarea id="editor1" name="content" rows="10"><?= htmlspecialchars($page['content'] ?? '') ?></textarea>
        </div>
        <button type="submit" name="save_page" class="btn btn-success"><?= $page ? "تعديل الصفحة" : "إضافة صفحة" ?></button>
        <?php if ($page): ?>
            <a href="content_pages.php" class="btn btn-secondary">إلغاء</a>
        <?php endif; ?>
    </form>

    <h4 class="mb-3">قائمة الصفحات</h4>
    <table class="table table-bordered bg-white">
        <thead>
            <tr>
                <th>م</th>
                <th>العنوان</th>
                <th>الرابط</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($pages as $i => $p): ?>
            <tr>
                <td><?= $i + 1 ?></td>
                <td><?= htmlspecialchars($p['title']) ?></td>
                <td><?= htmlspecialchars($p['slug']) ?></td>
                <td>
                    <a href="?edit=<?= $p['id'] ?>" class="btn btn-warning btn-sm">تعديل</a>
                    <a href="?delete=<?= $p['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('هل تريد حذف هذه الصفحة؟')">حذف</a>
                </td>
            </tr>
        <?php endforeach; ?>
        <?php if (count($pages) == 0): ?>
            <tr><td colspan="4" class="text-center">لا توجد صفحات حتى الآن.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>
</body>
<script>
    CKEDITOR.replace('editor1', {
        language: 'ar',
        contentsLangDirection: 'rtl'
    });
</script>
</html>
