<?php
require_once '../db.php';

// حذف الرسالة
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $pdo->prepare("DELETE FROM contact_messages WHERE id=?")->execute([$id]);
    header('Location: contact_messages.php');
    exit;
}

// جلب كل الرسائل
$stmt = $pdo->query("SELECT * FROM contact_messages ORDER BY created_at DESC");
$messages = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة رسائل التواصل</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body>
<div class="container py-4">
    <h2 class="mb-4">إدارة رسائل التواصل</h2>
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>م</th>
                <th>الاسم</th>
                <th>البريد</th>
                <th>الرسالة</th>
                <th>تاريخ الإرسال</th>
                <th>حذف</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($messages): foreach ($messages as $i => $msg): ?>
                <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= htmlspecialchars($msg['name']) ?></td>
                    <td><?= htmlspecialchars($msg['email']) ?></td>
                    <td><?= nl2br(htmlspecialchars($msg['message'])) ?></td>
                    <td><?= htmlspecialchars($msg['created_at']) ?></td>
                    <td>
                        <a href="?delete=<?= $msg['id'] ?>" onclick="return confirm('هل أنت متأكد من الحذف؟');" class="btn btn-danger btn-sm">حذف</a>
                    </td>
                </tr>
            <?php endforeach; else: ?>
                <tr><td colspan="6" class="text-center">لا توجد رسائل حتى الآن.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
</body>
</html>
