<?php
require_once 'config/db.php';

$success = '';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $company_name = trim($_POST['company_name']);
    $category_id  = intval($_POST['category_id']);
    $city_id      = intval($_POST['city_id']);
    $phone        = trim($_POST['phone']);
    $email        = trim($_POST['email']);
    $password     = trim($_POST['password']);

    // تحقق من الحقول
    if (!$company_name || !$email || !$phone || !$password || !$category_id || !$city_id) {
        $errors[] = "جميع الحقول مطلوبة.";
    }

    // تحقق من البريد إذا كان مستخدم بالفعل
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->fetch()) {
        $errors[] = "البريد الإلكتروني مستخدم بالفعل.";
    }

    if (empty($errors)) {
        // إنشاء المستخدم
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);
        $stmt = $pdo->prepare("INSERT INTO users (name, email, password) VALUES (?, ?, ?)");
        $stmt->execute([$company_name, $email, $hashed_password]);
        $user_id = $pdo->lastInsertId();

        // إنشاء الشركة
        $stmt = $pdo->prepare("INSERT INTO companies (user_id, name, category_id, city_id, phone, email, status) VALUES (?, ?, ?, ?, ?, ?, 'pending')");
        $stmt->execute([$user_id, $company_name, $category_id, $city_id, $phone, $email]);

        $success = "تم تسجيل الشركة بنجاح! برجاء انتظار موافقة الإدارة.";
    }
}

// جلب التصنيفات والمدن
$categories = $pdo->query("SELECT * FROM categories")->fetchAll();
$cities = $pdo->query("SELECT * FROM cities")->fetchAll();
?>

<?php include "includes/header.php"; ?>

<div class="register-form" style="max-width:500px;margin:40px auto 80px auto;background:#fff;padding:38px 24px 28px 24px;border-radius:15px;box-shadow:0 4px 32px #c2c2c229;">
    <h2 style="margin-bottom:24px;text-align:center;">تسجيل شركتك في الدليل</h2>
    <?php if ($errors): ?>
        <div class="alert alert-danger" style="color:#fff;background:#e74c3c;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?php foreach ($errors as $e) echo "<div>$e</div>"; ?>
        </div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success" style="color:#fff;background:#27ae60;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?= $success ?>
        </div>
    <?php endif; ?>
    <form method="post" autocomplete="off">
        <div class="form-group">
            <label>اسم الشركة</label>
            <input type="text" name="company_name" placeholder="اسم الشركة" required>
        </div>
        <div class="form-group">
            <label>البريد الإلكتروني</label>
            <input type="email" name="email" placeholder="example@email.com" required>
        </div>
        <div class="form-group">
            <label>رقم الجوال</label>
            <input type="text" name="phone" placeholder="05xxxxxxxx" required>
        </div>
        <div class="form-group">
            <label>كلمة المرور</label>
            <input type="password" name="password" placeholder="كلمة المرور" required>
        </div>
        <div class="form-group">
            <label>المجال</label>
            <select name="category_id" required>
                <option value="">اختر المجال</option>
                <?php foreach($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>المدينة</label>
            <select name="city_id" required>
                <option value="">اختر المدينة</option>
                <?php foreach($cities as $city): ?>
                    <option value="<?= $city['id'] ?>"><?= htmlspecialchars($city['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="main-btn" style="width:100%;margin-top:12px;">تسجيل الشركة</button>
    </form>
    <div style="text-align:center;margin-top:18px;">
        لديك حساب بالفعل؟ <a href="login.php" style="color:#7c3aed;font-weight:500;">سجّل الدخول</a>
    </div>
</div>

<?php include "includes/footer.php"; ?>
