<?php

// دالة ضبط رقم الواتساب
function formatWhatsapp($number) {
    $number = preg_replace('/[^0-9]/', '', $number);
    if (strpos($number, '0') === 0) $number = '966' . substr($number, 1);
    elseif (strpos($number, '966') !== 0) $number = '966' . $number;
    return $number;
}

// جلب أحدث العروض
$stmt = $pdo->prepare("
    SELECT o.*, c.name AS company_name, c.logo AS company_logo, c.phone, c.whatsapp
    FROM offers o
    JOIN companies c ON o.company_id = c.id
    WHERE o.status = 'موافق'
    ORDER BY o.id DESC
    LIMIT 8
");
$stmt->execute();
$offers = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>أحدث العروض</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.2/css/all.min.css"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
    <style>
        body { font-family: 'Tajawal', 'Cairo', Arial, sans-serif; background: #f8f9fb; margin: 0; }
        .section-title {
            font-size: 30px;
            font-weight: bold;
            color: #1976d2;
            margin: 40px 0 28px 0;
            display: flex; align-items: center; gap: 10px;
            direction: rtl;
            justify-content: flex-end;
        }
        .section-title i { color: #ffb300; font-size: 27px; margin-right: 8px;}
        .offers-slider { width: 95%; margin: 0 auto 55px auto; }
        .offer-card {
            background: #fff;
            border-radius: 26px;
            box-shadow: 0 6px 20px #d1d1d12f;
            margin: 18px 10px;
            max-width: 380px;
            min-width: 300px;
            padding: 22px 20px 14px 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            transition: box-shadow 0.2s;
        }
        .offer-card:hover { box-shadow: 0 8px 30px #d1d1d15a; }
        .offer-img img {
            width: 185px;
            height: 110px;
            object-fit: cover;
            border-radius: 12px 12px 16px 16px;
            background: #f6f6f9;
            margin-bottom: 18px;
            box-shadow: 0 2px 8px #0000000a;
        }
        .offer-title {
            font-size: 20px;
            font-weight: 700;
            color: #222;
            margin-bottom: 7px;
        }
        .offer-desc {
            color: #888;
            font-size: 15.5px;
            min-height: 38px;
            margin-bottom: 10px;
        }
        .offer-prices {
            margin-bottom: 9px;
            font-size: 16.5px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        .old-price {
            color: #b7b7b7;
            text-decoration: line-through;
            font-size: 16px;
        }
        .new-price {
            color: #18a300;
            font-weight: bold;
            font-size: 19px;
        }
        .currency { font-size: 16px; color: #1a1a1a; font-weight: bold; margin-right: 3px; }
        .offer-expire {
            color: #666;
            font-size: 15px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 5px;
            justify-content: center;
        }
        .offer-actions {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 8px;
        }
        .btn-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 42px; height: 42px;
            background: #f3f3f7;
            border-radius: 10px;
            font-size: 21px;
            color: #fff;
            border: none;
            transition: box-shadow 0.16s, background 0.16s;
            text-decoration: none !important;
        }
        .btn-icon.whatsapp { background: #25d366; }
        .btn-icon.phone { background: #7c3aed; }
        .btn-icon.page  { background: #ffc107; color: #fff;}
        .btn-icon:hover { opacity:0.87; box-shadow: 0 4px 18px #0001; }
        /* Slick custom arrows */
        .slick-prev, .slick-next {
            background: #ece9f8;
            border: none;
            width: 39px;
            height: 39px;
            border-radius: 50%;
            font-size: 18px;
            top: 38%;
            z-index: 3;
            color: #7c3aed;
            box-shadow: 0 2px 6px #0001;
            transition: background 0.2s;
        }
        .slick-prev:hover, .slick-next:hover { background: #dfcdfd; }
        .slick-prev { right: -20px; }
        .slick-next { left: -20px; }
        .slick-dots { bottom: -24px; }
        .slick-dots li button:before { font-size: 13px; color: #a293c5; }
        @media (max-width: 991px) {
            .offer-card { max-width: 96vw; min-width: 200px;}
            .offers-slider { width: 99%; }
        }
		/* أخفِ كل pagination الجانبية التي تظهر بهذا الشكل */
body > ul,
body > div > ul,
ul.slick-paging,
ul.pagination,
ul[style*="position: absolute"] {
    display: none !important;
}
    </style>
</head>
<body>
    <div class="section-title">
        <span>أحدث العروض</span>
        <i class="fas fa-handshake"></i>
    </div>

    <div class="offers-slider">
        <?php foreach ($offers as $offer): ?>
        <div class="offer-card">
            <div class="offer-img">
                <img src="<?= htmlspecialchars($offer['image'] ?: 'assets/images/offer-default.png') ?>" alt="صورة العرض">
            </div>
            <div class="offer-title"><?= htmlspecialchars($offer['title']) ?></div>
            <div class="offer-desc"><?= htmlspecialchars(mb_substr($offer['description'],0,50,'utf-8')) ?>...</div>
            <div class="offer-prices">
                <?php if($offer['old_price']): ?>
                    <span class="old-price"><?= htmlspecialchars($offer['old_price']) ?></span>
                <?php endif; ?>
                <span class="new-price"><?= htmlspecialchars($offer['new_price']) ?></span>
                <span class="currency">ريال</span>
            </div>
            <div class="offer-expire"><i class="fas fa-calendar-alt"></i> <?= htmlspecialchars($offer['expire_date']) ?></div>
            <div class="offer-actions">
                <a href="company.php?id=<?= $offer['company_id'] ?>" class="btn-icon page" title="صفحة الشركة"><i class="fas fa-home"></i></a>
                <?php if($offer['whatsapp']): ?>
                <a href="https://wa.me/<?= formatWhatsapp($offer['whatsapp']) ?>" target="_blank" class="btn-icon whatsapp" title="واتساب"><i class="fab fa-whatsapp"></i></a>
                <?php endif; ?>
                <?php if($offer['phone']): ?>
                <a href="tel:<?= htmlspecialchars($offer['phone']) ?>" class="btn-icon phone" title="اتصال"><i class="fas fa-phone-alt"></i></a>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <!-- مكتبات jQuery و Slick Carousel -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
    <script>
    $(document).ready(function(){
        $('.offers-slider').slick({
            rtl: true,
            dots: true,
            infinite: true,
            slidesToShow: 2,
            slidesToScroll: 1,
            arrows: true,
            autoplay: true,
            autoplaySpeed: 5000,
            prevArrow:'<button class="slick-prev"><i class="fas fa-chevron-right"></i></button>',
            nextArrow:'<button class="slick-next"><i class="fas fa-chevron-left"></i></button>',
            responsive: [
                { breakpoint: 991, settings: { slidesToShow: 1 } }
            ]
        });
    });
    </script>
</body>
</html>
