<?php
require_once "config/db.php";
include "includes/header.php";

// دالة لضبط رقم الواتساب
function formatWhatsapp($number) {
    $number = preg_replace('/[^0-9]/', '', $number);
    if (strpos($number, '0') === 0) $number = '966' . substr($number, 1);
    elseif (strpos($number, '966') !== 0) $number = '966' . $number;
    return $number;
}

// جلب العروض المعتمدة
$stmt = $pdo->prepare("
    SELECT o.*, c.name AS company_name, c.logo AS company_logo, c.phone, c.whatsapp
    FROM offers o
    JOIN companies c ON o.company_id = c.id
    WHERE o.status = 'موافق'
    ORDER BY o.id DESC
");
$stmt->execute();
$offers = $stmt->fetchAll();
?>

<div class="page-header">
    <h1><i class="fas fa-tags"></i> جميع العروض</h1>
    <p>استعرض جميع العروض المميزة المقدمة من الشركات</p>
</div>

<!-- بطاقات العروض -->
<div class="offers-wrapper">
    <?php foreach ($offers as $offer): ?>
    <div class="offer-card offer-style2">
        <div class="offer-img2">
            <img src="<?= htmlspecialchars($offer['image'] ?? 'assets/images/offer-default.png') ?>" alt="صورة العرض">
        </div>
        <div class="offer-body">
            <div class="offer-title"><?= htmlspecialchars($offer['title'] ?? '') ?></div>
            <div class="offer-desc"><?= htmlspecialchars(mb_substr($offer['description'] ?? '', 0, 60, 'utf-8')) ?>...</div>
            <div class="offer-prices">
                <?php if (!empty($offer['old_price'])): ?>
                    <span class="old-price"><?= number_format($offer['old_price']) ?></span>
                <?php endif; ?>
                <span class="new-price"><?= number_format($offer['new_price'] ?? 0) ?></span>
                <span class="currency">ريال</span>
            </div>
            <div class="offer-expire">
                <i class="fas fa-calendar-alt"></i>
                <?= htmlspecialchars($offer['end_date'] ?? '') ?>
            </div>
            <div class="offer-actions">
                <a href="company.php?id=<?= $offer['company_id'] ?>" class="btn-icon page" title="صفحة الشركة"><i class="fas fa-home"></i></a>
                <?php if(!empty($offer['whatsapp'])): ?>
                    <a href="https://wa.me/<?= formatWhatsapp($offer['whatsapp']) ?>" target="_blank" class="btn-icon whatsapp" title="واتساب"><i class="fab fa-whatsapp"></i></a>
                <?php endif; ?>
                <?php if(!empty($offer['phone'])): ?>
                    <a href="tel:<?= htmlspecialchars($offer['phone']) ?>" class="btn-icon phone" title="اتصال"><i class="fas fa-phone-alt"></i></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- تنسيقات البطاقة -->
<style>
.offers-wrapper {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
    justify-content: center;
    margin: 40px auto;
    max-width: 1200px;
}
.offer-card.offer-style2 {
    background: #fff;
    border-radius: 25px;
    box-shadow: 0 8px 28px #e1e1e1a8;
    margin: 18px 12px;
    max-width: 345px;
    min-width: 250px;
    padding: 0;
    display: flex;
    flex-direction: column;
    align-items: stretch;
    text-align: center;
    transition: box-shadow 0.18s;
    overflow: hidden;
}
.offer-card.offer-style2:hover { box-shadow: 0 12px 38px #cec4eb38; }
.offer-img2 {
    width: 100%;
    height: 190px;
    background: #f5f5fa;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
}
.offer-img2 img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    border-radius: 0;
}
.offer-body {
    padding: 22px 18px 15px 18px;
    display: flex;
    flex-direction: column;
    align-items: center;
}
.offer-title {
    font-size: 20px;
    font-weight: bold;
    color: #222;
    margin-bottom: 8px;
}
.offer-desc {
    color: #888;
    font-size: 15.5px;
    min-height: 35px;
    margin-bottom: 10px;
    margin-top: 0;
}
.offer-prices {
    margin-bottom: 8px;
    font-size: 16.5px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}
.old-price {
    color: #b7b7b7;
    text-decoration: line-through;
    font-size: 16px;
}
.new-price {
    color: #18a300;
    font-weight: bold;
    font-size: 19px;
}
.currency {
    font-size: 16px;
    color: #1a1a1a;
    font-weight: bold;
    margin-right: 3px;
}
.offer-expire {
    color: #666;
    font-size: 15px;
    margin-bottom: 10px;
    display: flex;
    align-items: center;
    gap: 5px;
    justify-content: center;
}
.offer-actions {
    display: flex;
    gap: 14px;
    justify-content: center;
    margin-top: 8px;
}
.btn-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 41px;
    height: 41px;
    background: #f3f3f7;
    border-radius: 10px;
    font-size: 21px;
    color: #fff;
    border: none;
    transition: box-shadow 0.16s, background 0.16s;
    text-decoration: none !important;
}
.btn-icon.whatsapp { background: #25d366; }
.btn-icon.phone { background: #7c3aed; }
.btn-icon.page  { background: #ffc107; color: #fff;}
.btn-icon:hover { opacity:0.87; box-shadow: 0 4px 18px #0001; }
</style>

<?php include "includes/footer.php"; ?>
