<?php
require_once 'config/db.php';
session_start();

$errors = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email    = trim($_POST['email']);
    $password = trim($_POST['password']);

    if (!$email || !$password) {
        $errors[] = "جميع الحقول مطلوبة.";
    } else {
        // البحث عن المستخدم
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            // الدخول ناجح، تخزين بيانات المستخدم في الجلسة
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_email'] = $user['email'];

            // إعادة توجيه إلى لوحة التحكم أو الرئيسية
            header("Location: dashboard/index.php");
            exit;
        } else {
            $errors[] = "البريد الإلكتروني أو كلمة المرور غير صحيحة.";
        }
    }
}
?>

<?php include "includes/header.php"; ?>

<div class="register-form" style="max-width:400px;margin:40px auto 80px auto;background:#fff;padding:38px 24px 28px 24px;border-radius:15px;box-shadow:0 4px 32px #c2c2c229;">
    <h2 style="margin-bottom:24px;text-align:center;">تسجيل الدخول</h2>
    <?php if ($errors): ?>
        <div class="alert alert-danger" style="color:#fff;background:#e74c3c;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?php foreach ($errors as $e) echo "<div>$e</div>"; ?>
        </div>
    <?php endif; ?>
    <form method="post" autocomplete="off">
        <div class="form-group">
            <label>البريد الإلكتروني</label>
            <input type="email" name="email" placeholder="example@email.com" required>
        </div>
        <div class="form-group">
            <label>كلمة المرور</label>
            <input type="password" name="password" placeholder="كلمة المرور" required>
        </div>
        <button type="submit" class="main-btn" style="width:100%;margin-top:12px;">دخول</button>
    </form>
    <div style="text-align:center;margin-top:18px;">
        ليس لديك حساب؟ <a href="register.php" style="color:#7c3aed;font-weight:500;">سجّل شركتك الآن</a>
    </div>
</div>

<?php include "includes/footer.php"; ?>
