<?php
require_once "config/db.php";
include "includes/header.php";

// جلب الشركات النشطة (المعتمدة فقط)
$stmt = $pdo->query("SELECT c.*, cat.name AS category_name, city.name AS city_name 
    FROM companies c
    LEFT JOIN categories cat ON c.category_id = cat.id
    LEFT JOIN cities city ON c.city_id = city.id
    WHERE c.status = 'active'
    ORDER BY c.id DESC");
$companies = $stmt->fetchAll();

// جلب السلايدر العلوي
$sliders_top = $pdo->query("SELECT * FROM sliders WHERE active=1 AND type='top' AND expire_date >= CURDATE() ORDER BY id DESC")->fetchAll();
// جلب السلايدر السفلي
$sliders_bottom = $pdo->query("SELECT * FROM sliders WHERE active=1 AND type='bottom' AND expire_date >= CURDATE() ORDER BY id DESC")->fetchAll();

// دالة ضبط رقم الواتساب
function formatWhatsapp($number) {
    $number = preg_replace('/[^0-9]/', '', $number);
    if (strpos($number, '0') === 0) $number = '966' . substr($number, 1);
    elseif (strpos($number, '966') !== 0) $number = '966' . $number;
    return $number;
}
$today = date('Y-m-d');

// جلب السلايدرات البنرات العلوي والسفلي
$sliders_top = $pdo->query("SELECT * FROM sliders WHERE active=1 AND type='top' AND expire_date >= CURDATE() ORDER BY id DESC")->fetchAll();
$sliders_bottom = $pdo->query("SELECT * FROM sliders WHERE active=1 AND type='bottom' AND expire_date >= CURDATE() ORDER BY id DESC")->fetchAll();



// جلب أحدث العروض
$stmt = $pdo->prepare("
    SELECT o.*, c.name AS company_name, c.logo AS company_logo, c.phone, c.whatsapp
    FROM offers o
    JOIN companies c ON o.company_id = c.id
    WHERE o.status = 'موافق'
    ORDER BY o.id DESC
    LIMIT 8
");
$stmt->execute();
$offers = $stmt->fetchAll();

// جلب الشركاء الفعالين فقط
$stmt = $pdo->query("SELECT * FROM partners WHERE status='active' ORDER BY id DESC");
$partners = $stmt->fetchAll();

$mainSliders = $pdo->query("SELECT * FROM sliders WHERE status='active' ORDER BY id DESC")->fetchAll();

?>
<!-- خلفية الفيديو -->
<div class="video-background">
  <video autoplay muted loop playsinline>
    <source src="assets/video/bg.mp4" type="video/mp4">
    متصفحك لا يدعم تشغيل الفيديو.
  </video>
</div>

<!-- غلاف نموذج البحث فوق الفيديو -->
<div class="search-overlay">
  <div class="search-tabs">
      <button type="button" class="active" id="tab-companies">بحث عن شركات</button>
      <button type="button" id="tab-offers">بحث عن عروض</button>
  </div>

  <!-- نموذج بحث الشركات -->
  <form class="search-form" id="form-companies" method="get" action="companies.php" style="display:block;">
      <div class="form-group">
          <label><i class="fas fa-list"></i> اختر التصنيف</label>
          <select name="category_id">
              <option value="">جميع التصنيفات</option>
              <?php foreach ($categories as $cat): ?>
                  <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
              <?php endforeach; ?>
          </select>
      </div>
      <div class="form-group">
          <label><i class="fas fa-map-marker-alt"></i> اختر المدينة</label>
          <select name="city_id">
              <option value="">جميع المدن</option>
              <?php foreach ($cities as $city): ?>
                  <option value="<?= $city['id'] ?>"><?= htmlspecialchars($city['name']) ?></option>
              <?php endforeach; ?>
          </select>
      </div>
      <div class="form-group">
          <label><i class="fas fa-search"></i> كلمة البحث</label>
          <input type="text" name="q" placeholder="ابحث بالاسم أو النشاط...">
      </div>
      <button class="search-btn" type="submit"><i class="fas fa-search"></i> بحث</button>
  </form>

  <!-- نموذج بحث العروض -->
  <form class="search-form" id="form-offers" method="get" action="offers.php" style="display:none;">
      <div class="form-group">
          <label><i class="fas fa-list"></i> اختر تصنيف العرض</label>
          <select name="category_id">
              <option value="">جميع التصنيفات</option>
              <?php foreach ($categories as $cat): ?>
                  <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
              <?php endforeach; ?>
          </select>
      </div>
      <div class="form-group">
          <label><i class="fas fa-search"></i> كلمة البحث</label>
          <input type="text" name="q" placeholder="ابحث بعنوان أو وصف العرض...">
      </div>
      <button class="search-btn" type="submit"><i class="fas fa-search"></i> بحث</button>
  </form>
</div>

<!-- تنسيقات CSS -->
<style>
.video-background {
    position: relative;
    width: 100%;
    height: 420px;
    overflow: hidden;
}
.video-background video {
    position: absolute;
    top: 50%;
    left: 50%;
    min-width: 100%;
    min-height: 100%;
    transform: translate(-50%, -50%);
    object-fit: cover;
    z-index: 1;
}
.search-overlay {
    position: absolute;
    top: 0;
    width: 100%;
    height: 420px;
    z-index: 2;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 20px;
    pointer-events: none;
}
.search-tabs {
    margin-bottom: 12px;
    z-index: 2;
    pointer-events: auto;
}
.search-tabs button {
    background: rgba(255,255,255,0.9);
    border: none;
    padding: 10px 20px;
    margin: 0 6px;
    border-radius: 20px;
    font-weight: bold;
    cursor: pointer;
}
.search-tabs button.active {
    background: #6d2490;
    color: #fff;
}
.search-form {
    background: rgba(255, 255, 255, 0.2);
    padding: 20px 25px;
    border-radius: 18px;
    box-shadow: 0 6px 18px #0003;
    backdrop-filter: blur(10px);
    max-width: 960px;
    width: 95%;
    pointer-events: auto;
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 16px;
}
.search-form .form-group {
    display: flex;
    flex-direction: column;
    min-width: 220px;
}
.search-form label {
    color: #fff;
    margin-bottom: 4px;
}
.search-form input,
.search-form select {
    padding: 8px 12px;
    border: none;
    border-radius: 10px;
    background: rgba(255,255,255,0.9);
    color: #000;
}
.search-form .search-btn {
    background: #6d2490;
    color: #fff;
    padding: 10px 26px;
    border-radius: 10px;
    font-weight: bold;
    cursor: pointer;
    border: none;
    margin-top: 8px;
}
.search-form .search-btn:hover {
    background: #52187c;
}
</style>

<!-- سكريبت التبديل بين النموذجين -->
<script>
document.getElementById('tab-companies').addEventListener('click', function () {
    document.getElementById('form-companies').style.display = 'block';
    document.getElementById('form-offers').style.display = 'none';
    this.classList.add('active');
    document.getElementById('tab-offers').classList.remove('active');
});
document.getElementById('tab-offers').addEventListener('click', function () {
    document.getElementById('form-companies').style.display = 'none';
    document.getElementById('form-offers').style.display = 'block';
    this.classList.add('active');
    document.getElementById('tab-companies').classList.remove('active');
});
</script>


<!-- السلايدر العلوي -->
<div class="main-slider">
  <?php foreach ($sliders_top as $slide): ?>
    <div class="slider-item">
      <?php
        $img_path = $slide['image'];
        // إذا كان المسار لا يبدأ بـ uploads/sliders/ أضف المسار
        if (strpos($img_path, 'uploads/sliders/') !== 0) {
            $img_path = 'uploads/sliders/' . $img_path;
        }
      ?>
      <?php if (!empty($slide['link'])): ?>
        <a href="<?= htmlspecialchars($slide['link']) ?>" target="_blank">
          <img src="<?= htmlspecialchars($img_path) ?>" alt="<?= htmlspecialchars($slide['title']) ?>">
        </a>
      <?php else: ?>
        <img src="<?= htmlspecialchars($img_path) ?>" alt="<?= htmlspecialchars($slide['title']) ?>">
      <?php endif; ?>
    </div>
  <?php endforeach; ?>
</div>



<!-- عنوان الصفحة -->
<div class="page-header">
    <h1><i class="fas fa-star"></i> شركات مميزة</h1>
    <p>أفضل الشركات المسجلة في دليلنا حسب التقييمات والخدمات</p>
</div>

<!-- بطاقات الشركات -->
<div class="featured-companies">
<?php if (!$companies): ?>
    <div style="text-align:center;color:#aaa;padding:30px 0;">لا يوجد شركات مميزة حتى الآن.</div>
<?php else: ?>
    <?php foreach ($companies as $company): ?>
        <div class="company-card2">
            <!-- صورة الغلاف مع شارة نشط -->
            <div class="cover-image" style="background-image: url('<?= !empty($company['cover']) ? htmlspecialchars($company['cover']) : 'images/cover-default.png' ?>'); position:relative;">
                <div class="status-badge">نشط</div>
            </div>
            
            <!-- هيدر: شعار + اسم الشركة + بيانات -->
            <div class="company-header">
                <div class="logo-wrap">
                    <img src="<?= !empty($company['logo']) ? htmlspecialchars($company['logo']) : 'images/company-default.png' ?>" alt="شعار الشركة">
                </div>
                <div>
                    <div class="company-name-badge"><?= htmlspecialchars($company['name']) ?></div>
                    <div class="meta">
                        <span><i class="fas fa-tag"></i> <?= htmlspecialchars($company['category_name']) ?></span>
                        <span><i class="fas fa-map-marker-alt"></i> <?= htmlspecialchars($company['city_name']) ?></span>
                    </div>
                </div>
            </div>
            
            <?php
                $about = $company['about'] ?? '';
                $desc = mb_substr($about, 0, 72) . (mb_strlen($about) > 72 ? '...' : '');
            ?>
            <p class="description"><?= htmlspecialchars($desc) ?></p>
            <div class="actions">
                <a href="company.php?id=<?= $company['id'] ?>" class="btn-details"><i class="fas fa-eye"></i> التفاصيل</a>
                <?php if (!empty($company['phone'])): ?>
                    <a href="tel:<?= htmlspecialchars($company['phone']) ?>" class="btn-contact"><i class="fas fa-phone-alt"></i> اتصل</a>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
<?php endif; ?>
</div>

<style>

.company-card2 {
    background: #fff;
    border-radius: 18px;
    box-shadow: 0 2px 14px #0001;
    padding: 0 0 18px 0;
    max-width: 360px;
    margin: 14px auto;
    overflow: hidden;
    display: flex;
    flex-direction: column;
    transition: box-shadow 0.2s;
}
.company-card2:hover { box-shadow: 0 6px 28px #0002; }

/* صورة الغلاف */
.cover-image {
    width: 100%;
    height: 145px;
    background-size: cover;
    background-position: center;
    border-radius: 0 0 0 0;
    position: relative;
}

/* شارة نشط */
.status-badge {
    position: absolute;
    top: 13px;
    left: 15px;
    background: #ece8fd;
    color: #6d2490;
    font-size: 15px;
    font-weight: 600;
    border-radius: 18px;
    padding: 4px 18px 4px 18px;
    box-shadow: 0 2px 8px #0001;
    z-index: 2;
    /* للتصميم من اليمين بدلاً من اليسار غيّر left:15px إلى right:15px */
}

/* هيدر الشركة: شعار + اسم */
.company-header {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 0 18px 0 18px;
    margin-top: -32px;
    position: relative;
    z-index: 1;
}

/* شعار الشركة */
.logo-wrap {
    width: 62px;
    height: 62px;
    border-radius: 50%;
    overflow: hidden;
    border: 2.5px solid #fff;
    background: #fff;
    box-shadow: 0 2px 8px #0001;
    margin-left: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
}
.logo-wrap img {
    width: 54px;
    height: 54px;
object-fit: contain;
background: #f5f5fa; /* أو أي لون خلفية مناسب */
    border-radius: 50%;
}

/* اسم الشركة بشكل شارة */
.company-name-badge {
    background: #fff;
    color: #6d2490;
    font-size: 18px;
    font-weight: bold;
    border-radius: 15px;
    padding: 6px 20px 5px 20px;
    box-shadow: 0 1px 6px #0001;
    border: 1.5px solid #eaeaea;
    margin-bottom: 4px;
    display: inline-block;
}

/* بيانات الشركة */
.company-header .meta {
    color: #888;
    font-size: 14px;
    margin-bottom: 2px;
}

/* وصف الشركة */
.description {
    color: #454545;
    font-size: 16px;
    margin: 14px 18px 8px 18px;
    min-height: 40px;
}

/* الأزرار */
.actions {
    display: flex;
    gap: 12px;
    margin: 12px 18px 0 18px;
}
.btn-details {
    background: #6d2490;
    color: #fff;
    padding: 7px 19px;
    border-radius: 9px;
    font-size: 15px;
    text-decoration: none;
    font-weight: 600;
    transition: 0.18s;
}
.btn-details:hover { background: #43126d; }
.btn-contact {
    background: #4eac5d;
    color: #fff;
    padding: 7px 19px;
    border-radius: 9px;
    font-size: 15px;
    text-decoration: none;
    font-weight: 600;
    transition: 0.18s;
}

.btn-contact:hover { background: #338b40; }
</style>


<!-- زر المزيد (يمكن برمجته لاحقًا لعرض جميع الشركات) -->
<div class="more-container">
    <a href="companies.php" class="btn-more">عرض المزيد من الشركات <i class="fas fa-arrow-left"></i></a>
</div>

<!-- السلايدر السفلي -->
<div class="bottom-slider">
  <?php foreach ($sliders_bottom as $slide): ?>
    <div class="slider-item">
      <?php
        $img_path = $slide['image'];
        // أضف مجلد الصور إذا كان المسار لا يبدأ به
        if (strpos($img_path, 'uploads/sliders/') !== 0) {
            $img_path = 'uploads/sliders/' . $img_path;
        }
      ?>
      <?php if (!empty($slide['link'])): ?>
        <a href="<?= htmlspecialchars($slide['link']) ?>" target="_blank">
          <img src="<?= htmlspecialchars($img_path) ?>" alt="<?= htmlspecialchars($slide['title']) ?>">
        </a>
      <?php else: ?>
        <img src="<?= htmlspecialchars($img_path) ?>" alt="<?= htmlspecialchars($slide['title']) ?>">
      <?php endif; ?>
    </div>
  <?php endforeach; ?>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
<script>
$(document).ready(function(){
  $('.bottom-slider').slick({
    rtl: true,
    arrows: true,
    dots: true,
    slidesToShow: 1,
    autoplay: true,
    autoplaySpeed: 4500,
    adaptiveHeight: true
  });
});
</script>


<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>أحدث العروض</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.2/css/all.min.css"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
    <style>
        body { font-family: 'Tajawal', 'Cairo', Arial, sans-serif; background: #f8f9fb; margin: 0; }
        .section-title {
            font-size: 30px;
            font-weight: bold;
            color: #1976d2;
            margin: 40px 0 28px 0;
            display: flex; align-items: center; gap: 10px;
            direction: rtl;
            justify-content: flex-end;
        }
        .section-title i { color: #ffb300; font-size: 27px; margin-right: 8px;}
        .offers-slider { width: 95%; margin: 0 auto 55px auto; }
        .offer-card {
            background: #fff;
            border-radius: 26px;
            box-shadow: 0 6px 20px #d1d1d12f;
            margin: 18px 10px;
            max-width: 380px;
            min-width: 300px;
            padding: 22px 20px 14px 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            transition: box-shadow 0.2s;
        }
        .offer-card:hover { box-shadow: 0 8px 30px #d1d1d15a; }
        .offer-img img {
            width: 185px;
            height: 110px;
            object-fit: cover;
            border-radius: 12px 12px 16px 16px;
            background: #f6f6f9;
            margin-bottom: 18px;
            box-shadow: 0 2px 8px #0000000a;
        }
        .offer-title {
            font-size: 20px;
            font-weight: 700;
            color: #222;
            margin-bottom: 7px;
        }
        .offer-desc {
            color: #888;
            font-size: 15.5px;
            min-height: 38px;
            margin-bottom: 10px;
        }
        .offer-prices {
            margin-bottom: 9px;
            font-size: 16.5px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        .old-price {
            color: #b7b7b7;
            text-decoration: line-through;
            font-size: 16px;
        }
        .new-price {
            color: #18a300;
            font-weight: bold;
            font-size: 19px;
        }
        .currency { font-size: 16px; color: #1a1a1a; font-weight: bold; margin-right: 3px; }
        .offer-expire {
            color: #666;
            font-size: 15px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 5px;
            justify-content: center;
        }
        .offer-actions {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 8px;
        }
        .btn-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 42px; height: 42px;
            background: #f3f3f7;
            border-radius: 10px;
            font-size: 21px;
            color: #fff;
            border: none;
            transition: box-shadow 0.16s, background 0.16s;
            text-decoration: none !important;
        }
        .btn-icon.whatsapp { background: #25d366; }
        .btn-icon.phone { background: #7c3aed; }
        .btn-icon.page  { background: #ffc107; color: #fff;}
        .btn-icon:hover { opacity:0.87; box-shadow: 0 4px 18px #0001; }
        /* Slick custom arrows */
        .slick-prev, .slick-next {
            background: #ece9f8;
            border: none;
            width: 39px;
            height: 39px;
            border-radius: 50%;
            font-size: 18px;
            top: 38%;
            z-index: 3;
            color: #7c3aed;
            box-shadow: 0 2px 6px #0001;
            transition: background 0.2s;
        }
        .slick-prev:hover, .slick-next:hover { background: #dfcdfd; }
        .slick-prev { right: -20px; }
        .slick-next { left: -20px; }
        .slick-dots { bottom: -24px; }
        .slick-dots li button:before { font-size: 13px; color: #a293c5; }
        @media (max-width: 991px) {
            .offer-card { max-width: 96vw; min-width: 200px;}
            .offers-slider { width: 99%; }
        }
		/* أخفِ كل pagination الجانبية التي تظهر بهذا الشكل */
body > ul,
body > div > ul,
ul.slick-paging,
ul.pagination,
ul[style*="position: absolute"] {
    display: none !important;
}
    body { font-family: 'Tajawal', Arial, sans-serif; background:#f8f8fa; margin:0; padding:0; }
    .main-slider, .bottom-slider { margin: 24px auto 36px; max-width:1000px; border-radius:15px; overflow:hidden; }
    .slider-item img { width:100%; height:270px; object-fit:cover; border-radius:15px;}
    .slider-caption { background:rgba(255,255,255,0.8); padding:8px 15px; border-radius:0 0 15px 15px; font-size:15px; color:#222; position:absolute; left:0; right:0; bottom:0; text-align:right; }
    .main-slider, .bottom-slider { position:relative; }
    .slick-prev, .slick-next { background: #fff; border: none; box-shadow:0 2px 6px #0001; width: 38px; height: 38px; border-radius: 50%; font-size: 19px; top: 45%; }
    .slick-prev { right: 10px; }
    .slick-next { left: 10px; }
    .slick-dots li button:before { color: #6616d0 !important; font-size: 14px; }
	.section-title {
    font-size: 30px;
    font-weight: bold;
    color: #1976d2;
    margin: 40px 0 28px 0;
    display: flex; align-items: center; gap: 10px;
    direction: rtl; justify-content: flex-end;
}
.section-title i { color: #ffb300; font-size: 27px; margin-right: 8px;}
.offers-slider { width: 95%; margin: 0 auto 55px auto; }
.offer-card {
    background: #fff;
    border-radius: 26px;
    box-shadow: 0 6px 20px #d1d1d12f;
    margin: 18px 10px;
    max-width: 380px;
    min-width: 260px;
    padding: 22px 20px 14px 20px;
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
    transition: box-shadow 0.2s;
}
.offer-card:hover { box-shadow: 0 8px 30px #d1d1d15a; }
.offer-img img {
    width: 130px;
    height: 130px;
    object-fit: cover;
    border-radius: 16px;
    background: #f6f6f9;
    margin-bottom: 18px;
    box-shadow: 0 2px 8px #0000000a;
}
.offer-title {
    font-size: 20px;
    font-weight: 700;
    color: #222;
    margin-bottom: 7px;
}
.offer-desc {
    color: #888;
    font-size: 15.5px;
    min-height: 38px;
    margin-bottom: 10px;
}
.offer-prices {
    margin-bottom: 9px;
    font-size: 16.5px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}
.old-price {
    color: #b7b7b7;
    text-decoration: line-through;
    font-size: 16px;
}
.new-price {
    color: #18a300;
    font-weight: bold;
    font-size: 19px;
}
.currency { font-size: 16px; color: #1a1a1a; font-weight: bold; margin-right: 3px; }
.offer-expire {
    color: #666;
    font-size: 15px;
    margin-bottom: 10px;
    display: flex;
    align-items: center;
    gap: 5px;
    justify-content: center;
}
.offer-actions {
    display: flex;
    gap: 15px;
    justify-content: center;
    margin-top: 8px;
}
.btn-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 42px; height: 42px;
    background: #f3f3f7;
    border-radius: 10px;
    font-size: 21px;
    color: #fff;
    border: none;
    transition: box-shadow 0.16s, background 0.16s;
    text-decoration: none !important;
}
.btn-icon.whatsapp { background: #25d366; }
.btn-icon.phone { background: #7c3aed; }
.btn-icon.page  { background: #ffc107; color: #fff;}
.btn-icon:hover { opacity:0.87; box-shadow: 0 4px 18px #0001; }
/* Slick custom arrows */
.slick-prev, .slick-next {
    background: #ece9f8;
    border: none;
    width: 39px;
    height: 39px;
    border-radius: 50%;
    font-size: 18px;
    top: 38%;
    z-index: 3;
    color: #7c3aed;
    box-shadow: 0 2px 6px #0001;
    transition: background 0.2s;
}
.slick-prev:hover, .slick-next:hover { background: #dfcdfd; }
.slick-prev { right: -20px; }
.slick-next { left: -20px; }
.slick-dots { bottom: -24px; }
.slick-dots li button:before { font-size: 13px; color: #a293c5; }
@media (max-width: 991px) {
    .offer-card { max-width: 96vw; min-width: 200px;}
    .offers-slider { width: 99%; }
}
.offer-card.offer-style2 {
    background: #fff;
    border-radius: 25px;
    box-shadow: 0 8px 28px #e1e1e1a8;
    margin: 18px 12px;
    max-width: 345px;
    min-width: 250px;
    padding: 0;
    display: flex;
    flex-direction: column;
    align-items: stretch;
    text-align: center;
    transition: box-shadow 0.18s;
    overflow: hidden;
}
.offer-card.offer-style2:hover { box-shadow: 0 12px 38px #cec4eb38; }

.offer-img2 {
    width: 100%;
    height: 190px;
    background: #f5f5fa;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
}
.offer-img2 img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    border-radius: 0;
}

.offer-body {
    padding: 22px 18px 15px 18px;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.offer-title {
    font-size: 20px;
    font-weight: bold;
    color: #222;
    margin-bottom: 8px;
}
.offer-desc {
    color: #888;
    font-size: 15.5px;
    min-height: 35px;
    margin-bottom: 10px;
    margin-top: 0;
}
.offer-prices {
    margin-bottom: 8px;
    font-size: 16.5px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}
.old-price {
    color: #b7b7b7;
    text-decoration: line-through;
    font-size: 16px;
}
.new-price {
    color: #18a300;
    font-weight: bold;
    font-size: 19px;
}
.currency { font-size: 16px; color: #1a1a1a; font-weight: bold; margin-right: 3px; }
.offer-expire {
    color: #666;
    font-size: 15px;
    margin-bottom: 10px;
    display: flex;
    align-items: center;
    gap: 5px;
    justify-content: center;
}
.offer-actions {
    display: flex;
    gap: 14px;
    justify-content: center;
    margin-top: 8px;
}
.btn-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 41px; height: 41px;
    background: #f3f3f7;
    border-radius: 10px;
    font-size: 21px;
    color: #fff;
    border: none;
    transition: box-shadow 0.16s, background 0.16s;
    text-decoration: none !important;
}
.btn-icon.whatsapp { background: #25d366; }
.btn-icon.phone { background: #7c3aed; }
.btn-icon.page  { background: #ffc107; color: #fff;}
.btn-icon:hover { opacity:0.87; box-shadow: 0 4px 18px #0001; }
@media (max-width: 991px) {
    .offer-card.offer-style2 { max-width: 99vw; min-width: 180px;}
    .offer-img2 { height: 130px;}
}
    </style>
</head>
<body>
<div class="section-title">
    <span>أحدث العروض</span>
    <i class="fas fa-handshake"></i>
</div>

<!-- سلايدر العروض -->
<div class="offers-slider">
    <?php foreach ($offers as $offer): ?>
    <div class="offer-card offer-style2">
        <div class="offer-img2">
            <img src="<?= htmlspecialchars($offer['image'] ?? 'assets/images/offer-default.png') ?>" alt="صورة العرض">
        </div>
        <div class="offer-body">
            <div class="offer-title"><?= htmlspecialchars($offer['title'] ?? '') ?></div>
            <div class="offer-desc"><?= htmlspecialchars(mb_substr($offer['description'] ?? '', 0, 60, 'utf-8')) ?>...</div>
            <div class="offer-prices">
                <?php if(!empty($offer['old_price'])): ?>
                    <span class="old-price"><?= number_format($offer['old_price']) ?></span>
                <?php endif; ?>
                <span class="new-price"><?= number_format($offer['new_price'] ?? 0) ?></span>
                <span class="currency">ريال</span>
            </div>
            <div class="offer-expire">
                <i class="fas fa-calendar-alt"></i>
                <?= htmlspecialchars($offer['end_date'] ?? $offer['expire_date'] ?? '') ?>
            </div>
            <div class="offer-actions">
                <a href="company.php?id=<?= $offer['company_id'] ?>" class="btn-icon page" title="صفحة الشركة"><i class="fas fa-home"></i></a>
                <?php if(!empty($offer['whatsapp'])): ?>
                    <a href="https://wa.me/<?= formatWhatsapp($offer['whatsapp']) ?>" target="_blank" class="btn-icon whatsapp" title="واتساب"><i class="fab fa-whatsapp"></i></a>
                <?php endif; ?>
                <?php if(!empty($offer['phone'])): ?>
                    <a href="tel:<?= htmlspecialchars($offer['phone']) ?>" class="btn-icon phone" title="اتصال"><i class="fas fa-phone-alt"></i></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

    <!-- مكتبات jQuery و Slick Carousel -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
    <script>
    $(document).ready(function(){
        $('.offers-slider').slick({
            rtl: true,
            dots: true,
            infinite: true,
            slidesToShow: 2,
            slidesToScroll: 1,
            arrows: true,
            autoplay: true,
            autoplaySpeed: 5000,
            prevArrow:'<button class="slick-prev"><i class="fas fa-chevron-right"></i></button>',
            nextArrow:'<button class="slick-next"><i class="fas fa-chevron-left"></i></button>',
            responsive: [
                { breakpoint: 991, settings: { slidesToShow: 1 } }
            ]
        });
    });
    </script>
<!-- سلايدر شعارات الشركاء (ديناميكي من قاعدة البيانات) -->
<div class="featured-slider" style="margin-top:60px;">
    <div class="slider-header">
        <h2><i class="fas fa-handshake"></i> شركاء النجاح</h2>
        <div class="slider-nav">
            <button class="slider-prev"><i class="fas fa-chevron-right"></i></button>
            <button class="slider-next"><i class="fas fa-chevron-left"></i></button>
        </div>
    </div>
    <div class="companies-slider">
        <?php if ($partners && count($partners)): ?>
            <?php foreach ($partners as $partner): ?>
                <?php
                    // معالجة مسار الشعار
                    $logo = $partner['logo'] ?? '';
                    // إذا لم يبدأ المسار بـ uploads/partners/ أضف المسار تلقائيًا
                    if ($logo && strpos($logo, 'uploads/partners/') !== 0) {
                        $logo = 'uploads/partners/' . $logo;
                    }
                ?>
                <div class="slide-item">
                    <a href="<?= htmlspecialchars($partner['link'] ?: "#") ?>" target="_blank">
                        <div class="slide-img" style="height:110px;display:flex;align-items:center;justify-content:center;background:#fff;">
                            <?php if (!empty($logo)): ?>
                                <img src="<?= htmlspecialchars($logo) ?>" alt="شعار <?= htmlspecialchars($partner['name']) ?>" style="height:80px;max-width:140px;object-fit:contain;">
                            <?php else: ?>
                                <span style="color:#bbb;font-size:13px;">لا يوجد شعار</span>
                            <?php endif; ?>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div style="color:#aaa;padding:24px;text-align:center;">لا يوجد شعارات شركاء حاليا.</div>
        <?php endif; ?>
    </div>
</div>


        <!-- المزيد من الشرائح... -->
    </div>
</div>

<!-- أولاً: أضف jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- ثانياً: slick -->
<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
<!-- أخيراً: سكريبتك -->
<script src="assets/script.js"></script>
<!-- =========== سكريبتات التشغيل =========== -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
<script>

$(document).ready(function(){
  $('.main-slider').slick({
    rtl:true, dots:true, arrows:true, infinite:true, slidesToShow:1, slidesToScroll:1,
    autoplay:true, autoplaySpeed:5000,
    prevArrow:'<button class="slick-prev"><i class="fas fa-chevron-right"></i></button>',
    nextArrow:'<button class="slick-next"><i class="fas fa-chevron-left"></i></button>'
  });
  $('.bottom-slider').slick({
    rtl:true, dots:true, arrows:true, infinite:true, slidesToShow:1, slidesToScroll:1,
    autoplay:true, autoplaySpeed:4000,
    prevArrow:'<button class="slick-prev"><i class="fas fa-chevron-right"></i></button>',
    nextArrow:'<button class="slick-next"><i class="fas fa-chevron-left"></i></button>'
  });
});
<script>
$(document).ready(function(){
  $('.main-slider').slick({
    rtl: true,
    arrows: true,
    dots: true,
    slidesToShow: 1,
    autoplay: true,
    autoplaySpeed: 4500,
    adaptiveHeight: true
  });
});
</script>

</script>
<?php include "includes/footer.php"; ?>
