<?php
if (session_status() === PHP_SESSION_NONE) session_start();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>دليل الصفحات التجارية</title>
    <!-- ملف التنسيق الرئيسي -->
    <link rel="stylesheet" href="/dalelapp/assets/styles.css">
    <!-- أيقونات FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- خط Cairo من Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- ملفات slick للسلايدر -->
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
</head>
<body>
    <div class="container">
        <!-- الشريط العلوي -->
        <div class="top-bar">
            <div class="logo">
                <img src="/dalelapp/assets/images/logo.png" alt="شعار دليل الصفحات التجارية">
                <span>دليل الصفحات التجارية</span>
            </div>
<div class="user-actions">
<?php if (isset($_SESSION['user_id'])): ?>
    <span class="welcome-msg">
        <i class="fas fa-user-circle"></i>
        مرحباً، <?= htmlspecialchars($_SESSION['user_name']) ?>
    </span>
    <a href="/dalelapp/dashboard/index.php"><i class="fas fa-cog"></i> لوحة التحكم</a>
    <a href="/dalelapp/logout.php" style="color: #c00;"><i class="fas fa-sign-out-alt"></i> تسجيل الخروج</a>
<?php else: ?>
    <a href="/dalelapp/login.php"><i class="fas fa-user"></i> تسجيل الدخول</a>
    <a href="/dalelapp/register.php"><i class="fas fa-plus-circle"></i> أضف شركتك</a>
<?php endif; ?>
    <a href="/dalelapp/contact.php" class="contact-btn"><i class="fas fa-phone-alt"></i> تواصل معنا</a>
</div>
        </div>
        <!-- شريط التنقل الرئيسي -->
        <nav class="main-nav">
            <ul>
                <li><a href="/dalelapp/index.php" class="active"><i class="fas fa-home"></i> الرئيسية</a></li>
<li><a href="companies.php"><i class="fas fa-building"></i> الشركات</a></li>
<li><a href="offer.php?offers=1"><i class="fas fa-tags"></i> العروض</a></li>
<li><a href="blog.php"><i class="fas fa-newspaper"></i> المدونة</a></li>
                <li><a href="/dalelapp/contact.php"><i class="fas fa-address-card"></i> اتصل بنا</a></li>
            </ul>
        </nav>
