<?php
require_once '../config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

// جلب بيانات الشركة للمستخدم
$stmt = $pdo->prepare("SELECT * FROM companies WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$company = $stmt->fetch();

if (!$company) {
    die("<div style='color:#e74c3c;font-size:18px;text-align:center;margin:40px 0;'>لم يتم العثور على بيانات الشركة</div>");
}

$success = '';
$errors = [];
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title       = trim($_POST['title']);
    $description = trim($_POST['description']);
    $old_price   = $_POST['old_price'] !== '' ? floatval($_POST['old_price']) : null;
    $new_price   = $_POST['new_price'] !== '' ? floatval($_POST['new_price']) : null;
    $end_date    = trim($_POST['end_date']);

    // معالجة صورة العرض
    $image = '';
    if (!empty($_FILES['image']['name'])) {
        if ($_FILES['image']['size'] > 500 * 1024) {
            $errors[] = "حجم صورة العرض يجب ألا يتجاوز 500 كيلوبايت.";
        } else {
            $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
            $img_name = 'offer_' . $company['id'] . '_' . time() . '.' . $ext;
            $img_path = '../uploads/offers/' . $img_name;
            if (!is_dir('../uploads/offers/')) {
                mkdir('../uploads/offers/', 0777, true);
            }
            if (move_uploaded_file($_FILES['image']['tmp_name'], $img_path)) {
                $image = 'uploads/offers/' . $img_name;
            }
        }
    } else {
        $errors[] = "يرجى اختيار صورة للعرض.";
    }

    // التحقق من الحقول المطلوبة
    if (!$title || !$description || !$end_date) {
        $errors[] = "جميع الحقول مطلوبة.";
    }

    if (empty($errors)) {
        $status = 'بانتظار الموافقة'; // هنا التعديل الأساسي
        $stmt = $pdo->prepare("INSERT INTO offers
            (company_id, title, description, image, old_price, new_price, end_date, status)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $company['id'],
            $title,
            $description,
            $image,
            $old_price,
            $new_price,
            $end_date,
            $status
        ]);
        $success = "تمت إضافة العرض بنجاح! سيتم مراجعته من قبل الإدارة.";
    }
}
?>

<?php include "../includes/header.php"; ?>

<div class="register-form" style="max-width:600px;margin:40px auto 80px auto;background:#fff;padding:38px 24px 28px 24px;border-radius:15px;box-shadow:0 4px 32px #c2c2c229;">
    <h2 style="margin-bottom:24px;text-align:center;">إضافة عرض جديد</h2>
    <?php if ($errors): ?>
        <div class="alert alert-danger" style="color:#fff;background:#e74c3c;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?php foreach ($errors as $e) echo "<div>$e</div>"; ?>
        </div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success" style="color:#fff;background:#27ae60;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?= $success ?>
            <div style="margin-top:16px;">
                <a href="offers.php" class="main-btn">العودة إلى عروضي</a>
            </div>
        </div>
    <?php else: ?>
    <form method="post" enctype="multipart/form-data" autocomplete="off">
        <div class="form-group">
            <label>عنوان العرض *</label>
            <input type="text" name="title" required value="<?= htmlspecialchars($_POST['title'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>نبذة عن العرض *</label>
            <textarea name="description" rows="3" required><?= htmlspecialchars($_POST['description'] ?? '') ?></textarea>
        </div>
        <div class="form-group">
            <label>صورة العرض (PNG/JPG) *</label>
            <input type="file" name="image" accept="image/*" required>
            <small style="color:#666;">أقصى حجم 500 كيلوبايت.</small>
        </div>
        <div class="form-group">
            <label>السعر قبل</label>
            <input type="number" name="old_price" step="0.01" min="0" value="<?= htmlspecialchars($_POST['old_price'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>السعر بعد</label>
            <input type="number" name="new_price" step="0.01" min="0" value="<?= htmlspecialchars($_POST['new_price'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>تاريخ انتهاء العرض *</label>
            <input type="date" name="end_date" required value="<?= htmlspecialchars($_POST['end_date'] ?? '') ?>">
        </div>
        <button type="submit" class="main-btn" style="width:100%;margin-top:12px;">إضافة العرض</button>
    </form>
    <?php endif; ?>
</div>

<?php include "../includes/footer.php"; ?>
