<?php
require_once "includes/header.php";
require_once "config/db.php";

// استقبال رقم الشركة
$company_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if(!$company_id) {
    echo "<div style='text-align:center;padding:40px;'>رقم الشركة غير صحيح</div>";
    require_once "includes/footer.php";
    exit;
}
function formatWhatsapp($phone) {
    $phone = preg_replace('/\D/', '', $phone);
    if(strpos($phone, '966') === 0) return $phone;
    if(strpos($phone, '05') === 0) return '966' . substr($phone, 1);
    if(strpos($phone, '5') === 0) return '966' . $phone;
    return $phone;
}
// جلب بيانات الشركة
$stmt = $pdo->prepare("SELECT c.*, cat.name AS category_name, city.name AS city_name
    FROM companies c
    LEFT JOIN categories cat ON c.category_id = cat.id
    LEFT JOIN cities city ON c.city_id = city.id
    WHERE c.id = ? AND c.status = 'approved' LIMIT 1");
$stmt->execute([$company_id]);
$company = $stmt->fetch();

$images = [];
if (!empty($company['images'])) {
    $images = json_decode($company['images'], true);
}
if(!$company) {
    echo "<div style='text-align:center;padding:40px;'>الشركة غير موجودة أو لم يتم الموافقة عليها بعد</div>";
    require_once "includes/footer.php";
    exit;
}

// جلب عروض الشركة
$stmt = $pdo->prepare("SELECT * FROM offers WHERE company_id=? AND status='موافق' ORDER BY id DESC");
$stmt->execute([$company_id]);
$offers = $stmt->fetchAll();
?>

<div class="container-company">
    <!-- بطاقة الشركة الرئيسية -->
    <div class="company-card-pro">
        <div class="company-main-row">
            <div class="company-logo-wrap">
                <img src="<?= htmlspecialchars($company['logo'] ?? 'assets/images/company-default.png') ?>" alt="شعار <?= htmlspecialchars($company['name'] ?? '') ?>">
            </div>
            <div class="company-details">
                <div class="company-header-flex">
                    <h2 class="company-name"><?= htmlspecialchars($company['name'] ?? '') ?></h2>
                    <span class="company-status">نشط</span>
                </div>
                <div class="company-meta">
                    <span><i class="fas fa-map-marker-alt"></i> <?= htmlspecialchars($company['city_name'] ?? '') ?></span>
                    <span style="margin:0 8px;">|</span>
                    <span><i class="fas fa-tag"></i> <?= htmlspecialchars($company['category_name'] ?? '') ?></span>
                </div>
                <div class="company-about"><?= nl2br(htmlspecialchars($company['about'] ?? '')) ?></div>
            </div>
        </div>
        <!-- أزرار التواصل داخل البطاقة -->
        <div class="company-actions">
            <?php if($company['map_link']): ?>
                <a href="<?= htmlspecialchars($company['map_link']) ?>" target="_blank" class="btn-contact-link map" title="خريطة الموقع"><i class="fas fa-map-marked-alt"></i></a>
            <?php endif; ?>
            <?php if($company['website']): ?>
                <a href="<?= htmlspecialchars($company['website']) ?>" target="_blank" class="btn-contact-link website" title="الموقع الإلكتروني"><i class="fas fa-globe"></i></a>
            <?php endif; ?>
            <?php if($company['email']): ?>
                <a href="mailto:<?= htmlspecialchars($company['email']) ?>" class="btn-contact-link email" title="الإيميل"><i class="fas fa-envelope"></i></a>
            <?php endif; ?>
            <?php if($company['phone']): ?>
                <a href="tel:<?= htmlspecialchars($company['phone']) ?>" class="btn-contact-link phone" title="اتصال"><i class="fas fa-phone-alt"></i></a>
            <?php endif; ?>
            <?php if($company['whatsapp']): ?>
                <a href="https://wa.me/<?= formatWhatsapp($company['whatsapp']) ?>" target="_blank" class="btn-contact-link whatsapp" title="واتساب"><i class="fab fa-whatsapp"></i></a>
            <?php endif; ?>
        </div>
        <!-- معرض صور الشركة -->
        <?php if (!empty($images)): ?>
            <div class="company-gallery">
                <?php foreach ($images as $img): ?>
                    <a href="<?= htmlspecialchars($img) ?>" class="gallery-thumb" data-lightbox="company-gallery">
                        <img src="<?= htmlspecialchars($img) ?>" alt="صورة إضافية">
                    </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- عروض الشركة -->
    <div class="company-offers-section">
        <h3 class="company-offers-title"><i class="fas fa-tags"></i> عروض الشركة</h3>
        <?php if($offers): ?>
            <div class="offers-slider">
                <?php foreach($offers as $offer): ?>
                    <?php $offer_exp = $offer['expire_date'] ?? $offer['end_date'] ?? ''; ?>
                    <div class="offer-card-pro">
                        <div class="offer-img2">
                            <img src="<?= htmlspecialchars($offer['image'] ?: 'assets/images/offer-default.png') ?>" alt="صورة العرض">
                        </div>
                        <div class="offer-body">
                            <div class="offer-title"><?= htmlspecialchars($offer['title'] ?? '') ?></div>
                            <div class="offer-desc"><?= htmlspecialchars(mb_substr($offer['description'] ?? '', 0, 60, 'utf-8')) ?>...</div>
                            <div class="offer-prices">
                                <?php if (!empty($offer['old_price'])): ?>
                                    <span class="old-price"><?= number_format($offer['old_price']) ?> ريال</span>
                                <?php endif; ?>
                                <span class="new-price"><?= number_format($offer['new_price']) ?> ريال</span>
                            </div>
                            <div class="offer-expire">
                                <i class="fas fa-calendar-alt"></i>
                                <?= htmlspecialchars($offer_exp) ?>
                                <?php
                                if (!empty($offer_exp) && $offer_exp < date('Y-m-d')) {
                                    echo '<span style="color:#c00;font-weight:bold;margin-right:8px;">(انتهى العرض)</span>';
                                }
                                ?>
                            </div>
                            <div class="offer-contact-row">
                                <?php if(!empty($company['phone'])): ?>
                                    <a href="tel:<?= htmlspecialchars($company['phone']) ?>" class="btn-contact-offer phone" title="اتصال"><i class="fas fa-phone-alt"></i></a>
                                <?php endif; ?>
                                <?php if(!empty($company['whatsapp'])): ?>
                                    <a href="https://wa.me/<?= formatWhatsapp($company['whatsapp']) ?>" target="_blank" class="btn-contact-offer whatsapp" title="واتساب"><i class="fab fa-whatsapp"></i></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <!-- سلايدر العروض -->
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
            <script>
            $(document).ready(function(){
                $('.offers-slider').slick({
                    rtl: true,
                    dots: true,
                    infinite: true,
                    speed: 600,
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    arrows: true,
                    responsive: [
                        { breakpoint: 768, settings: { slidesToShow: 1 } }
                    ]
                });
            });
            </script>
        <?php else: ?>
            <div style="color:#c00;padding:22px;text-align:center;">لا توجد عروض متاحة حالياً لهذه الشركة.</div>
        <?php endif; ?>
    </div>
</div>

<!-- مكتبات lightbox -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/css/lightbox.min.css"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/js/lightbox.min.js"></script>

<style>
.container-company { max-width:1050px; margin:38px auto 45px auto; }
.company-card-pro {
    background:#fff;
    border-radius:24px;
    box-shadow:0 8px 32px #d1c7e53c;
    padding:36px 38px 28px 38px;
    margin:0 auto 32px auto;
}
.company-main-row {
    display:flex;
    align-items:center;
    gap:38px;
    flex-wrap:wrap;
}
.company-logo-wrap {
    width:120px; height:120px;
    background:#f7f6fc;
    border-radius:26px;
    display:flex; align-items:center; justify-content:center;
    box-shadow:0 2px 12px #e1c1fa1c;
    overflow:hidden;
}
.company-logo-wrap img {
    width:102px; height:102px; object-fit:contain; border-radius:18px; background:#fff;
}
.company-details { flex:1; }
.company-header-flex {
    display:flex; align-items:center; gap:18px; margin-bottom:7px;
}
.company-name {
    font-size:2rem; color:#461e77; font-weight:bold; margin-bottom:2px; margin-top:0;
}
.company-status {
    background:#ece8fd; color:#6d2490; font-size:17px;
    border-radius:13px; padding:4px 20px; font-weight:700;
    box-shadow:0 2px 8px #d7caff2a;
}
.company-meta {
    color:#888; font-size:16px; margin-bottom:8px; display:flex; gap:12px; align-items:center;
}
.company-about { color:#3b3b3b; font-size:16.5px; margin:6px 0 0 0; min-height:32px; }

.company-actions {
    margin:22px 0 4px 0;
    display:flex; gap:13px; flex-wrap:wrap;
    justify-content:flex-start;
}
.btn-contact-link {
    display:flex; align-items:center; justify-content:center;
    width:46px; height:46px;
    font-size:21px; color:#fff !important; background:#f59e0b;
    border-radius:12px; transition:.18s; box-shadow:0 2px 7px #0001;
    text-decoration:none !important; border:none;
}
.btn-contact-link:hover { filter:brightness(0.9); box-shadow:0 4px 18px #d2c2ef4a; }
.btn-contact-link.map { background:#fbbf24; }
.btn-contact-link.website { background:#7c3aed; }
.btn-contact-link.email { background:#2d9cdb; }
.btn-contact-link.phone { background:#38b000; }
.btn-contact-link.whatsapp { background:#25d366; }

.company-gallery {
    display:flex; gap:12px; flex-wrap:wrap; margin:25px 0 6px 0; align-items:center;
}
.gallery-thumb {
    width:98px; height:74px; border-radius:9px; overflow:hidden;
    display:block; box-shadow:0 2px 8px #0001; transition:transform 0.15s;
}
.gallery-thumb img {
    width:100%; height:100%; object-fit:cover; display:block;
    border-radius:8px; transition:transform 0.18s;
}
.gallery-thumb:hover img { transform:scale(1.11); box-shadow:0 2px 16px #7c3aed38; }

/* عروض الشركة */
.company-offers-section { max-width:830px; margin:45px auto 0 auto; }
.company-offers-title { font-size:23px; color:#7c3aed; margin-bottom:24px; display:flex;align-items:center; gap:10px;}
.offers-slider { margin-bottom: 44px; direction: rtl; }
.offer-card-pro {
    background: #fff;
    border-radius: 17px;
    box-shadow: 0 2px 14px #0001;
    padding: 0 0 18px 0;
    margin: 12px;
    min-width: 265px;
    max-width: 345px;
    display: flex;
    flex-direction: column;
    align-items: stretch;
    text-align: center;
    overflow: hidden;
    transition:.17s;
}
.offer-card-pro:hover { box-shadow:0 6px 22px #7c3aed1b; }
.offer-img2 {
    width: 100%; height: 155px; background: #f5f5fa;
    display: flex; align-items: center; justify-content: center; overflow: hidden;
}
.offer-img2 img {
    width: 100%; height: 100%; object-fit:cover; display: block; border-radius: 0;
}
.offer-body { padding: 19px 16px 8px 16px; display:flex;flex-direction:column;align-items:center;}
.offer-title { font-size: 19px; font-weight: bold; color: #222; margin-bottom: 6px; }
.offer-desc { color: #888; font-size: 15.5px; min-height: 31px; margin-bottom: 9px; margin-top:0;}
.offer-prices { margin-bottom: 8px; font-size: 16.5px; display: flex; align-items: center; justify-content: center; gap: 10px;}
.old-price { color: #b7b7b7; text-decoration: line-through; font-size: 16px;}
.new-price { color: #18a300; font-weight: bold; font-size: 18.5px;}
.offer-expire { color: #666; font-size: 14px; margin-bottom: 7px; display: flex; align-items: center; gap: 5px; justify-content: center; }
.offer-contact-row {display:flex; gap:11px; justify-content:center; margin-top:8px;}
.btn-contact-offer { display:flex; align-items:center; justify-content:center; width:38px; height:38px; font-size:17px; border-radius:9px; background:#7c3aed; color:#fff !important; box-shadow:0 2px 7px #0001; transition:.16s; text-decoration:none !important;}
.btn-contact-offer.whatsapp {background:#25d366;}
.btn-contact-offer:hover { filter:brightness(0.92);}
@media (max-width:900px) {
    .company-main-row {flex-direction:column; gap:16px;}
    .company-card-pro {padding:18px 8px 18px 8px;}
}
@media (max-width: 600px) {
    .company-card-pro { padding:10px 0 10px 0;}
    .company-logo-wrap {width:84px;height:84px;}
    .company-logo-wrap img {width:70px;height:70px;}
    .company-header-flex {flex-direction:column;gap:7px;}
    .company-about {font-size:15px;}
    .offers-slider {margin:0;}
    .company-offers-section {max-width:100vw;}
}

</style>

<?php require_once "includes/footer.php"; ?>
