// تأثيرات التحميل الأولية
document.body.style.transition = 'opacity 0.5s ease';
document.body.style.opacity = '0';

$(document).ready(function() {
    // إظهار الصفحة بعد التحميل
    setTimeout(function() {
        document.body.style.opacity = '1';
    }, 100);

    // تهيئة السلايدر الرئيسي
    $('.main-slider').slick({
        rtl: true,
        dots: true,
        infinite: true,
        speed: 800,
        slidesToShow: 1,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 5000,
        arrows: true,
        pauseOnHover: false,
        cssEase: 'ease-in-out',
        prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-chevron-right"></i></button>',
        nextArrow: '<button type="button" class="slick-next"><i class="fas fa-chevron-left"></i></button>'
    });

    // تهيئة سلايدر الشركات المميزة
    $('.companies-slider').slick({
        rtl: true,
        dots: true,
        infinite: true,
        speed: 600,
        slidesToShow: 3,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 4000,
        arrows: false,
        pauseOnHover: true,
        cssEase: 'ease-in-out',
        responsive: [
            { breakpoint: 1024, settings: { slidesToShow: 2, slidesToScroll: 1 } },
            { breakpoint: 600,  settings: { slidesToShow: 1, slidesToScroll: 1 } }
        ]
    });

    // التحكم بالسلايدر بالأزرار المخصصة
    $('.slider-prev').click(function() {
        $('.companies-slider').slick('slickPrev');
    });
    $('.slider-next').click(function() {
        $('.companies-slider').slick('slickNext');
    });

    // تبديل تبويبات البحث بين الشركات والعروض
    var tabCompanies = document.getElementById("tab-companies");
    var tabOffers = document.getElementById("tab-offers");
    var formCompanies = document.getElementById("form-companies");
    var formOffers = document.getElementById("form-offers");

    if (tabCompanies && tabOffers && formCompanies && formOffers) {
        tabCompanies.onclick = function(e) {
            e.preventDefault();
            formCompanies.style.display = "block";
            formOffers.style.display = "none";
            tabCompanies.classList.add("active");
            tabOffers.classList.remove("active");
        };
        tabOffers.onclick = function(e) {
            e.preventDefault();
            formCompanies.style.display = "none";
            formOffers.style.display = "block";
            tabOffers.classList.add("active");
            tabCompanies.classList.remove("active");
        };
    }
});
