<?php
require_once("../../config/db.php");

// جلب جميع المقالات من قاعدة البيانات
$stmt = $pdo->query("SELECT * FROM posts ORDER BY id DESC");
$posts = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة المقالات</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            color: #2e2340;
            margin: 0;
        }
        .container {
            max-width: 1050px;
            margin: 45px auto 0 auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            padding: 38px 24px 25px 24px;
            min-height: 540px;
        }
        .header-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 35px;
            gap: 12px;
        }
        .header-title {
            display: flex;
            align-items: center;
            font-size: 2rem;
            font-weight: 800;
            color: #3e165a;
            margin: 0;
        }
        .header-title i { margin-left: 9px; color: #7c3aed; font-size: 1.5em; }
        .home-btn, .add-btn {
            background: linear-gradient(135deg, #3e165a 60%, #7c3aed 100%);
            color: #fff;
            padding: 9px 24px 9px 18px;
            border-radius: 50px;
            border: none;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            transition: background 0.2s, box-shadow 0.2s;
            box-shadow: 0 3px 15px rgba(62,22,90,0.09);
            text-decoration: none !important;
        }
        .home-btn { margin-left: 10px; }
        .add-btn {
            background: linear-gradient(135deg, #7c3aed 80%, #3e165a 100%);
            font-size: 1.05rem;
        }
        .home-btn i,
        .add-btn i { margin-left: 8px; font-size: 1.2em; }

        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 1px 9px #ece1fd3a;
            font-size: 1rem;
        }
        th, td {
            padding: 14px 7px;
            text-align: center;
        }
        th {
            background: linear-gradient(135deg, #3e165a 80%, #7c3aed 100%);
            color: #fff;
            font-size: 1.05rem;
            font-weight: 700;
        }
        tr:nth-child(even) td {
            background: #f5f4fa;
        }
        td {
            color: #40215b;
            border-bottom: 1px solid #eee;
            vertical-align: middle;
        }

        .action-links a {
            color: #7c3aed;
            font-weight: 700;
            margin: 0 5px;
            padding: 4px 10px;
            border-radius: 7px;
            transition: background 0.13s, color 0.12s;
            text-decoration: none !important;
            font-size: 14px;
            border: 1px solid #f0eafd;
        }
        .action-links a:hover {
            background: #7c3aed;
            color: #fff !important;
        }
        .action-links a.delete {
            color: #e74c3c;
            border-color: #ffebeb;
        }
        .action-links a.delete:hover {
            background: #e74c3c;
            color: #fff !important;
        }

        @media (max-width: 700px) {
            .container { padding: 14px 2vw; }
            table, thead, tbody, th, td, tr { font-size: 13px; }
            .header-title { font-size: 1.1rem; }
            .home-btn, .add-btn { padding: 7px 12px; font-size: 13px; }
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header-bar">
        <a href="../index.php" class="home-btn"><i class="fa fa-home"></i> الرئيسية</a>
        <div class="header-title">
            <i class="fa fa-newspaper"></i> إدارة المقالات
        </div>
        <a href="add.php" class="add-btn"><i class="fa fa-plus"></i> إضافة مقال</a>
    </div>

    <table>
        <thead>
            <tr>
                <th>العنوان</th>
                <th>التصنيف</th>
                <th>التاريخ</th>
                <th>التحكم</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($posts as $post): ?>
            <tr>
                <td><?= htmlspecialchars($post['title']) ?></td>
                <td><?= htmlspecialchars($post['category']) ?></td>
                <td><?= htmlspecialchars(date('Y-m-d', strtotime($post['created_at'] ?? ''))) ?></td>
                <td class="action-links">
                    <a href="edit.php?id=<?= $post['id'] ?>"><i class="fa fa-edit"></i> تعديل</a>
                    <a href="delete.php?id=<?= $post['id'] ?>" class="delete" onclick="return confirm('هل أنت متأكد من حذف المقال؟');"><i class="fa fa-trash"></i> حذف</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
