<?php
require_once '../../config/db.php';

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$stmt = $pdo->prepare("SELECT * FROM posts WHERE id = ?");
$stmt->execute([$id]);
$post = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$post) {
    echo "المقال غير موجود.";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'] ?? '';
    $category = $_POST['category'] ?? '';
    $publish_date = $_POST['publish_date'] ?? '';
    $content = $_POST['content'] ?? '';
    $image = $post['image'];

    // إذا تم رفع صورة جديدة
    if (!empty($_FILES['image']['name'])) {
        $image = time() . '_' . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], "../../uploads/$image");
    }

    $stmt = $pdo->prepare("UPDATE posts SET title=?, category=?, publish_date=?, content=?, image=? WHERE id=?");
    $stmt->execute([$title, $category, $publish_date, $content, $image, $id]);

    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تعديل مقال</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Cairo', sans-serif; background: #f8f9fa; padding: 40px; margin: 0; }
        .form-container {
            max-width: 800px;
            margin: auto;
            background: #fff;
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.06);
        }
        .form-container h2 {
            text-align: center;
            color: #333;
            margin-bottom: 25px;
        }
        label {
            font-weight: bold;
            margin-top: 15px;
            display: block;
        }
        input[type="text"], input[type="date"], textarea {
            width: 100%;
            padding: 10px;
            font-size: 15px;
            border: 1px solid #ccc;
            border-radius: 6px;
            margin-top: 5px;
        }
        textarea { height: 160px; resize: vertical; }
        button {
            background: #6d28d9;
            color: #fff;
            border: none;
            padding: 12px 26px;
            font-size: 16px;
            border-radius: 6px;
            margin-top: 20px;
            cursor: pointer;
        }
        button:hover { background: #5b21b6; }
        .return-btn {
            display: inline-block;
            background: #6c5ce7;
            color: white;
            padding: 10px 20px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: bold;
            margin-bottom: 20px;
        }
        img {
            margin-top: 10px;
            max-width: 200px;
            border-radius: 6px;
            display: block;
        }
    </style>
</head>
<body>

<div class="form-container">
    <a href="index.php" class="return-btn">← العودة إلى القائمة</a>
    <h2>تعديل مقال</h2>

    <form method="POST" enctype="multipart/form-data">
        <label>العنوان</label>
        <input type="text" name="title" value="<?= htmlspecialchars($post['title']) ?>" required>

        <label>التصنيف</label>
        <input type="text" name="category" value="<?= htmlspecialchars($post['category']) ?>" required>

        <label>تاريخ النشر</label>
        <input type="date" name="publish_date" value="<?= htmlspecialchars($post['publish_date']) ?>">

        <label>المحتوى</label>
        <textarea name="content" required><?= htmlspecialchars($post['content']) ?></textarea>

        <label>تحديث الصورة</label>
        <input type="file" name="image">
        <?php if (!empty($post['image'])): ?>
            <img src="../../<?= htmlspecialchars($post['image']) ?>" alt="الصورة الحالية">
        <?php else: ?>
            <p style="color:#999;">لا توجد صورة حالية.</p>
        <?php endif; ?>

        <button type="submit">حفظ التعديلات</button>
    </form>
</div>

</body>
</html>
