<?php
require_once "../includes/auth.php";
require_once "../config/db.php";

// التحقق من وجود معرف الشريك
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id > 0) {
    // جلب اسم الشعار أولاً
    $stmt = $pdo->prepare("SELECT logo FROM partners WHERE id=?");
    $stmt->execute([$id]);
    $row = $stmt->fetch();

    // حذف السجل من قاعدة البيانات
    $stmt = $pdo->prepare("DELETE FROM partners WHERE id=?");
    $stmt->execute([$id]);

    // حذف صورة الشعار من السيرفر إذا كانت موجودة
    if ($row && !empty($row['logo'])) {
        $logoPath = realpath(__DIR__ . '/../uploads/partners/' . $row['logo']);
        // تأكد أن الصورة فعلاً داخل مجلد الشركاء (حماية أمنية)
        $uploadsDir = realpath(__DIR__ . '/../uploads/partners/');
        if ($logoPath && strpos($logoPath, $uploadsDir) === 0 && file_exists($logoPath)) {
            @unlink($logoPath);
        }
    }

    // إعادة التوجيه للجدول بعد الحذف
    header("Location: partners.php?msg=deleted");
    exit;
} else {
    // إذا لم يصل معرف صحيح
    header("Location: partners.php");
    exit;
}
