<?php
require_once "../includes/auth.php";
require_once "../config/db.php";

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $link = trim($_POST['link'] ?? '');
    $status = $_POST['status'] ?? 'active';
    $logo = '';

    // تحقق من رفع الشعار
    if (!empty($_FILES['logo']['name'])) {
        $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
        $logo_name = 'partner_' . time() . '.' . $ext;
        $upload_path = '../uploads/partners/' . $logo_name;

        if (move_uploaded_file($_FILES['logo']['tmp_name'], $upload_path)) {
            $logo = $logo_name;
        } else {
            $error = "فشل رفع الشعار!";
        }
    } else {
        $error = "يجب رفع شعار الشريك!";
    }

    if (!$error && $name && $logo) {
        $stmt = $pdo->prepare("INSERT INTO partners (name, logo, link, status) VALUES (?, ?, ?, ?)");
        $stmt->execute([$name, $logo, $link, $status]);
        $success = "تمت إضافة الشريك بنجاح!";
    } elseif (!$error) {
        $error = "جميع الحقول مطلوبة!";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة شريك جديد</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
        }
        .container {
            max-width: 440px;
            margin: 55px auto 0 auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            padding: 38px 30px 25px 30px;
        }
        h2 {
            text-align: center;
            color: #7c3aed;
            font-weight: 800;
            margin-bottom: 28px;
            font-size: 1.3rem;
        }
        .alert-success {
            color: #128a24;
            background: #e8faee;
            padding: 9px 17px;
            border-radius: 7px;
            margin-bottom: 16px;
            text-align: center;
            font-weight: 600;
        }
        .alert-error {
            color: #c00;
            background: #fbeaea;
            padding: 9px 17px;
            border-radius: 7px;
            margin-bottom: 16px;
            text-align: center;
            font-weight: 600;
        }
        .form-group {
            margin-bottom: 21px;
        }
        label {
            font-weight: 600;
            color: #40215b;
            display: block;
            margin-bottom: 7px;
        }
        input[type="text"], input[type="url"], input[type="file"], select {
            width: 100%;
            padding: 11px;
            border: 1.4px solid #e8e3fa;
            border-radius: 7px;
            background: #fcfbff;
            font-family: 'Cairo', sans-serif;
            font-size: 1rem;
        }
        input[type="file"] {
            padding: 7px 2px;
            background: #fff;
        }
        button[type="submit"] {
            background: linear-gradient(135deg, #7c3aed, #3e165a);
            color: #fff;
            padding: 12px 0;
            border: none;
            border-radius: 7px;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.17s, box-shadow 0.16s;
            box-shadow: 0 2px 9px #e8e1fa77;
            margin-top: 8px;
            width: 100%;
        }
        button[type="submit"]:hover {
            background: linear-gradient(135deg, #3e165a, #7c3aed);
        }
        .back-btn {
            display: block;
            margin-top: 23px;
            color: #7c3aed;
            font-weight: 600;
            text-align: center;
            text-decoration: none;
            font-size: 15px;
            padding: 8px 0;
            border-radius: 6px;
            transition: background 0.13s;
        }
        .back-btn:hover {
            background: #f6efff;
            color: #3e165a;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2><i class="fa fa-plus"></i> إضافة شريك جديد</h2>
        <?php if ($error): ?>
            <div class="alert-error"><?= $error ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert-success"><?= $success ?></div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label>اسم الشريك *</label>
                <input type="text" name="name" required>
            </div>
            <div class="form-group">
                <label>رابط موقع الشريك (اختياري)</label>
                <input type="url" name="link" placeholder="https://example.com">
            </div>
            <div class="form-group">
                <label>الشعار *</label>
                <input type="file" name="logo" accept="image/*" required>
            </div>
            <div class="form-group">
                <label>الحالة</label>
                <select name="status">
                    <option value="active">مفعل</option>
                    <option value="inactive">غير مفعل</option>
                </select>
            </div>
            <button type="submit"><i class="fa fa-plus"></i> إضافة</button>
        </form>
        <a href="partners.php" class="back-btn"><i class="fa fa-arrow-right"></i> العودة للقائمة</a>
    </div>
</body>
</html>
