<?php
require_once "../includes/auth.php";
require_once "../config/db.php";
$stmt = $pdo->query("SELECT o.*, c.name AS company FROM offers o LEFT JOIN companies c ON o.company_id = c.id ORDER BY o.id DESC");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>العروض</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            color: #2e2340;
            margin: 0;
        }
        .container {
            max-width: 1050px;
            margin: 45px auto 0 auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            padding: 38px 24px 25px 24px;
            min-height: 540px;
        }
        .header-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 35px;
        }
        .header-bar h2 {
            color: #3e165a;
            font-size: 2rem;
            font-weight: 800;
            margin: 0;
        }
        .home-btn {
            background: linear-gradient(135deg, #3e165a 60%, #7c3aed 100%);
            color: #fff;
            padding: 8px 24px 8px 18px;
            border-radius: 50px;
            border: none;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            transition: background 0.2s, box-shadow 0.2s;
            box-shadow: 0 3px 15px rgba(62,22,90,0.09);
            text-decoration: none !important;
        }
        .home-btn i {
            margin-left: 10px;
            font-size: 1.2em;
        }
        .home-btn:hover {
            background: linear-gradient(135deg, #7c3aed, #3e165a);
        }

        /* رسائل التنبيه */
        .alert-success {
            color: #fff;
            background: #4caf50;
            padding: 11px 24px;
            border-radius: 10px;
            margin-bottom: 15px;
            display: inline-block;
            font-size: 1rem;
        }

        /* جدول العروض */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background: #fff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 1px 9px #ece1fd3a;
            font-size: 1rem;
        }
        th, td {
            padding: 14px 7px;
            text-align: center;
        }
        th {
            background: linear-gradient(135deg, #3e165a 80%, #7c3aed 100%);
            color: #fff;
            font-size: 1.05rem;
            font-weight: 700;
            border-bottom: 2px solid #eee;
        }
        tr:nth-child(even) td {
            background: #f5f4fa;
        }
        tr:nth-child(odd) td {
            background: #fff;
        }
        td {
            color: #40215b;
            border-bottom: 1px solid #eee;
            vertical-align: middle;
        }

        /* أزرار التحكم */
        .toggle-home {
            display: inline-block;
            padding: 6px 19px;
            font-size: 13px;
            border-radius: 17px;
            border: none;
            cursor: pointer;
            background: #ece1fd;
            color: #3e165a;
            font-weight: 600;
            transition: all 0.15s;
        }
        .toggle-home.active {
            background: #27ae60;
            color: #fff;
            font-weight: bold;
            border: 1px solid #27ae60;
        }
        .toggle-home:hover { filter: brightness(0.96); }

        .action-links a {
            color: #7c3aed;
            font-weight: 700;
            margin: 0 5px;
            padding: 4px 10px;
            border-radius: 7px;
            transition: background 0.13s, color 0.12s;
            text-decoration: none !important;
            font-size: 14px;
            border: 1px solid #f0eafd;
        }
        .action-links a:hover {
            background: #7c3aed;
            color: #fff !important;
        }
        .action-links a.delete {
            color: #e74c3c;
            border-color: #ffebeb;
        }
        .action-links a.delete:hover {
            background: #e74c3c;
            color: #fff !important;
        }
        .status-approved {
            color: #27ae60;
            font-weight: 800;
            font-size: 15px;
        }
        .status-waiting {
            color: #e67e22;
            font-weight: 700;
            font-size: 15px;
        }
        @media (max-width: 700px) {
            .container { padding: 14px 2vw; }
            table, thead, tbody, th, td, tr { font-size: 13px; }
            .header-bar h2 { font-size: 1.1rem; }
            .home-btn { padding: 6px 12px 6px 10px; font-size: 13px; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header-bar">
            <h2><i class="fa fa-percent" style="color:#7c3aed; margin-left:7px;"></i> العروض</h2>
            <a href="index.php" class="home-btn"><i class="fa fa-home"></i> الرئيسية</a>
        </div>

        <?php if (isset($_GET['msg']) && $_GET['msg'] == 'approved'): ?>
        <div class="alert-success">
            <i class="fa fa-check-circle"></i> تم اعتماد العرض بنجاح.
        </div>
        <?php endif; ?>

        <table>
            <thead>
                <tr>
                    <th>العرض</th>
                    <th>الشركة</th>
                    <th>السعر الجديد</th>
                    <th>الحالة</th>
                    <th>في الرئيسية</th>
                    <th>التحكم</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($stmt as $o): ?>
                <tr>
                    <td><?= htmlspecialchars($o['title']) ?></td>
                    <td><?= htmlspecialchars($o['company']) ?></td>
                    <td><?= $o['new_price'] ?></td>
                    <td>
                        <?php if($o['status'] == 'موافق'): ?>
                            <span class="status-approved">معتمد</span>
                        <?php else: ?>
                            <span class="status-waiting">بانتظار الموافقة</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <form method="post" action="toggle_home.php" style="display:inline;">
                            <input type="hidden" name="id" value="<?= $o['id'] ?>">
                            <button type="submit" name="toggle" class="toggle-home<?= $o['show_on_home'] ? ' active' : '' ?>">
                                <?= $o['show_on_home'] ? '✔️ معروض' : '✖️ مخفي' ?>
                            </button>
                        </form>
                    </td>
                    <td class="action-links">
                        <a href="offer_edit.php?id=<?= $o['id'] ?>"><i class="fa fa-edit"></i> تعديل</a>
                        <?php if($o['status'] != 'موافق'): ?>
                            <a href="offer_approve.php?id=<?= $o['id'] ?>"><i class="fa fa-check"></i> اعتماد</a>
                        <?php endif; ?>
                        <a href="offer_delete.php?id=<?= $o['id'] ?>" class="delete" onclick="return confirm('تأكيد الحذف؟')"><i class="fa fa-trash"></i> حذف</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
