<?php
require_once "../config/db.php";

// جلب المدن والتصنيفات من القاعدة
$categories = $pdo->query("SELECT id, name FROM categories ORDER BY name ASC")->fetchAll();
$cities = $pdo->query("SELECT id, name FROM cities ORDER BY name ASC")->fetchAll();

$error = '';
$success = '';

// عند إرسال النموذج
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name        = trim($_POST['name'] ?? '');
    $phone       = trim($_POST['phone'] ?? '');
    $city_id     = intval($_POST['city_id'] ?? 0);
    $category_id = intval($_POST['category_id'] ?? 0);
    $about       = trim($_POST['about'] ?? '');
    $status      = $_POST['status'] ?? 'pending';
    $user_id     = 1; // يمكنك ربطها بحساب مدير النظام أو مالك الشركة لاحقاً

    // معالجة الشعار
    $logo = '';
    if (!empty($_FILES['logo']['name'])) {
        $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
        $logo_name = 'logo_' . time() . rand(1, 99999) . '.' . $ext;
        $logo_path = '../uploads/companies/' . $logo_name;
        if (move_uploaded_file($_FILES['logo']['tmp_name'], $logo_path)) {
            $logo = 'uploads/companies/' . $logo_name;
        }
    }

    // معالجة صورة الغلاف
    $cover = '';
    if (!empty($_FILES['cover']['name'])) {
        $ext = pathinfo($_FILES['cover']['name'], PATHINFO_EXTENSION);
        $cover_name = 'cover_' . time() . rand(1, 99999) . '.' . $ext;
        $cover_path = '../uploads/companies/' . $cover_name;
        if (move_uploaded_file($_FILES['cover']['tmp_name'], $cover_path)) {
            $cover = 'uploads/companies/' . $cover_name;
        }
    }

    // تحقق من الحقول المطلوبة
    if (!$name || !$phone || !$city_id || !$category_id) {
        $error = "جميع الحقول مطلوبة!";
    } else {
        $stmt = $pdo->prepare("INSERT INTO companies (user_id, name, phone, city_id, category_id, about, logo, cover, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        if ($stmt->execute([$user_id, $name, $phone, $city_id, $category_id, $about, $logo, $cover, $status])) {
            $success = "تمت إضافة الشركة بنجاح!";
        } else {
            $error = "حدث خطأ أثناء إضافة الشركة!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة شركة جديدة</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body { background: #f8f9fa; font-family: 'Cairo', sans-serif; color: #2e2340; margin: 0;}
        .container { max-width: 600px; margin: 45px auto 0 auto; background: #fff; border-radius: 16px; box-shadow: 0 7px 30px #e6e6e6; padding: 38px 24px 25px 24px; min-height: 320px;}
        h2 { color: #3e165a; font-size: 1.5rem; font-weight: 800; margin-bottom: 18px;}
        label { font-weight:600; margin-top: 18px; display: block; color: #481c79;}
        input, select, textarea { width: 100%; padding: 8px 11px; margin-top: 7px; border-radius: 8px; border: 1px solid #e3d7fc; background: #f8f6fc; font-size: 1rem; font-family: inherit;}
        input:focus, select:focus, textarea:focus { border-color: #7c3aed; outline: none;}
        textarea { min-height: 70px; }
        .form-actions { margin-top: 26px; text-align:center; }
        .btn-main { background: #7c3aed; color: #fff; border: none; font-weight: 700; border-radius: 50px; padding: 11px 38px; font-size: 1.1rem; cursor: pointer;}
        .btn-main:hover { background: #3e165a; }
        .alert-error { color: #c00; background: #fde4e4; padding: 8px 18px; border-radius: 7px; margin-bottom: 17px; text-align: right; font-weight: bold;}
        .alert-success { color: #128a24; background: #e8faee; padding: 8px 18px; border-radius: 7px; margin-bottom: 17px; text-align: right; font-weight: bold;}
    </style>
</head>
<body>
    <div class="container">
        <h2><i class="fa fa-plus"></i> إضافة شركة جديدة</h2>
        <?php if ($error): ?><div class="alert-error"><?= $error ?></div><?php endif; ?>
        <?php if ($success): ?><div class="alert-success"><?= $success ?></div><?php endif; ?>
        <form method="post" enctype="multipart/form-data">
            <label>اسم الشركة *</label>
            <input type="text" name="name" required>

            <label>الهاتف *</label>
            <input type="text" name="phone" required>

            <label>التصنيف *</label>
            <select name="category_id" required>
                <option value="">اختر التصنيف</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                <?php endforeach; ?>
            </select>

            <label>المدينة *</label>
            <select name="city_id" required>
                <option value="">اختر المدينة</option>
                <?php foreach ($cities as $c): ?>
                    <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
                <?php endforeach; ?>
            </select>

            <label>عن الشركة</label>
            <textarea name="about"></textarea>

            <label>الشعار</label>
            <input type="file" name="logo" accept="image/*">

            <label>صورة الغلاف</label>
            <input type="file" name="cover" accept="image/*">

            <label>الحالة</label>
            <select name="status">
                <option value="pending">بانتظار الموافقة</option>
                <option value="approved">معتمدة</option>
                <option value="inactive">غير فعالة</option>
            </select>

            <div class="form-actions">
                <button class="btn-main" type="submit"><i class="fa fa-save"></i> إضافة الشركة</button>
            </div>
        </form>
    </div>
</body>
</html>
