<?php
require_once "../includes/auth.php";
require_once "../config/db.php";

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    if ($name) {
        $stmt = $pdo->prepare("INSERT INTO cities (name) VALUES (?)");
        $stmt->execute([$name]);
        $success = "تمت إضافة المدينة بنجاح!";
    } else {
        $error = "يرجى إدخال اسم المدينة!";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة مدينة جديدة</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
        }
        .container {
            max-width: 420px;
            margin: 60px auto 0 auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            padding: 38px 30px 25px 30px;
        }
        h2 {
            text-align: center;
            color: #7c3aed;
            font-weight: 800;
            margin-bottom: 28px;
            font-size: 1.3rem;
        }
        .alert-success {
            color: #128a24;
            background: #e8faee;
            padding: 9px 17px;
            border-radius: 7px;
            margin-bottom: 16px;
            text-align: center;
            font-weight: 600;
        }
        .alert-error {
            color: #c00;
            background: #fbeaea;
            padding: 9px 17px;
            border-radius: 7px;
            margin-bottom: 16px;
            text-align: center;
            font-weight: 600;
        }
        .form-group {
            margin-bottom: 23px;
        }
        label {
            font-weight: 600;
            color: #40215b;
            display: block;
            margin-bottom: 7px;
        }
        input[type="text"] {
            width: 100%;
            padding: 12px;
            border: 1.4px solid #e8e3fa;
            border-radius: 7px;
            background: #fcfbff;
            font-family: 'Cairo', sans-serif;
            font-size: 1rem;
        }
        button[type="submit"] {
            background: linear-gradient(135deg, #7c3aed, #3e165a);
            color: #fff;
            padding: 13px 0;
            border: none;
            border-radius: 7px;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.17s, box-shadow 0.16s;
            box-shadow: 0 2px 9px #e8e1fa77;
            margin-top: 5px;
            width: 100%;
        }
        button[type="submit"]:hover {
            background: linear-gradient(135deg, #3e165a, #7c3aed);
        }
        .back-btn {
            display: block;
            margin-top: 23px;
            color: #7c3aed;
            font-weight: 600;
            text-align: center;
            text-decoration: none;
            font-size: 15px;
            padding: 8px 0;
            border-radius: 6px;
            transition: background 0.13s;
        }
        .back-btn:hover {
            background: #f6efff;
            color: #3e165a;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2><i class="fa fa-plus"></i> إضافة مدينة جديدة</h2>
        <?php if ($error): ?>
            <div class="alert-error"><?= $error ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert-success"><?= $success ?></div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label>اسم المدينة *</label>
                <input type="text" name="name" required>
            </div>
            <button type="submit"><i class="fa fa-plus"></i> إضافة</button>
        </form>
        <a href="cities.php" class="back-btn"><i class="fa fa-arrow-right"></i> العودة للقائمة</a>
    </div>
</body>
</html>
