<?php
require_once 'config/db.php';
include "includes/seo.php";   // تفعيل SEO
$success = '';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $company_name = trim($_POST['company_name']);
    $category_id  = intval($_POST['category_id']);
    $city_id      = intval($_POST['city_id']);
    $phone        = trim($_POST['phone']);
    $email        = trim($_POST['email']);
    $password     = trim($_POST['password']);

    // تحقق من الحقول
    if (!$company_name || !$email || !$phone || !$password || !$category_id || !$city_id) {
        $errors[] = "جميع الحقول مطلوبة.";
    }

    // تحقق من البريد إذا كان مستخدم بالفعل
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->fetch()) {
        $errors[] = "البريد الإلكتروني مستخدم بالفعل.";
    }

    if (empty($errors)) {
        // إنشاء المستخدم
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);
        $stmt = $pdo->prepare("INSERT INTO users (name, email, password) VALUES (?, ?, ?)");
        $stmt->execute([$company_name, $email, $hashed_password]);
        $user_id = $pdo->lastInsertId();

        // إنشاء الشركة
        $stmt = $pdo->prepare("INSERT INTO companies (user_id, name, category_id, city_id, phone, email, status) VALUES (?, ?, ?, ?, ?, ?, 'pending')");
        $stmt->execute([$user_id, $company_name, $category_id, $city_id, $phone, $email]);

        $success = "تم تسجيل الشركة بنجاح! برجاء انتظار موافقة الإدارة.";
    }
}

// جلب التصنيفات والمدن
$categories = $pdo->query("SELECT * FROM categories")->fetchAll();
$cities = $pdo->query("SELECT * FROM cities")->fetchAll();
?>
<style>
.register-form {
  max-width: 500px;
  margin: 40px auto 80px auto;
  background: #fff;
  padding: 38px 24px 28px 24px;
  border-radius: 15px;
  box-shadow: 0 4px 32px #c2c2c229;
}

.register-form h2 {
  margin-bottom: 24px;
  text-align: center;
  font-size: 22px;
  color: #6d2490;
}

.form-group {
  margin-bottom: 16px;
}

.form-group label {
  display: block;
  margin-bottom: 6px;
  font-weight: bold;
  color: #333;
}

.form-group input[type="text"],
.form-group input[type="email"],
.form-group input[type="password"],
.form-group select {
  width: 100%;
  padding: 10px 12px;
  font-family: 'Cairo', sans-serif;
  font-size: 15px;
  border: 1px solid #ccc;
  border-radius: 8px;
  box-sizing: border-box;
  background-color: #fff;
}

.main-btn {
  background-color: #6d2490;
  color: white;
  padding: 12px;
  font-size: 16px;
  border: none;
  border-radius: 10px;
  cursor: pointer;
  transition: background-color 0.3s ease;
  text-align: center;
  display: inline-block;
  text-decoration: none;
}

.main-btn:hover {
  background-color: #5a1e79;
}

.alert {
  font-size: 15px;
  line-height: 1.6;
}

/* استجابة الجوال */
@media (max-width: 600px) {
  .register-form {
    padding: 26px 15px;
    margin: 20px 10px 60px;
  }

  .form-group {
    margin-bottom: 14px;
  }

  .form-group label {
    font-size: 14px;
  }

  .form-group input,
  .form-group select {
    font-size: 14px;
    padding: 9px 10px;
  }

  .main-btn {
    font-size: 15px;
    padding: 10px;
  }

  .register-form h2 {
    font-size: 20px;
  }
}
</style>

<?php include "includes/header.php"; ?>

<div class="register-form" style="max-width:500px;margin:40px auto 80px auto;background:#fff;padding:38px 24px 28px 24px;border-radius:15px;box-shadow:0 4px 32px #c2c2c229;">
    <h2 style="margin-bottom:24px;text-align:center;">تسجيل شركتك في الدليل</h2>
    <?php if ($errors): ?>
        <div class="alert alert-danger" style="color:#fff;background:#e74c3c;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?php foreach ($errors as $e) echo "<div>$e</div>"; ?>
        </div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success" style="color:#fff;background:#27ae60;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?= $success ?>
        </div>
    <?php endif; ?>
    <form method="post" autocomplete="off">
        <div class="form-group">
            <label>اسم الشركة</label>
            <input type="text" name="company_name" placeholder="اسم الشركة" required>
        </div>
        <div class="form-group">
            <label>البريد الإلكتروني</label>
            <input type="email" name="email" placeholder="example@email.com" required>
        </div>
        <div class="form-group">
            <label>رقم الجوال</label>
            <input type="text" name="phone" placeholder="05xxxxxxxx" required>
        </div>
        <div class="form-group">
            <label>كلمة المرور</label>
            <input type="password" name="password" placeholder="كلمة المرور" required>
        </div>
        <div class="form-group">
            <label>المجال</label>
            <select name="category_id" required>
                <option value="">اختر المجال</option>
                <?php foreach($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>المدينة</label>
            <select name="city_id" required>
                <option value="">اختر المدينة</option>
                <?php foreach($cities as $city): ?>
                    <option value="<?= $city['id'] ?>"><?= htmlspecialchars($city['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="main-btn" style="width:100%;margin-top:12px;">تسجيل الشركة</button>
    </form>
    <div style="text-align:center;margin-top:18px;">
        لديك حساب بالفعل؟ <a href="login.php" style="color:#7c3aed;font-weight:500;">سجّل الدخول</a>
    </div>
</div>

<?php include "includes/footer.php"; ?>
