<?php
require_once "config/db.php";
include "includes/header.php";

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$stmt = $pdo->prepare("SELECT * FROM posts WHERE id = ? AND status = 'published'");
$stmt->execute([$id]);
$post = $stmt->fetch();

if (!$post) {
  echo "<div style='text-align:center;padding:50px;'>المقال غير موجود</div>";
  include "includes/footer.php";
  exit;
}
?>

<div class="page-header">
  <h1><?= htmlspecialchars($post['title']) ?></h1>
</div>

<div class="post-content" style="max-width:850px;margin:0 auto 40px;padding:20px;background:#fff;border-radius:15px;box-shadow:0 2px 12px #00000010;">
  <?php if (!empty($post['image'])): ?>
    <img src="<?= htmlspecialchars($post['image']) ?>" style="width:100%;max-height:400px;object-fit:cover;border-radius:12px;margin-bottom:20px;">
  <?php endif; ?>
  <div style="color:#555;font-size:16px;line-height:1.8;"><?= $post['content'] ?></div>
</div>

<?php include "includes/footer.php"; ?>
