<?php
require_once 'config/db.php';
session_start();

$errors = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email    = trim($_POST['email']);
    $password = trim($_POST['password']);

    if (!$email || !$password) {
        $errors[] = "جميع الحقول مطلوبة.";
    } else {
        // البحث عن المستخدم
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            // الدخول ناجح، تخزين بيانات المستخدم في الجلسة
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_email'] = $user['email'];

            // إعادة توجيه إلى لوحة التحكم أو الرئيسية
            header("Location: dashboard/index.php");
            exit;
        } else {
            $errors[] = "البريد الإلكتروني أو كلمة المرور غير صحيحة.";
        }
    }
}
?>
<style>
.register-form {
  max-width: 400px;
  margin: 40px auto 80px auto;
  background: #fff;
  padding: 38px 24px 28px 24px;
  border-radius: 15px;
  box-shadow: 0 4px 32px #c2c2c229;
}

.register-form h2 {
  margin-bottom: 24px;
  text-align: center;
  font-size: 22px;
  color: #6d2490;
}

.form-group {
  margin-bottom: 16px;
}

.form-group label {
  display: block;
  margin-bottom: 6px;
  font-weight: bold;
  color: #333;
}

.form-group input {
  width: 100%;
  padding: 10px 12px;
  font-family: 'Cairo', sans-serif;
  font-size: 15px;
  border: 1px solid #ccc;
  border-radius: 8px;
  box-sizing: border-box;
  background-color: #fff;
}

.main-btn {
  background-color: #6d2490;
  color: white;
  padding: 12px;
  font-size: 16px;
  border: none;
  border-radius: 10px;
  cursor: pointer;
  transition: background-color 0.3s ease;
  text-align: center;
  display: inline-block;
  text-decoration: none;
}

.main-btn:hover {
  background-color: #5a1e79;
}

.alert {
  font-size: 15px;
  line-height: 1.6;
}

@media (max-width: 480px) {
  .register-form {
    padding: 28px 15px;
    margin: 20px 10px 60px;
  }

  .form-group input {
    padding: 9px 10px;
    font-size: 14px;
  }

  .main-btn {
    font-size: 15px;
    padding: 10px;
  }

  .register-form h2 {
    font-size: 20px;
  }
}
</style>

<?php include "includes/header.php"; ?>

<div class="register-form" style="max-width:400px;margin:40px auto 80px auto;background:#fff;padding:38px 24px 28px 24px;border-radius:15px;box-shadow:0 4px 32px #c2c2c229;">
    <h2 style="margin-bottom:24px;text-align:center;">تسجيل الدخول</h2>
    <?php if ($errors): ?>
        <div class="alert alert-danger" style="color:#fff;background:#e74c3c;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?php foreach ($errors as $e) echo "<div>$e</div>"; ?>
        </div>
    <?php endif; ?>
    <form method="post" autocomplete="off">
        <div class="form-group">
            <label>البريد الإلكتروني</label>
            <input type="email" name="email" placeholder="example@email.com" required>
        </div>
        <div class="form-group">
            <label>كلمة المرور</label>
            <input type="password" name="password" placeholder="كلمة المرور" required>
        </div>
        <button type="submit" class="main-btn" style="width:100%;margin-top:12px;">دخول</button>
    </form>
    <div style="text-align:center;margin-top:18px;">
        ليس لديك حساب؟ <a href="register.php" style="color:#7c3aed;font-weight:500;">سجّل شركتك الآن</a>
    </div>
</div>

<?php include "includes/footer.php"; ?>
