<?php
require_once "config/db.php";
include "includes/header.php";
include "includes/seo.php";   // تفعيل SEO
// جلب التصنيفات والمدن من قاعدة البيانات
$categories = $pdo->query("SELECT * FROM categories ORDER BY name ASC")->fetchAll();
$cities = $pdo->query("SELECT * FROM cities ORDER BY name ASC")->fetchAll();

// جلب أحدث العروض
$stmt = $pdo->prepare("
    SELECT o.*, c.name AS company_name, c.logo AS company_logo, c.phone, c.whatsapp
    FROM offers o
    JOIN companies c ON o.company_id = c.id
    WHERE o.status = 'موافق'
    ORDER BY o.id DESC
    LIMIT 8
");

$featured_companies = $pdo->query("SELECT c.id, c.name, c.logo, c.cover, c.about, c.phone, c.whatsapp,
    cat.name AS category_name, city.name AS city_name
    FROM companies c
    LEFT JOIN categories cat ON c.category_id = cat.id
    LEFT JOIN cities city ON c.city_id = city.id
    WHERE c.status = 'approved' AND c.featured = 1
    ORDER BY c.id DESC
    LIMIT 6")->fetchAll();


$stmt->execute();
$offers = $stmt->fetchAll();

// جلب السلايدر العلوي
$sliders_top = $pdo->query("SELECT * FROM sliders WHERE active=1 AND type='top' AND expire_date >= CURDATE() ORDER BY id DESC")->fetchAll();
// جلب السلايدر السفلي
$sliders_bottom = $pdo->query("SELECT * FROM sliders WHERE active=1 AND type='bottom' AND expire_date >= CURDATE() ORDER BY id DESC")->fetchAll();
// جلب الشركاء
$partners = $pdo->query("SELECT * FROM partners ORDER BY id DESC")->fetchAll();

// نتائج البحث
$results = [];
if ($_SERVER['REQUEST_METHOD'] === 'GET' && (isset($_GET['category_id']) || isset($_GET['city_id']))) {
    $categoryId = !empty($_GET['category_id']) ? intval($_GET['category_id']) : 0;
    $cityId = !empty($_GET['city_id']) ? intval($_GET['city_id']) : 0;

    $sql = "SELECT c.*, cat.name AS category_name, city.name AS city_name 
            FROM companies c
            LEFT JOIN categories cat ON c.category_id = cat.id
            LEFT JOIN cities city ON c.city_id = city.id
            WHERE c.status = 'approved'";

    $params = [];
    if ($categoryId) {
        $sql .= " AND c.category_id = :category_id";
        $params[':category_id'] = $categoryId;
    }
    if ($cityId) {
        $sql .= " AND c.city_id = :city_id";
        $params[':city_id'] = $cityId;
    }

    $sql .= " ORDER BY c.featured DESC, c.id DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $results = $stmt->fetchAll();
}

// دالة ضبط رقم الواتساب
function formatWhatsapp($number) {
    $number = preg_replace('/[^0-9]/', '', $number);
    if (strpos($number, '0') === 0) $number = '966' . substr($number, 1);
    elseif (strpos($number, '966') !== 0) $number = '966' . $number;
    return $number;
}
?>


<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
  <title>بحث تجاري</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
  <title>بحث تجاري</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
<style>
  :root {
    --primary-color: #6d2490;
    --secondary-color: #ffb300;
    --accent-color: #25d366;
    --dark-color: #2c3e50;
    --light-color: #f8f9fa;
  }

  /* ===== عام وبطاقات الشركات (بدون تغيير) ===== */
  .company-card2 { position: relative; overflow: visible; }
  .cover-image { z-index: 1; position: relative; }

  .actions {
    display: flex; flex-wrap: wrap; gap: 10px; padding: 15px 20px;
    justify-content: center; z-index: 2; position: relative;
  }
  .actions a {
    flex: 1 1 45%; text-align: center; font-size: 14px; padding: 10px;
    border-radius: 8px; text-decoration: none; color: #fff;
  }
  .btn-contact { background-color: #28a745; }
  .btn-details { background-color: #6f42c1; }
  @media (max-width: 768px){ .actions a { flex: 1 1 100%; } }

  html, body {
    margin: 0; padding: 0; overflow-x: hidden;
    font-family: 'Cairo', sans-serif; background-color: #f8f8fa;
  }

  /* ===== هيدر الفيديو + نموذج البحث (بدون تغيير) ===== */
  .hero-search-section {
    position: relative; height: 500px; overflow: hidden;
    border-radius: 0 0 30px 30px; box-shadow: 0 10px 30px rgba(0,0,0,0.1);
  }
  .hero-search-section .video-wrapper{ position:absolute; top:0; left:0; width:100%; height:100%; z-index:0; }
  .hero-search-section video{ width:100%; height:100%; object-fit:cover; }
  .search-overlay{
    position:absolute; bottom:30px; right:0; left:0; z-index:2;
    display:flex; justify-content:center; padding:0 20px;
  }
  .search-form{
    display:flex; background:rgba(0,0,0,0.6); backdrop-filter:blur(8px);
    padding:18px 22px; border-radius:18px; gap:15px; flex-wrap:wrap;
    align-items:flex-end; box-shadow:0 8px 24px rgba(0,0,0,0.2);
    width:100%; max-width:950px; border:1px solid rgba(255,255,255,0.1);
  }
  .search-form .form-group{ display:flex; flex-direction:column; min-width:180px; flex-grow:1; }
  .search-form label{ color:#fff; font-size:14px; margin-bottom:6px; font-weight:500; }
  .search-form select, .search-form input{
    padding:10px 12px; border:none; border-radius:10px; font-size:15px; min-width:160px;
    background-color:rgba(255,255,255,0.9); transition:all .3s ease;
  }
  .search-form select:focus, .search-form input:focus{
    outline:none; box-shadow:0 0 0 3px rgba(109,36,144,.3);
  }
  .search-btn{
    background:var(--primary-color); color:#fff; padding:12px 24px; border-radius:12px;
    font-weight:bold; border:none; cursor:pointer; margin-top:20px; min-width:120px; font-size:16px;
    transition:all .3s ease; box-shadow:0 4px 12px rgba(109,36,144,.3);
  }
  .search-btn:hover{ background:#52187c; transform:translateY(-2px); box-shadow:0 6px 16px rgba(109,36,144,.4); }
  @media (max-width: 768px){
    .hero-search-section{ height:450px; }
    .search-form{ flex-direction:column; align-items:stretch; padding:15px; }
    .search-btn{ width:100%; margin-top:15px; }
  }

  /* ===== عناوين واقسام عامة (بدون تغيير) ===== */
  .page-header{ text-align:center; margin:40px auto 30px; max-width:800px; padding:0 20px; }
  .page-header h1{
    font-size:32px; color:var(--primary-color); margin-bottom:10px; position:relative; display:inline-block;
  }
  .page-header h1:after{
    content:''; position:absolute; bottom:-8px; left:50%; transform:translateX(-50%);
    width:80px; height:3px; background:var(--secondary-color); border-radius:3px;
  }
  .page-header p{ color:#666; font-size:16px; margin-top:10px; }

  .section-title{
    font-size:28px; font-weight:bold; color:var(--primary-color);
    margin:50px 0 30px; padding:0 20px; position:relative; display:flex; align-items:center; justify-content:center; gap:10px;
  }
  .section-title i{ color:var(--secondary-color); font-size:24px; }
  .section-title:after{ content:''; flex:1; height:2px; background:linear-gradient(90deg, transparent, #ddd, transparent); }

  /* ===== شبكة الشركات ===== */
  .companies-grid{
    display:grid; grid-template-columns:repeat(auto-fit, minmax(300px, 1fr));
    gap:25px; margin:30px auto; padding:0 20px; max-width:1200px;
  }
  .company-card2{
    background:#fff; border-radius:20px; box-shadow:0 5px 20px rgba(0,0,0,.08);
    overflow:hidden; transition:all .3s ease; position:relative; margin-bottom:25px;
  }
  .company-card2:hover{ transform:translateY(-5px); box-shadow:0 10px 30px rgba(0,0,0,.15); }
  .cover-image{
    width:100%; height:150px; background-size:cover; background-position:center; position:relative;
  }
  .status-badge{
    position:absolute; top:15px; left:15px; background:rgba(255,255,255,.9);
    color:var(--primary-color); font-size:14px; font-weight:600; border-radius:20px;
    padding:5px 15px; box-shadow:0 3px 10px rgba(0,0,0,.1); z-index:2;
  }
  .company-header{
    display:flex; align-items:flex-start; gap:15px; padding:0 20px; margin-top:-30px; position:relative; z-index:1;
  }
  .logo-wrap{
    width:70px; height:70px; border-radius:50%; overflow:hidden; border:3px solid #fff; background:#fff;
    box-shadow:0 3px 15px rgba(0,0,0,.1); display:flex; align-items:center; justify-content:center; margin-top:-35px;
  }
  .logo-wrap img{ width:100%; height:100%; object-fit:cover; }
  .company-info{ flex:1; padding-top:10px; }
  .company-name-badge{
    background:#fff; color:var(--primary-color); font-size:18px; font-weight:bold; border-radius:15px;
    padding:6px 15px; box-shadow:0 2px 10px rgba(0,0,0,.05); border:1px solid #eee; display:inline-block; margin-bottom:5px;
  }
  .meta{ color:#777; font-size:14px; display:flex; flex-wrap:wrap; gap:10px; }
  .meta span{ display:flex; align-items:center; gap:5px; }
  .description{
    color:#555; font-size:15px; padding:15px 20px; line-height:1.5; border-bottom:1px solid #f0f0f0; margin:0;
  }
  .btn-details{
    background:var(--primary-color); color:#fff; padding:8px 20px; border-radius:8px; font-size:15px;
    text-decoration:none; font-weight:600; transition:all .3s ease; flex:1; text-align:center;
  }
  .btn-details:hover{ background:#52187c; transform:translateY(-2px); }
  .btn-contact{
    background:var(--accent-color); color:#fff; padding:8px 20px; border-radius:8px; font-size:15px;
    text-decoration:none; font-weight:600; transition:all .3s ease; flex:1; text-align:center;
  }
  .btn-contact:hover{ background:#1da851; transform:translateY(-2px); }

  /* ===== سلايدر العروض (Slick) ===== */
  .offers-slider{ width:95%; margin:0 auto 50px; padding:0 10px; }
  .offer-card.offer-style2{
    background:#fff; border-radius:20px; box-shadow:0 8px 25px rgba(0,0,0,.08); margin:15px; overflow:hidden; transition:all .3s ease; position:relative;
  }
  .offer-card.offer-style2:hover{ transform:translateY(-5px); box-shadow:0 12px 35px rgba(0,0,0,.15); }
  .offer-img2{ width:100%; height:180px; background:#f5f5fa; display:flex; align-items:center; justify-content:center; overflow:hidden; position:relative; }
  .offer-img2 img{ width:100%; height:100%; object-fit:cover; transition: transform .5s ease; }
  .offer-card.offer-style2:hover .offer-img2 img{ transform: scale(1.05); }
  .offer-body{ padding:20px; }
  .offer-title{ font-size:20px; font-weight:bold; color:#222; margin-bottom:10px; text-align:center; }
  .offer-desc{ color:#777; font-size:15px; line-height:1.5; margin-bottom:15px; text-align:center; }
  .offer-prices{ display:flex; align-items:center; justify-content:center; gap:15px; margin-bottom:15px; }
  .old-price{ color:#b7b7b7; text-decoration:line-through; font-size:16px; }
  .new-price{ color:#18a300; font-weight:bold; font-size:20px; }
  .offer-expire{ color:#666; font-size:14px; display:flex; align-items:center; justify-content:center; gap:5px; margin-bottom:15px; }
  .offer-actions{ display:flex; justify-content:center; gap:10px; }
  .btn-icon{
    width:45px; height:45px; border-radius:10px; display:flex; align-items:center; justify-content:center;
    color:#fff; font-size:20px; transition:all .3s ease;
  }
  .btn-icon:hover{ transform:translateY(-3px); box-shadow:0 5px 15px rgba(0,0,0,.1); }
  .btn-icon.whatsapp{ background:var(--accent-color); }
  .btn-icon.phone{ background:var(--primary-color); }
  .btn-icon.page{ background:var(--secondary-color); }

  /* ===== سلايدر الشركاء (Slick) ===== */
  .featured-slider{ max-width:1200px; margin:60px auto; padding:0 20px; }
  .slider-header{ display:flex; justify-content:space-between; align-items:center; margin-bottom:20px; padding:0 10px; }
  .slider-header h2{ font-size:24px; color:var(--primary-color); display:flex; align-items:center; gap:10px; }
  .slider-nav{ display:flex; gap:10px; }
  .slider-nav button{
    background:#fff; border:1px solid #ddd; width:40px; height:40px; border-radius:50%;
    display:flex; align-items:center; justify-content:center; cursor:pointer; transition:all .3s ease;
  }
  .slider-nav button:hover{ background:var(--primary-color); color:#fff; border-color:var(--primary-color); }
  .companies-slider{ background:#fff; border-radius:15px; padding:20px; box-shadow:0 5px 20px rgba(0,0,0,.05); }
  .slide-item{ padding:0 15px; }
  .slide-img{
    height:100px; display:flex; align-items:center; justify-content:center; background:#fff;
    border-radius:10px; padding:15px; transition:all .3s ease; border:1px solid #f0f0f0;
  }
  .slide-img:hover{ transform:translateY(-5px); box-shadow:0 5px 15px rgba(0,0,0,.1); }
  .slide-img img{ max-height:70px; max-width:100%; object-fit:contain; }

  /* ===== أسهم ونقاط Slick العامة (مستخدمة للعروض/الشركاء) ===== */
  .slick-prev, .slick-next{
    background:rgba(255,255,255,0.8); width:45px; height:45px; border-radius:50%;
    z-index:1; transition:all .3s ease;
  }
  .slick-prev:hover, .slick-next:hover{ background:var(--primary-color); color:#fff; }
  .slick-prev{ right:20px; }
  .slick-next{ left:20px; }
  .slick-prev:before, .slick-next:before{
    font-family:'Font Awesome 6 Free'; font-weight:900; color:var(--primary-color);
  }
  .slick-prev:hover:before, .slick-next:hover:before{ color:#fff; }
  .slick-prev:before{ content:'\f054'; }
  .slick-next:before{ content:'\f053'; }
  .slick-dots{ bottom:20px; }
  .slick-dots li button:before{ color:#fff; opacity:.7; font-size:10px; }
  .slick-dots li.slick-active button:before{ color:var(--primary-color); opacity:1; }

  .more-container{ text-align:center; margin:40px 0; }
  .btn-more{
    background:var(--primary-color); color:#fff; padding:12px 30px; border-radius:30px; font-size:16px;
    font-weight:600; text-decoration:none; display:inline-flex; align-items:center; gap:8px; transition:all .3s ease;
    box-shadow:0 5px 15px rgba(109,36,144,.3);
  }
  .btn-more:hover{ background:#52187c; transform:translateY(-3px); box-shadow:0 8px 20px rgba(109,36,144,.4); }

  .company-name{
    color:var(--primary-color); font-size:18px; font-weight:bold; flex:1; line-height:1.4; word-break:break-word;
    background:rgba(255,255,255,.9); padding:8px 15px; border-radius:15px; box-shadow:0 2px 10px rgba(0,0,0,.1);
  }
  .company-meta{ display:flex; gap:10px; padding:0 20px; margin:15px 0 10px; flex-wrap:wrap; }
  .meta-item{
    display:flex; align-items:center; gap:6px; font-size:14px; padding:6px 12px; border-radius:20px; line-height:1.4;
  }
  .meta-item.category{ background:#f0f7ff; color:#1976d2; }
  .meta-item.location{ background:#fff0f0; color:#d32f2f; }
  .meta-item i{ font-size:13px; }

  /* ===== تحسينات للجوال ===== */
  @media (max-width: 768px){
    .companies-grid{ grid-template-columns:1fr; padding:0 15px; }
    .offer-card.offer-style2{ margin:10px 5px; }
    .offer-img2{ height:150px; }
    .section-title{ font-size:24px; margin:30px 0 20px; }
    .page-header h1{ font-size:28px; }
    .company-name{ font-size:16px; padding:6px 12px; }
    .meta-item{ font-size:13px; padding:5px 10px; }
  }

  /* =========================================================
     Elegant Slider (علوي وسفلي) - بديل لـ .main-slider/.bottom-slider
     ========================================================= */
/* ===== حاويتا السلايدر العلوي والسفلي ===== */
.elegant-slider,
.elegant-bottom-slider{
  position: relative;
  width: 100%;
  max-width: 1200px;
  margin: 30px auto;
  height: 300px;
  overflow: hidden;
  border-radius: 12px;
  box-shadow: 0 5px 15px rgba(0,0,0,.1);
  z-index: 1; /* فوق الفيديو */
  background: #f5f5f5;
}
@media (max-width: 768px){
  .elegant-slider, .elegant-bottom-slider{ height: 200px; }
}

/* ===== الشرائح (المهم هنا إصلاح النقر) ===== */
/* غير النشطة: لا تستقبل نقرات إطلاقًا */
.e-slide,
.eb-slide{
  position: absolute;
  inset: 0;
  opacity: 0;
  transition: opacity .6s ease;
  display: block;            /* يسمح بالنقر على كامل الشريحة */
  text-decoration: none;
  z-index: 0;                /* أسفل النشطة */
  pointer-events: none;      /* <<<< تمنع اختطاف النقر من السلايد المخفي */
}

/* الشريحة النشطة فقط هي القابلة للنقر */
.e-slide.active,
.eb-slide.active{
  opacity: 1;
  z-index: 1;
  pointer-events: auto;      /* <<<< السماح بالنقر */
}

/* صورة الشريحة */
.e-slide-img,
.eb-slide-img{
  width: 100%;
  height: 100%;
  object-fit: cover;
  display: block;
}

/* نقاط التصفح */
.e-slider-nav, .eb-slider-nav{
  position: absolute;
  left: 50%;
  bottom: 16px;
  transform: translateX(-50%);
  z-index: 3;
}
.e-slider-dots, .eb-slider-dots{ display: flex; gap: 10px; }
.e-slider-dot, .eb-slider-dot{
  width: 12px; height: 12px; border-radius: 50%;
  cursor: pointer; transition: transform .2s, background .2s;
}
.e-slider-dot{ background: rgba(255,255,255,.55); }
.e-slider-dot.active{ background: #fff; transform: scale(1.15); }
.eb-slider-dot{ background: rgba(0,0,0,.3); }
.eb-slider-dot.active{ background: var(--primary-color, #6d2490); transform: scale(1.15); }

/* شارات اختيارية */
.ad-badge{
  position: absolute; top: 20px; left: 20px;
  background: rgba(255, 51, 102, 0.9); color: #fff; padding: 8px 12px;
  border-radius: 20px; display: flex; align-items: center; font-weight: bold;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2); z-index: 2;
}
.ad-text{ font-size:14px; padding:0 8px; border-right:1px solid rgba(255,255,255,0.3); }
.ad-offer{ font-size:15px; padding:0 8px; }

/* شارة السفلي (إن وجدت) */
.eb-ad-badge{
  position: absolute; top: 20px; right: 20px;
  background: rgba(0,150,255,0.9); color: #fff; padding: 8px 15px;
  border-radius: 20px; display: flex; align-items: center; font-weight: bold;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2); z-index: 2;
}
.eb-ad-text{ font-size:14px; padding:0 8px; border-left:1px solid rgba(255,255,255,0.3); }
.eb-ad-desc{ font-size:15px; padding:0 8px; }

</style>

</head>
<body>
<!-- قسم البحث أعلى الفيديو -->
<div class="hero-search-section">
<!-- مسافة بين الفيديو والسلايدر العلوي -->
<div style="height: 40px;"></div>

<div class="video-wrapper" style="z-index: 0; position: absolute; top: 0; left: 0; width: 100%; height: 100%;">
  <video autoplay muted loop playsinline style="width: 100%; height: 100%; object-fit: cover; position: absolute; top: 0; left: 0;">
    <source src="bg.mp4" type="video/mp4">
    المتصفح لا يدعم تشغيل الفيديو.
  </video>
</div>
  <div class="search-overlay">
    <form method="GET" action="index.php" class="search-bar">
      <select name="category_id" class="search-select">
        <option value="">جميع التصنيفات</option>
        <?php foreach ($categories as $cat): ?>
          <option value="<?= $cat['id'] ?>" <?= (isset($_GET['category_id']) && $_GET['category_id'] == $cat['id']) ? 'selected' : '' ?>>
            <?= htmlspecialchars($cat['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>

      <select name="city_id" class="search-select">
        <option value="">جميع المدن</option>
        <?php foreach ($cities as $city): ?>
          <option value="<?= $city['id'] ?>" <?= (isset($_GET['city_id']) && $_GET['city_id'] == $city['id']) ? 'selected' : '' ?>>
            <?= htmlspecialchars($city['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>

      <button type="submit" class="search-button">
        <i class="fas fa-search"></i>
      </button>
    </form>
  </div>
</div>

<style>
.hero-search-section {
  position: relative;
  height: 450px;
  overflow: hidden;
}

.video-wrapper {
  position: absolute;
  top: 0; left: 0; right: 0; bottom: 0;
  z-index: 0; /* ✅ جعل الفيديو في الخلف */
}

.video-wrapper video {
  width: 100%;
  height: 100%;
  object-fit: cover;
  position: absolute;
  top: 0;
  left: 0;
  z-index: 0; /* ✅ الفيديو خلف كل شيء */
  pointer-events: none; /* ✅ مهم: يمنع اعتراض النقر */
}

.search-overlay {
  position: relative;
  z-index: 2;
  padding: 30px 20px 0;
  display: flex;
  justify-content: center;
}

.search-bar {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 10px;
  background-color: transparent;
  padding: 10px 15px;
  border-radius: 8px;
  box-shadow: none;
  max-width: 95%;
}

.search-select {
  padding: 10px 15px;
  font-size: 16px;
  border: 1px solid #ddd;
  border-radius: 6px;
  min-width: 130px;
  flex: 1 1 auto;
}

.search-button {
  background-color: #7b1fa2;
  color: white;
  border: none;
  border-radius: 6px;
  padding: 10px 20px;
  cursor: pointer;
  flex: 0 0 auto;
}

/* ✅ الجوال */
@media (max-width: 768px) {
  .search-bar {
    flex-wrap: nowrap;
    flex-direction: row;
    overflow-x: auto;
  }

  .search-select, .search-button {
    flex: 1 1 auto;
    white-space: nowrap;
  }
}

/* ✅ عناصر البطاقات وأزرارها فوق الفيديو */
.company-card2,
.offer-card {
  position: relative;
  z-index: 2;
}

.actions,
.offer-actions {
  position: relative;
  z-index: 3;
}
.actions {
  display: flex;
  flex-wrap: wrap;
  gap: 10px;
  padding: 15px 20px;
  justify-content: center;
}

.actions a {
  flex: 1 1 45%;
  text-align: center;
  font-size: 14px;
  padding: 10px;
  border-radius: 8px;
  text-decoration: none;
  color: #fff;
}

.btn-contact {
  background-color: #28a745;
}

.btn-details {
  background-color: #6f42c1;
}

@media (max-width: 768px) {
  .actions a {
    flex: 1 1 100%;
  }
.offer-actions {
  display: flex;
  justify-content: center;
  gap: 10px;
  margin-top: 12px;
}

.btn-icon {
  width: 36px;
  height: 36px;
  border-radius: 8px;
  display: flex;
  align-items: center;
  justify-content: center;
  text-decoration: none;
  color: #fff;
  font-size: 16px;
  transition: 0.2s;
}

/* زر صفحة الشركة */
.btn-icon.page {
  background-color: #ffc107;
}
.btn-icon.page:hover {
  background-color: #e0a800;
}

/* زر الواتساب */
.btn-icon.whatsapp {
  background-color: #25d366;
}
.btn-icon.whatsapp:hover {
  background-color: #1da851;
}

/* زر الاتصال */
.btn-icon.phone {
  background-color: #4caf50;
}
.btn-icon.phone:hover {
  background-color: #3e8e41;
}
}
</style>


<!-- عرض نتائج البحث -->
<?php if (!empty($results)): ?>
<div class="search-results">
  <div class="page-header">
    <h1><i class="fas fa-search"></i> نتائج البحث</h1>
    <p>تم العثور على <?= count($results) ?> نتيجة</p>
  </div>

  <div class="companies-grid">
    <?php foreach ($results as $company): ?>
      <div class="company-card2">
        <!-- صورة الغلاف مع شارة نشط -->
        <div class="cover-image" style="background-image: url('<?= !empty($company['cover']) ? htmlspecialchars($company['cover']) : 'images/cover-default.png' ?>');">
          <div class="status-badge">نشط</div>
        </div>
        
        <!-- هيدر: شعار + اسم الشركة -->
        <div class="company-header">
          <div class="logo-wrap">
            <img src="<?= !empty($company['logo']) ? htmlspecialchars($company['logo']) : 'images/company-default.png' ?>" alt="شعار الشركة">
          </div>
          <div class="company-name"><?= htmlspecialchars($company['name']) ?></div>
        </div>
        
        <!-- معلومات التصنيف والمدينة -->
        <div class="company-meta">
          <div class="meta-item category">
            <i class="fas fa-tag"></i>
            <span><?= htmlspecialchars($company['category_name'] ?? 'غير معروف') ?></span>
          </div>
          <div class="meta-item location">
            <i class="fas fa-map-marker-alt"></i>
            <span><?= htmlspecialchars($company['city_name'] ?? 'غير معروف') ?></span>
          </div>
        </div>

        <?php
          $about = $company['about'] ?? '';
          $desc = mb_substr($about, 0, 100) . (mb_strlen($about) > 100 ? '...' : '');
        ?>
        <p class="description"><?= htmlspecialchars($desc ?: 'لا يوجد وصف متوفر') ?></p>

        <div class="actions">
          <a href="company.php?id=<?= $company['id'] ?>" class="btn-details"><i class="fas fa-eye"></i> التفاصيل</a>
          <?php if (!empty($company['phone'])): ?>
            <a href="tel:<?= htmlspecialchars($company['phone']) ?>" class="btn-contact"><i class="fas fa-phone-alt"></i> اتصل</a>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<?php elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['q'])): ?>
  <div class="page-header">
    <h1><i class="fas fa-search"></i> نتائج البحث</h1>
    <p style="color:#666;">لا توجد نتائج مطابقة للبحث</p>
  </div>
<?php endif; ?>

<!-- السلايدر العلوي -->
<div class="elegant-slider" id="topSlider">
  <?php foreach ($sliders_top as $s):
    $img = $s['image'] ?? '';
    if ($img && strpos($img, 'uploads/sliders/') !== 0) $img = 'uploads/sliders/' . $img;
    $url   = trim($s['link'] ?? '');
    $title = htmlspecialchars($s['title'] ?? '');
    $is_ext = preg_match('~^https?://~i', $url);
  ?>
    <?php if ($url): ?>
      <a class="e-slide" href="<?= htmlspecialchars($url) ?>" <?= $is_ext ? 'target="_blank" rel="noopener"' : '' ?>>
        <img class="e-slide-img" src="<?= htmlspecialchars($img) ?>" alt="<?= $title ?>">
      </a>
    <?php else: ?>
      <div class="e-slide">
        <img class="e-slide-img" src="<?= htmlspecialchars($img) ?>" alt="<?= $title ?>">
      </div>
    <?php endif; ?>
  <?php endforeach; ?>
  <div class="e-slider-nav"><div class="e-slider-dots"></div></div>
</div>

<!-- عنوان الصفحة -->
<div class="page-header">
    <h1><i class="fas fa-star"></i> شركات مميزة</h1>
    <p>أفضل الشركات المسجلة في دليلنا حسب التقييمات والخدمات</p>
</div>

<!-- بطاقات الشركات -->
<?php if (!isset($featured_companies) || empty($featured_companies)): ?>
    <div style="text-align:center;color:#aaa;padding:30px 0;">لا يوجد شركات مميزة حتى الآن.</div>
<?php else: ?>
    <div class="companies-grid">
        <?php foreach ($featured_companies as $company): ?>
            <div class="company-card2">
                <!-- صورة الغلاف مع شارة نشط -->
                <div class="cover-image" style="background-image: url('<?= !empty($company['cover']) ? htmlspecialchars($company['cover']) : 'images/cover-default.png' ?>');">
                    <div class="status-badge">نشط</div>
                </div>
                
                <!-- هيدر: شعار + اسم الشركة -->
                <div class="company-header">
                    <div class="logo-wrap">
                        <img src="<?= !empty($company['logo']) ? htmlspecialchars($company['logo']) : 'images/company-default.png' ?>" alt="شعار الشركة">
                    </div>
                    <div class="company-name"><?= htmlspecialchars($company['name']) ?></div>
                </div>
                
                <!-- معلومات التصنيف والمدينة -->
                <div class="company-meta">
                    <div class="meta-item category">
                        <i class="fas fa-tag"></i>
                        <span><?= htmlspecialchars($company['category_name']) ?></span>
                    </div>
                    <div class="meta-item location">
                        <i class="fas fa-map-marker-alt"></i>
                        <span><?= htmlspecialchars($company['city_name']) ?></span>
                    </div>
                </div>
                
                <?php
                    $about = $company['about'] ?? '';
                    $desc = mb_substr($about, 0, 100) . (mb_strlen($about) > 100 ? '...' : '');
                ?>
                <p class="description"><?= htmlspecialchars($desc) ?></p>
                
                <div class="actions">
  <a href="company.php?id=<?= $company['id'] ?>" class="btn-details"><i class="fas fa-eye"></i> التفاصيل</a>
  
  <?php if (isset($company['phone']) && trim($company['phone']) !== ''): ?>
    <a href="tel:<?= htmlspecialchars($company['phone']) ?>" class="btn-contact"><i class="fas fa-phone-alt"></i> اتصل</a>
  <?php endif; ?>
</div>

            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<!-- زر المزيد -->
<div class="more-container">
    <a href="companies.php" class="btn-more">عرض المزيد من الشركات <i class="fas fa-arrow-left"></i></a>
</div>

<!-- أحدث العروض -->
<div class="section-title">
    <i class="fas fa-handshake"></i>
    <span>أحدث العروض</span>
</div>

<!-- سلايدر العروض -->
<?php if (!empty($offers)): ?>
  <div class="offers-slider">
    <?php foreach ($offers as $offer): ?>
      <div class="offer-card offer-style2">
        <div class="offer-img2">
          <img src="<?= htmlspecialchars($offer['image'] ?? 'assets/images/offer-default.png') ?>" alt="صورة العرض">
        </div>
        <div class="offer-body">
          <div class="offer-title"><?= htmlspecialchars($offer['title'] ?? '') ?></div>
          <div class="offer-desc"><?= htmlspecialchars(mb_substr($offer['description'] ?? '', 0, 60, 'utf-8')) ?>...</div>
          <div class="offer-prices">
            <?php if(!empty($offer['old_price'])): ?>
              <span class="old-price"><?= number_format($offer['old_price']) ?> ريال</span>
            <?php endif; ?>
            <span class="new-price"><?= number_format($offer['new_price'] ?? 0) ?> ريال</span>
          </div>
          <div class="offer-expire">
            <i class="fas fa-calendar-alt"></i>
            <?= htmlspecialchars($offer['end_date'] ?? $offer['expire_date'] ?? 'غير محدد') ?>
          </div>
          <div class="offer-actions">
            <?php if(isset($offer['company_id'])): ?>
              <a href="company.php?id=<?= intval($offer['company_id']) ?>" 
                 class="btn-icon page" 
                 style="background: #FFC107;">
                <i class="fas fa-home"></i>
              </a>
            <?php endif; ?>
            
            <?php if(!empty($offer['whatsapp'])): ?>
              <?php 
                $whatsapp_num = preg_replace('/[^0-9]/', '', $offer['whatsapp']);
                if (strpos($whatsapp_num, '0') === 0) {
                  $whatsapp_num = '966' . substr($whatsapp_num, 1);
                }
              ?>
              <a href="https://wa.me/<?= $whatsapp_num ?>" 
                 target="_blank" 
                 class="btn-icon whatsapp" 
                 style="background: #25d366;">
                <i class="fab fa-whatsapp"></i>
              </a>
            <?php endif; ?>
            
            <?php if(!empty($offer['phone'])): ?>
              <a href="tel:<?= htmlspecialchars(preg_replace('/[^0-9]/', '', $offer['phone'])) ?>" 
                 class="btn-icon phone" 
                 style="background: #4CAF50;">
                <i class="fas fa-phone-alt"></i>
              </a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php else: ?>
  <div style="text-align:center; padding:20px; color:#666;">
    لا توجد عروض متاحة حالياً
  </div>
<?php endif; ?>
<!-- السلايدر السفلي -->
<div class="elegant-slider" id="bottomSlider">
  <?php foreach ($sliders_bottom as $s):
    $img = $s['image'] ?? '';
    if ($img && strpos($img, 'uploads/sliders/') !== 0) $img = 'uploads/sliders/' . $img;
    $url   = trim($s['link'] ?? '');
    $title = htmlspecialchars($s['title'] ?? '');
    $is_ext = preg_match('~^https?://~i', $url);
  ?>
    <?php if ($url): ?>
      <a class="e-slide" href="<?= htmlspecialchars($url) ?>" <?= $is_ext ? 'target="_blank" rel="noopener"' : '' ?>>
        <img class="e-slide-img" src="<?= htmlspecialchars($img) ?>" alt="<?= $title ?>">
      </a>
    <?php else: ?>
      <div class="e-slide">
        <img class="e-slide-img" src="<?= htmlspecialchars($img) ?>" alt="<?= $title ?>">
      </div>
    <?php endif; ?>
  <?php endforeach; ?>
  <div class="e-slider-nav"><div class="e-slider-dots"></div></div>
</div>

<!-- سلايدر الشركاء -->
<div class="featured-slider">
    <div class="slider-header">
        <h2><i class="fas fa-handshake"></i> شركاء النجاح</h2>
        <div class="slider-nav">
            <button class="slider-prev"><i class="fas fa-chevron-right"></i></button>
            <button class="slider-next"><i class="fas fa-chevron-left"></i></button>
        </div>
    </div>
    <div class="companies-slider">
        <?php if ($partners && count($partners)): ?>
            <?php foreach ($partners as $partner): ?>
                <?php
                    $logo = $partner['logo'] ?? '';
                    if ($logo && strpos($logo, 'uploads/partners/') !== 0) {
                        $logo = 'uploads/partners/' . $logo;
                    }
                ?>
                <div class="slide-item">
                    <a href="<?= htmlspecialchars($partner['link'] ?: "#") ?>" target="_blank">
                        <div class="slide-img">
                            <?php if (!empty($logo)): ?>
                                <img src="<?= htmlspecialchars($logo) ?>" alt="شعار <?= htmlspecialchars($partner['name']) ?>">
                            <?php else: ?>
                                <span style="color:#bbb;font-size:13px;">لا يوجد شعار</span>
                            <?php endif; ?>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div style="color:#aaa;padding:24px;text-align:center;">لا يوجد شعارات شركاء حاليا.</div>
        <?php endif; ?>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
<script>
// ===============================
// jQuery: سلايدر العروض + سلايدر الشركاء
// ===============================
$(document).ready(function(){
  // سلايدر العروض
  $('.offers-slider').slick({
    rtl: true,
    dots: true,
    arrows: true,
    infinite: true,
    speed: 300,
    slidesToShow: 3,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 4000,
    prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-chevron-right"></i></button>',
    nextArrow: '<button type="button" class="slick-next"><i class="fas fa-chevron-left"></i></button>',
    responsive: [
      { breakpoint: 992, settings: { slidesToShow: 2 } },
      { breakpoint: 768, settings: { slidesToShow: 1, arrows: false } }
    ]
  });

  // سلايدر الشركاء
  $('.companies-slider').slick({
    rtl: true,
    dots: false,
    arrows: false,
    infinite: true,
    speed: 300,
    slidesToShow: 5,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 3000,
    responsive: [
      { breakpoint: 1200, settings: { slidesToShow: 4 } },
      { breakpoint: 992,  settings: { slidesToShow: 3 } },
      { breakpoint: 768,  settings: { slidesToShow: 2 } },
      { breakpoint: 480,  settings: { slidesToShow: 1 } }
    ]
  });

  // أزرار تنقل الشركاء
  $('.slider-prev').on('click', function(){ $('.companies-slider').slick('slickPrev'); });
  $('.slider-next').on('click', function(){ $('.companies-slider').slick('slickNext'); });
});

// ===================================================================
// Vanilla JS: سلايدر علوي/سفلي "تلاشي" يعمل مع الروابط داخل كل شريحة
// يدعم:
//   - العلوي:   .elegant-slider  مع الشرائح .e-slide  والنقاط .e-slider-dots
//   - السفلي:   .elegant-bottom-slider مع الشرائح .eb-slide والنقاط .eb-slider-dots
// ملاحظة: لا يوجد أي <a> "غطاء" فوق السلايدر؛ كل شريحة تفتح رابطها فقط.
// ===================================================================
(function(){
  function initFadeSlider(rootSelector, slideSelector, dotsSelector, intervalMs){
    var roots = document.querySelectorAll(rootSelector);
    if (!roots.length) return;

    roots.forEach(function(root){
      var slides = root.querySelectorAll(slideSelector);
      if (!slides.length) return;

      // فعّل أول شريحة
      slides.forEach(function(sl){ sl.classList.remove('active'); });
      slides[0].classList.add('active');

      // أنشئ النقاط إن وُجد الوعاء
      var dotsWrap = root.querySelector(dotsSelector);
      if (dotsWrap){
        dotsWrap.innerHTML = '';
        slides.forEach(function(_, i){
          var dot = document.createElement('div');
          dot.className = 'e-slider-dot' + (i === 0 ? ' active' : '');
          dot.addEventListener('click', function(){ goTo(i); });
          dotsWrap.appendChild(dot);
        });
      }

      var idx = 0;
      var timer = null;

      function goTo(i){
        slides[idx].classList.remove('active');
        if (dotsWrap && dotsWrap.children[idx]) dotsWrap.children[idx].classList.remove('active');

        idx = i;

        slides[idx].classList.add('active');
        if (dotsWrap && dotsWrap.children[idx]) dotsWrap.children[idx].classList.add('active');

        restart();
      }

      function next(){ goTo((idx + 1) % slides.length); }

      function restart(){
        if (timer) clearInterval(timer);
        if (slides.length > 1) timer = setInterval(next, intervalMs || 5000);
      }

      // تشغيل تلقائي + إيقاف عند التفاعل
      restart();
      root.addEventListener('mouseenter', function(){ if (timer) clearInterval(timer); });
      root.addEventListener('mouseleave', restart);
    });
  }

  // شغّل السلايدر العلوي والسفلي بعد جاهزية الـ DOM
  document.addEventListener('DOMContentLoaded', function(){
    // العلوي: عناصره داخل .elegant-slider كـ .e-slide وروابطها مباشرة
    initFadeSlider('.elegant-slider', '.e-slide', '.e-slider-dots', 5000);

    // السفلي: عناصره داخل .elegant-bottom-slider كـ .eb-slide
    initFadeSlider('.elegant-bottom-slider', '.eb-slide', '.eb-slider-dots', 5000);
  });
})();
</script>

<?php include "includes/footer.php"; ?>