<?php
// ملف seo.php - إعداد بيانات الـ Meta تلقائياً
require_once __DIR__ . '/../config/db.php';

// تحديد اسم الصفحة الحالية بدون المسار
$current_page = basename($_SERVER['PHP_SELF']);

// استعلام لجلب بيانات SEO للصفحة الحالية
$stmt = $pdo->prepare("SELECT * FROM seo_pages WHERE page = ? LIMIT 1");
$stmt->execute([$current_page]);
$seo = $stmt->fetch(PDO::FETCH_ASSOC);

// القيم الافتراضية في حال عدم توفر بيانات
$default_title = "دليلك التجاري في السعودية";
$default_description = "استعرض الشركات والعروض والخدمات المحلية في مكان واحد.";
$default_image = "https://yourdomain.com/assets/logo.png"; // ضع رابط فعلي
$default_url = "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

$title = $seo && !empty($seo['title']) ? $seo['title'] : $default_title;
$description = $seo && !empty($seo['description']) ? $seo['description'] : $default_description;
$image = $seo && !empty($seo['image']) ? $seo['image'] : $default_image;
$url = $seo && !empty($seo['url']) ? $seo['url'] : $default_url;
?>
