<?php
if (session_status() === PHP_SESSION_NONE) session_start();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />

  <?php include "includes/seo.php"; ?>
  <title><?= htmlspecialchars($title) ?></title>
  <meta name="description" content="<?= htmlspecialchars($description) ?>">
  <meta property="og:title" content="<?= htmlspecialchars($title) ?>">
  <meta property="og:description" content="<?= htmlspecialchars($description) ?>">
  <meta property="og:image" content="<?= htmlspecialchars($image) ?>">
  <meta property="og:url" content="<?= htmlspecialchars($url) ?>">
  <meta name="twitter:card" content="summary_large_image">

  <!-- الخط والايقونات -->
  <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>

  <style>
    :root {
      --primary-color: #6d2490;
      --secondary-color: #ffc107;
    }

    body {
      font-family: 'Cairo', sans-serif;
      margin: 0;
      padding: 0;
      background-color: #f8f9fa;
    }

    header {
      background-color: var(--primary-color);
      color: white;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
      position: relative;
    }

    .container {
      max-width: 1200px;
      margin: auto;
      padding: 10px 15px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      flex-wrap: wrap;
      gap: 10px;
    }

    .logo {
      display: flex;
      align-items: center;
      gap: 10px;
      min-width: 190px;
    }
    .logo img { height: 35px; }
    .logo span { font-size: 18px; font-weight: bold; color: white; }

    .main-nav { display: flex; flex-grow: 1; justify-content: center; }
    .main-nav ul {
      list-style: none; display: flex; gap: 20px; margin: 0; padding: 0; flex-wrap: wrap;
    }
    .main-nav a {
      color: white; text-decoration: none; font-size: 15px;
      display: flex; align-items: center; gap: 5px;
    }
    .main-nav a:hover { color: var(--secondary-color); }

    .user-actions { display: flex; gap: 12px; align-items: center; }
    .user-actions a { color: white; font-size: 18px; text-decoration: none; }
    .user-actions a:hover { color: var(--secondary-color); }

    .mobile-menu-btn {
      display: none; background: none; border: none;
      color: white; font-size: 22px; cursor: pointer;
    }

    @media (max-width: 768px) {
      .container { gap: 8px; }
      .main-nav { order: 3; flex-basis: 100%; }
      .main-nav ul {
        display: none; flex-direction: column; background: var(--primary-color);
        position: absolute; top: 100%; left: 0; right: 0; z-index: 999; padding: 15px;
      }
      .main-nav ul.show { display: flex; }
      .mobile-menu-btn { display: block; }
    }

    /* لوحة البحث (بحث في الموقع فقط) */
    .search-panel{
      position:fixed; inset:0; background:rgba(0,0,0,.45);
      display:none; align-items:flex-start; justify-content:center; z-index:1100;
    }
    .search-panel.show{ display:flex; }
    .search-card{
      width:min(900px,95vw); margin:70px 0 0; background:#fff; border-radius:14px; box-shadow:0 10px 30px rgba(0,0,0,.15);
      overflow:hidden; direction:rtl;
    }
    .search-head{ display:flex; align-items:center; justify-content:space-between; padding:10px 12px; background:#6d2490; color:#fff; }
    .search-title{ display:flex; align-items:center; gap:10px; font-weight:700; }
    .search-title i{ font-size:18px; }
    .close-btn{ background:transparent; border:none; color:#fff; font-size:20px; cursor:pointer; }

    .panel-body{ padding:14px; }
    .field-row{ display:flex; gap:8px; align-items:center; margin-bottom:10px; }
    .field-row input{
      flex:1; padding:12px 14px; border:1px solid #e6e6e6; border-radius:10px; font-family:'Cairo',sans-serif; font-size:15px;
    }

    .results{ max-height:60vh; overflow:auto; border:1px solid #eee; border-radius:10px; padding:8px; background:#fafafa; }
    .result-item{
      display:block; text-decoration:none; padding:10px; border-radius:10px; background:#fff; border:1px solid #eee; margin-bottom:8px;
    }
    .result-item:hover{ background:#f5f5ff; border-color:#d9d6ff; }
    .result-title{ font-weight:700; color:#222; margin-bottom:4px; }
    .result-meta{ font-size:13px; color:#666; display:flex; gap:8px; flex-wrap:wrap; }
    .badge{ display:inline-block; padding:2px 8px; border-radius:999px; font-size:12px; background:#eee; color:#333; }
    .badge.company{ background:#e8f5e9; }
    .badge.offer{ background:#fff3e0; }
    .badge.post{ background:#e3f2fd; }
  </style>
</head>
<body>

<header>
  <div class="container">
    <!-- الشعار -->
    <div class="logo">
      <img src="/dalelapp/assets/images/logo.png" alt="شعار">
      <span>دليل الصفحات التجارية</span>
    </div>

    <!-- زر القائمة للجوال -->
    <button class="mobile-menu-btn" id="mobileMenuBtn" aria-label="القائمة">
      <i class="fas fa-bars"></i>
    </button>

    <!-- القائمة الرئيسية -->
    <nav class="main-nav">
      <ul id="mainNavList">
        <li><a href="/dalelapp/index.php"><i class="fas fa-home"></i> الرئيسية</a></li>
        <li><a href="/dalelapp/companies.php"><i class="fas fa-building"></i> الشركات</a></li>
        <li><a href="/dalelapp/offer.php?offers=1"><i class="fas fa-tags"></i> العروض</a></li>
        <li><a href="/dalelapp/blog.php"><i class="fas fa-newspaper"></i> المدونة</a></li>
        <li><a href="/dalelapp/contact.php"><i class="fas fa-envelope"></i> اتصل بنا</a></li>
      </ul>
    </nav>

    <!-- أدوات المستخدم + زر البحث -->
    <div class="user-actions">
      <!-- زر البحث -->
      <a href="javascript:void(0)" id="openSearch" title="بحث"><i class="fas fa-search"></i></a>

      <?php if (isset($_SESSION['user_id'])): ?>
        <a href="/dalelapp/dashboard/index.php" title="لوحة التحكم"><i class="fas fa-cog"></i></a>
        <a href="/dalelapp/logout.php" title="تسجيل الخروج"><i class="fas fa-sign-out-alt" style="color:#ff4d4d;"></i></a>
      <?php else: ?>
        <a href="/dalelapp/login.php" title="تسجيل الدخول"><i class="fas fa-user"></i></a>
        <a href="/dalelapp/register.php" title="أضف شركتك"><i class="fas fa-plus-circle"></i></a>
      <?php endif; ?>
    </div>
  </div>
</header>

<!-- لوحة البحث (بحث في الموقع فقط) -->
<div id="searchPanel" class="search-panel" aria-hidden="true">
  <div class="search-card">
    <div class="search-head">
      <div class="search-title">
        <i class="fas fa-search"></i>
        <span>بحث في الموقع</span>
      </div>
      <button class="close-btn" id="closeSearch" aria-label="إغلاق"><i class="fas fa-times"></i></button>
    </div>

    <div class="panel-body">
      <div class="field-row">
        <input type="text" id="globalQuery" placeholder="ابحث في الشركات والعروض والمدونة..." autocomplete="off">
      </div>
      <div class="results" id="globalResults">
        <div class="hint">اكتب كلمة البحث لعرض النتائج…</div>
      </div>
    </div>
  </div>
</div>

<!-- سكربتات -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
<script>
  // زر القائمة للجوال
  const btn = document.getElementById('mobileMenuBtn');
  const menuList = document.getElementById('mainNavList');
  btn && (btn.onclick = () => {
    menuList.classList.toggle('show');
    const icon = btn.querySelector('i');
    icon.classList.toggle('fa-bars');
    icon.classList.toggle('fa-times');
  });

  // ===== لوحة البحث =====
  const openSearch = document.getElementById('openSearch');
  const closeSearch = document.getElementById('closeSearch');
  const searchPanel = document.getElementById('searchPanel');

  function showPanel(){ searchPanel.classList.add('show'); document.getElementById('globalQuery').focus(); }
  function hidePanel(){ searchPanel.classList.remove('show'); }
  openSearch.addEventListener('click', showPanel);
  closeSearch.addEventListener('click', hidePanel);
  searchPanel.addEventListener('click', (e)=>{ if(e.target===searchPanel) hidePanel(); });

  // اختصار Ctrl/⌘ + K لفتح البحث
  window.addEventListener('keydown', (e)=>{
    if((e.ctrlKey || e.metaKey) && e.key.toLowerCase()==='k'){
      e.preventDefault(); showPanel();
    }
  });

  // ===== بحث في الموقع (AJAX) =====
  const gInput = document.getElementById('globalQuery');
  const gResults = document.getElementById('globalResults');
  let timer;
  gInput.addEventListener('input', ()=>{
    const q = gInput.value.trim();
    clearTimeout(timer);
    if(!q){ gResults.innerHTML='<div class="hint">اكتب كلمة البحث لعرض النتائج…</div>'; return; }
    timer=setTimeout(()=>doGlobal(q), 300);
  });

  function doGlobal(q){
    gResults.innerHTML='<div class="hint">جارِ البحث…</div>';
    fetch('/dalelapp/search.php?q='+encodeURIComponent(q))
      .then(r=>r.json())
      .then(data=>{
        if(!Array.isArray(data) || !data.length){
          gResults.innerHTML='<div class="hint">لا توجد نتائج.</div>'; return;
        }
        gResults.innerHTML = data.map(item=>renderResult(item)).join('');
      })
      .catch(()=> gResults.innerHTML='<div class="hint">حدث خطأ أثناء البحث.</div>');
  }

  function renderResult(item){
    const badgeClass = item.type==='company'?'company': item.type==='offer'?'offer':'post';
    return `
      <a class="result-item" href="${item.url}">
        <div class="result-title">${escapeHtml(item.title||'بدون عنوان')}</div>
        <div class="result-meta">
          <span class="badge ${badgeClass}">${item.type_ar}</span>
          ${item.snippet? `<span>${escapeHtml(item.snippet)}</span>`:''}
        </div>
      </a>
    `;
  }
  function escapeHtml(s){ return (s||'').replace(/[&<>"']/g, m=>({ '&':'&amp;', '<':'&lt;', '>':'&gt;', '"':'&quot;', "'":'&#39;' }[m])); }
</script>
</body>
</html>
