<?php
require_once '../config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

// جلب بيانات الشركة المرتبطة بالمستخدم
$stmt = $pdo->prepare("SELECT * FROM companies WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$company = $stmt->fetch();

if (!$company) {
    die("<div style='color:#e74c3c;font-size:20px;text-align:center;margin:40px 0;'>لم يتم العثور على بيانات الشركة</div>");
}

// عند تعديل البيانات
$success = '';
$errors = [];
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name       = trim($_POST['name']);
    $category   = intval($_POST['category_id']);
    $city       = intval($_POST['city_id']);
    $about      = trim($_POST['about']);
    $phone      = trim($_POST['phone']);
    $whatsapp   = trim($_POST['whatsapp']);
    $email      = trim($_POST['email']);
    $website    = trim($_POST['website']);
    $map_link   = trim($_POST['map_link']);

    // رفع الشعار إذا تم رفعه
    $logo = $company['logo'];
    if (!empty($_FILES['logo']['name'])) {
        if ($_FILES['logo']['size'] > 500 * 1024) {
            $errors[] = "حجم شعار الشركة يجب ألا يتجاوز 500 كيلوبايت.";
        } else {
            $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
            $logo_name = 'logo_' . $company['id'] . '_' . time() . '.' . $ext;
            $logo_path = '../uploads/companies/' . $logo_name;
            if (move_uploaded_file($_FILES['logo']['tmp_name'], $logo_path)) {
                $logo = 'uploads/companies/' . $logo_name;
            }
        }
    }

    // رفع صورة الغلاف إذا تم رفعها
    $cover = $company['cover'] ?? '';
    if (!empty($_FILES['cover']['name'])) {
        if ($_FILES['cover']['size'] > 1200 * 1024) {
            $errors[] = "حجم صورة الغلاف يجب ألا يتجاوز 1.2 ميغابايت.";
        } else {
            $ext = pathinfo($_FILES['cover']['name'], PATHINFO_EXTENSION);
            $cover_name = 'cover_' . $company['id'] . '_' . time() . '.' . $ext;
            $cover_path = '../uploads/companies/' . $cover_name;
            if (move_uploaded_file($_FILES['cover']['tmp_name'], $cover_path)) {
                $cover = 'uploads/companies/' . $cover_name;
            }
        }
    }

    // رفع الصور الإضافية إذا تم رفعها
    $images = [];
    if (!empty($_FILES['images']['name'][0])) {
        foreach ($_FILES['images']['tmp_name'] as $k => $tmp_name) {
            if ($_FILES['images']['error'][$k] === 0) {
                if ($_FILES['images']['size'][$k] > 500 * 1024) {
                    $errors[] = "حجم الصورة رقم ".($k+1)." يجب ألا يتجاوز 500 كيلوبايت.";
                    continue;
                }
                $ext = pathinfo($_FILES['images']['name'][$k], PATHINFO_EXTENSION);
                $img_name = 'img_' . $company['id'] . '_' . time() . '_' . $k . '.' . $ext;
                $img_path = '../uploads/companies/' . $img_name;
                if (move_uploaded_file($tmp_name, $img_path)) {
                    $images[] = 'uploads/companies/' . $img_name;
                }
            }
        }
    } else {
        // لو لم يتم رفع صور جديدة استعمل الصور القديمة
        $images = json_decode($company['images'] ?? '[]', true);
    }

    // تحقق من الحقول المطلوبة
    if (!$name || !$category || !$city || !$phone || !$email) {
        $errors[] = "جميع الحقول الأساسية مطلوبة.";
    }

    if (empty($errors)) {
        $stmt = $pdo->prepare("UPDATE companies SET 
            name = ?, category_id = ?, city_id = ?, about = ?, phone = ?, whatsapp = ?, email = ?, website = ?, map_link = ?, logo = ?, cover = ?, images = ? 
            WHERE id = ?");
        $stmt->execute([
            $name, $category, $city, $about, $phone, $whatsapp, $email, $website, $map_link, $logo, $cover, json_encode($images, JSON_UNESCAPED_UNICODE), $company['id']
        ]);
        $success = "تم تحديث بيانات الشركة بنجاح.";
        // جلب البيانات من جديد بعد التحديث
        $stmt = $pdo->prepare("SELECT * FROM companies WHERE user_id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $company = $stmt->fetch();
    }
}

// جلب التصنيفات والمدن
$categories = $pdo->query("SELECT * FROM categories")->fetchAll();
$cities = $pdo->query("SELECT * FROM cities")->fetchAll();

// صور الشركة القديمة (لعرض المعاينة)
$old_images = json_decode($company['images'] ?? '[]', true);
?>
<style>
/* تنسيقات النموذج */
.register-form {
  max-width: 700px;
  margin: 40px auto;
  background: #fff;
  padding: 40px 30px;
  border-radius: 15px;
  box-shadow: 0 4px 32px #c2c2c229;
}

.register-form h2 {
  margin-bottom: 24px;
  text-align: center;
  font-size: 22px;
  color: #6d2490;
}

.form-group {
  margin-bottom: 16px;
}

.form-group label {
  display: block;
  margin-bottom: 6px;
  font-weight: bold;
  color: #333;
}

.form-group input[type="text"],
.form-group input[type="email"],
.form-group input[type="file"],
.form-group textarea,
.form-group select {
  width: 100%;
  padding: 10px 12px;
  font-family: 'Cairo', sans-serif;
  font-size: 15px;
  border: 1px solid #ccc;
  border-radius: 8px;
  box-sizing: border-box;
  background-color: #fff;
}

.form-group textarea {
  resize: vertical;
}

.main-btn {
  background-color: #6d2490;
  color: white;
  padding: 12px;
  font-size: 16px;
  border: none;
  border-radius: 10px;
  cursor: pointer;
  transition: background-color 0.3s ease;
}

.main-btn:hover {
  background-color: #5a1e79;
}

.alert {
  font-size: 15px;
  line-height: 1.6;
}

/* صور الشعار والمعاينة */
.form-group img {
  display: block;
  max-width: 100%;
  height: auto;
}

/* معاينة الصور الصغيرة */
.preview-images {
  display: flex;
  flex-wrap: wrap;
  gap: 6px;
  margin-bottom: 8px;
}

.preview-images img {
  height: 46px;
  border-radius: 6px;
}

/* تحسينات الجوال */
@media (max-width: 600px) {
  .register-form {
    padding: 24px 15px;
    margin: 20px 10px;
  }

  .form-group {
    margin-bottom: 14px;
  }

  .form-group label {
    font-size: 14px;
  }

  .form-group input,
  .form-group textarea,
  .form-group select {
    font-size: 14px;
    padding: 8px 10px;
  }

  .main-btn {
    font-size: 15px;
    padding: 10px;
  }
}
</style>

<?php include "../includes/header.php"; ?>

<div class="register-form" style="max-width:650px;margin:40px auto 80px auto;background:#fff;padding:38px 24px 28px 24px;border-radius:15px;box-shadow:0 4px 32px #c2c2c229;">
    <h2 style="margin-bottom:24px;text-align:center;">تعديل بيانات الشركة</h2>
    <?php if ($errors): ?>
        <div class="alert alert-danger" style="color:#fff;background:#e74c3c;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?php foreach ($errors as $e) echo "<div>$e</div>"; ?>
        </div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success" style="color:#fff;background:#27ae60;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?= $success ?>
        </div>
    <?php endif; ?>
    <form method="post" enctype="multipart/form-data" autocomplete="off">
        <div class="form-group">
            <label>اسم الشركة *</label>
            <input type="text" name="name" value="<?= htmlspecialchars($company['name'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label>شعار الشركة (PNG/JPG) *</label>
            <?php if(!empty($company['logo'])): ?>
                <div style="margin-bottom:6px;display:flex;align-items:center;gap:8px;">
                    <img src="../<?= $company['logo'] ?>" alt="شعار الشركة" style="height:44px;width:44px;border-radius:8px;border:1px solid #eee;">
                    <span style="font-weight:bold;"><?= htmlspecialchars($company['name']) ?></span>
                </div>
            <?php endif; ?>
            <input type="file" name="logo" accept="image/*">
        </div>
        <div class="form-group">
            <label>صورة الغلاف (يفضل أبعاد أفقية)</label>
            <?php if(!empty($company['cover'])): ?>
                <div style="margin-bottom:8px;">
                    <img src="../<?= htmlspecialchars($company['cover']) ?>" alt="غلاف الشركة" style="height:54px;border-radius:7px;">
                </div>
            <?php endif; ?>
            <input type="file" name="cover" accept="image/*">
        </div>
        <div class="form-group">
            <label>المجال *</label>
            <select name="category_id" required>
                <option value="">اختر المجال</option>
                <?php foreach($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>" <?= $cat['id'] == ($company['category_id'] ?? '') ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>المدينة *</label>
            <select name="city_id" required>
                <option value="">اختر المدينة</option>
                <?php foreach($cities as $city): ?>
                    <option value="<?= $city['id'] ?>" <?= $city['id'] == ($company['city_id'] ?? '') ? 'selected' : '' ?>>
                        <?= htmlspecialchars($city['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>نبذة عن الشركة</label>
            <textarea name="about" rows="3"><?= htmlspecialchars($company['about'] ?? '') ?></textarea>
        </div>
        <div class="form-group">
            <label>رقم الجوال *</label>
            <input type="text" name="phone" value="<?= htmlspecialchars($company['phone'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label>رقم واتساب</label>
            <input type="text" name="whatsapp" value="<?= htmlspecialchars($company['whatsapp'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>البريد الإلكتروني *</label>
            <input type="email" name="email" value="<?= htmlspecialchars($company['email'] ?? '') ?>" required>
        </div>
        <div class="form-group">
            <label>الموقع الإلكتروني</label>
            <input type="text" name="website" value="<?= htmlspecialchars($company['website'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>رابط الخريطة</label>
            <input type="text" name="map_link" value="<?= htmlspecialchars($company['map_link'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>صور إضافية (3-6 صور بحد أقصى)</label>
            <?php if(!empty($old_images)): ?>
                <div style="display:flex;gap:6px;flex-wrap:wrap;margin-bottom:8px;">
                    <?php foreach($old_images as $img): ?>
                        <img src="../<?= htmlspecialchars($img) ?>" style="height:46px;border-radius:6px;">
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <input type="file" name="images[]" accept="image/*" multiple>
        </div>
        <button type="submit" class="main-btn" style="width:100%;margin-top:12px;">حفظ البيانات</button>
    </form>
</div>

<?php include "../includes/footer.php"; ?>
