<?php
require_once '../config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

// جلب الشركة
$stmt = $pdo->prepare("SELECT * FROM companies WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$company = $stmt->fetch();
if (!$company) {
    die("<div style='color:#e74c3c;font-size:20px;text-align:center;margin:40px 0;'>لم يتم العثور على بيانات الشركة</div>");
}

// حذف عرض إذا تم طلب الحذف
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $offer_id = intval($_GET['delete']);
    $del = $pdo->prepare("DELETE FROM offers WHERE id = ? AND company_id = ?");
    $del->execute([$offer_id, $company['id']]);
    header("Location: offers.php?msg=deleted");
    exit;
}

// جلب العروض الخاصة بالشركة
$stmt = $pdo->prepare("SELECT * FROM offers WHERE company_id = ? ORDER BY id DESC");
$stmt->execute([$company['id']]);
$offers = $stmt->fetchAll();

$msg = '';
if (isset($_GET['msg'])) {
    if ($_GET['msg'] == 'added') $msg = "تم إضافة العرض بنجاح. بانتظار موافقة الإدارة.";
    if ($_GET['msg'] == 'deleted') $msg = "تم حذف العرض بنجاح.";
    if ($_GET['msg'] == 'updated') $msg = "تم تحديث العرض بنجاح.";
}
?>

<?php include "../includes/header.php"; ?>

<div style="max-width:900px;margin:40px auto 60px auto;">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:24px;">
        <h2 style="margin:0;">عروضي</h2>
        <a href="add_offer.php" class="main-btn" style="min-width:160px;"><i class="fas fa-plus"></i> إضافة عرض جديد</a>
    </div>
    <?php if($msg): ?>
        <div class="alert alert-success" style="color:#fff;background:#27ae60;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?= $msg ?>
        </div>
    <?php endif; ?>
    <?php if (!$offers): ?>
        <div style="background:#fff;padding:30px 18px;text-align:center;border-radius:13px;color:#888;">
            لم تقم بإضافة أي عروض بعد.
        </div>
    <?php else: ?>
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(320px,1fr));gap:20px;">
            <?php foreach ($offers as $offer): ?>
                <div style="background:#fff;padding:18px 12px 14px 12px;border-radius:14px;box-shadow:0 2px 16px #e7e7e7;">
                    <?php if (!empty($offer['image'])): ?>
                        <img src="../<?= htmlspecialchars($offer['image']) ?>" alt="صورة العرض" style="width:100%;max-height:170px;object-fit:cover;border-radius:10px 10px 6px 6px;margin-bottom:11px;">
                    <?php endif; ?>
                    <h3 style="font-size:20px;margin-bottom:7px;"><?= htmlspecialchars($offer['title']) ?></h3>
                    <div style="color:#888;font-size:14px;margin-bottom:8px;"><?= nl2br(htmlspecialchars($offer['description'])) ?></div>
                    <div style="margin-bottom:7px;">
                        <span style="color:#7c3aed;font-weight:500;">السعر قبل: </span>
                        <?= $offer['old_price'] ? number_format($offer['old_price']) . " ريال" : '-' ?>
                        <span style="margin-right:15px;color:#27ae60;font-weight:500;">السعر بعد: </span>
                        <?= $offer['new_price'] ? number_format($offer['new_price']) . " ريال" : '-' ?>
                    </div>
                    <div style="font-size:15px;margin-bottom:6px;">
                        <span><i class="far fa-calendar-alt"></i> ينتهي في: <?= htmlspecialchars($offer['end_date']) ?></span>
                    </div>
                    <div style="margin-bottom:9px;">
                        الحالة:
                        <?php
                        $status = $offer['status'];
                        if (
                            $status == 'pending' ||
                            $status == 'بانتظار الموافقة' ||
                            $status == 'بانتظار' ||
                            $status == 'انتظار'
                        ) {
                            echo '<span style="color:#e67e22;font-weight:bold;">بانتظار الموافقة</span>';
                        }
                        elseif (
                            $status == 'approved' ||
                            $status == 'موافق' ||
                            $status == 'معتمد'
                        ) {
                            echo '<span style="color:#27ae60;font-weight:bold;">مقبول ✅</span>';
                        }
                        elseif (
                            $status == 'rejected' ||
                            $status == 'مرفوض'
                        ) {
                            echo '<span style="color:#e74c3c;font-weight:bold;">مرفوض ❌</span>';
                        } else {
                            echo '<span style="color:#888;font-weight:bold;">غير محدد</span>';
                        }
                        ?>
                    </div>
                    <div style="display:flex;gap:10px;">
                        <a href="edit_offer.php?id=<?= $offer['id'] ?>" class="main-btn" style="padding:4px 16px;font-size:15px;">تعديل</a>
                        <a href="offers.php?delete=<?= $offer['id'] ?>" class="main-btn" onclick="return confirm('هل أنت متأكد من حذف العرض؟');" style="background:#e74c3c;color:#fff;padding:4px 16px;font-size:15px;">حذف</a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?php include "../includes/footer.php"; ?>
