<?php
require_once '../config/db.php';
session_start();

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

// جلب بيانات المستخدم والشركة
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

$stmt = $pdo->prepare("SELECT * FROM companies WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$company = $stmt->fetch();
?>

<?php include "../includes/header.php"; ?>

<div style="max-width:700px;margin:40px auto 60px auto;background:#fff;padding:38px 24px 28px 24px;border-radius:15px;box-shadow:0 4px 32px #c2c2c229;">
    <h2 style="margin-bottom:24px;text-align:center;color:#7c3aed;">مرحبًا <?= htmlspecialchars($user['name']) ?> 👋</h2>
    <?php if ($company): ?>
        <div style="text-align:center;">
            <p style="font-size:18px;">
                تم تسجيل شركتك: <b><?= htmlspecialchars($company['name']) ?></b>
                <br>
                حالة الشركة: 
                <?php
                if ($company['status'] == 'pending') {
                    echo '<span style="color:#e67e22;font-weight:bold;">بانتظار الموافقة</span>';
                } elseif ($company['status'] == 'approved') {
                    echo '<span style="color:#27ae60;font-weight:bold;">مقبولة ✅</span>';
                } else {
                    echo '<span style="color:#e74c3c;font-weight:bold;">مرفوضة ❌</span>';
                }
                ?>
            </p>
            <div style="margin:28px 0 18px 0;">
                <a href="profile.php" class="main-btn" style="margin:0 12px 8px 0;">إكمال/تعديل بيانات الشركة</a>
                <a href="offers.php" class="main-btn" style="margin:0 12px 8px 0;">إدارة العروض</a>
            </div>
        </div>
    <?php else: ?>
        <div style="text-align:center;">
            <b style="color:#e74c3c;">لم يتم العثور على بيانات الشركة.</b>
        </div>
    <?php endif; ?>
    <div style="text-align:center;margin-top:25px;">
        <a href="../logout.php" style="color:#e74c3c;font-weight:bold;">تسجيل الخروج</a>
    </div>
</div>

<?php include "../includes/footer.php"; ?>
