<?php
require_once '../config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

// جلب بيانات الشركة للمستخدم
$stmt = $pdo->prepare("SELECT * FROM companies WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$company = $stmt->fetch();

if (!$company) {
    die("<div style='color:#e74c3c;font-size:18px;text-align:center;margin:40px 0;'>لم يتم العثور على بيانات الشركة</div>");
}

// التحقق من وجود العرض وملكيته
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("<div style='color:#e74c3c;font-size:18px;text-align:center;margin:40px 0;'>العرض غير موجود</div>");
}
$offer_id = intval($_GET['id']);
$stmt = $pdo->prepare("SELECT * FROM offers WHERE id = ? AND company_id = ?");
$stmt->execute([$offer_id, $company['id']]);
$offer = $stmt->fetch();
if (!$offer) {
    die("<div style='color:#e74c3c;font-size:18px;text-align:center;margin:40px 0;'>العرض غير موجود أو لا يتبع شركتك</div>");
}

$success = '';
$errors = [];
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title       = trim($_POST['title']);
    $description = trim($_POST['description']);
    $old_price   = $_POST['old_price'] !== '' ? floatval($_POST['old_price']) : null;
    $new_price   = $_POST['new_price'] !== '' ? floatval($_POST['new_price']) : null;
    $expire_date = trim($_POST['end_date']); // هنا فقط قمنا بالتعديل

    // معالجة صورة العرض
    $image = $offer['image'];
    if (!empty($_FILES['image']['name'])) {
        if ($_FILES['image']['size'] > 500 * 1024) {
            $errors[] = "حجم صورة العرض يجب ألا يتجاوز 500 كيلوبايت.";
        } else {
            $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
            $img_name = 'offer_' . $company['id'] . '_' . time() . '.' . $ext;
            $img_path = '../uploads/offers/' . $img_name;
            if (!is_dir('../uploads/offers/')) {
                mkdir('../uploads/offers/', 0777, true);
            }
            if (move_uploaded_file($_FILES['image']['tmp_name'], $img_path)) {
                $image = 'uploads/offers/' . $img_name;
            }
        }
    }

    // التحقق من الحقول المطلوبة
    if (!$title || !$description || !$expire_date) {
        $errors[] = "جميع الحقول مطلوبة.";
    }

    if (empty($errors)) {
        $stmt = $pdo->prepare("UPDATE offers SET
            title = ?, description = ?, image = ?, old_price = ?, new_price = ?, expire_date = ?, status = 'pending'
            WHERE id = ? AND company_id = ?");
        $stmt->execute([
            $title,
            $description,
            $image,
            $old_price,
            $new_price,
            $expire_date, // هنا صار التحديث للعمود الصحيح
            $offer_id,
            $company['id']
        ]);
        $success = "تم تحديث بيانات العرض بنجاح! سيتم مراجعته مجددًا من قبل الإدارة.";
        // جلب بيانات العرض بعد التحديث
        $stmt = $pdo->prepare("SELECT * FROM offers WHERE id = ? AND company_id = ?");
        $stmt->execute([$offer_id, $company['id']]);
        $offer = $stmt->fetch();
    }
}
?>
<style>
.register-form {
  max-width: 700px;
  margin: 40px auto 80px;
  background: #fff;
  padding: 38px 24px 28px;
  border-radius: 15px;
  box-shadow: 0 4px 32px #c2c2c229;
}

.register-form h2 {
  margin-bottom: 24px;
  text-align: center;
  font-size: 22px;
  color: #6d2490;
}

.form-group {
  margin-bottom: 16px;
}

.form-group label {
  display: block;
  margin-bottom: 6px;
  font-weight: bold;
  color: #333;
}

.form-group input[type="text"],
.form-group input[type="number"],
.form-group input[type="date"],
.form-group input[type="file"],
.form-group textarea,
.form-group select {
  width: 100%;
  padding: 10px 12px;
  font-family: 'Cairo', sans-serif;
  font-size: 15px;
  border: 1px solid #ccc;
  border-radius: 8px;
  box-sizing: border-box;
  background-color: #fff;
}

.form-group textarea {
  resize: vertical;
}

.main-btn {
  background-color: #6d2490;
  color: white;
  padding: 12px;
  font-size: 16px;
  border: none;
  border-radius: 10px;
  cursor: pointer;
  transition: background-color 0.3s ease;
  text-align: center;
  display: inline-block;
  text-decoration: none;
}

.main-btn:hover {
  background-color: #5a1e79;
}

.alert {
  font-size: 15px;
  line-height: 1.6;
}

/* استجابة الجوال */
@media (max-width: 600px) {
  .register-form {
    padding: 24px 15px;
    margin: 20px 10px 60px;
  }

  .form-group {
    margin-bottom: 14px;
  }

  .form-group label {
    font-size: 14px;
  }

  .form-group input,
  .form-group textarea,
  .form-group select {
    font-size: 14px;
    padding: 9px 10px;
  }

  .main-btn {
    font-size: 15px;
    padding: 10px;
  }

  .register-form h2 {
    font-size: 20px;
  }

  .form-group img {
    height: 50px !important;
    max-width: 100%;
    border-radius: 6px;
  }
}
</style>


<?php include "../includes/header.php"; ?>

<div class="register-form" style="max-width:600px;margin:40px auto 80px auto;background:#fff;padding:38px 24px 28px 24px;border-radius:15px;box-shadow:0 4px 32px #c2c2c229;">
    <h2 style="margin-bottom:24px;text-align:center;">تعديل بيانات العرض</h2>
    <?php if ($errors): ?>
        <div class="alert alert-danger" style="color:#fff;background:#e74c3c;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?php foreach ($errors as $e) echo "<div>$e</div>"; ?>
        </div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success" style="color:#fff;background:#27ae60;padding:10px 18px;border-radius:8px;margin-bottom:18px;">
            <?= $success ?>
            <div style="margin-top:16px;">
                <a href="offers.php" class="main-btn">العودة إلى عروضي</a>
            </div>
        </div>
    <?php endif; ?>
    <form method="post" enctype="multipart/form-data" autocomplete="off">
        <div class="form-group">
            <label>عنوان العرض *</label>
            <input type="text" name="title" required value="<?= htmlspecialchars($offer['title'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>نبذة عن العرض *</label>
            <textarea name="description" rows="3" required><?= htmlspecialchars($offer['description'] ?? '') ?></textarea>
        </div>
        <div class="form-group">
            <label>صورة العرض (PNG/JPG) *</label>
            <?php if (!empty($offer['image'])): ?>
                <div style="margin-bottom:7px;">
                    <img src="../<?= htmlspecialchars($offer['image']) ?>" alt="صورة العرض" style="height:60px;border-radius:8px;">
                </div>
            <?php endif; ?>
            <input type="file" name="image" accept="image/*">
            <small style="color:#666;">أقصى حجم 500 كيلوبايت. (إذا لم ترغب في تغيير الصورة اترك الحقل فارغًا)</small>
        </div>
        <div class="form-group">
            <label>السعر قبل</label>
            <input type="number" name="old_price" step="0.01" min="0" value="<?= htmlspecialchars($offer['old_price'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>السعر بعد</label>
            <input type="number" name="new_price" step="0.01" min="0" value="<?= htmlspecialchars($offer['new_price'] ?? '') ?>">
        </div>
        <div class="form-group">
            <label>تاريخ انتهاء العرض *</label>
            <input type="date" name="end_date" required value="<?= htmlspecialchars($offer['end_date'] ?? '') ?>">
        </div>
        <button type="submit" class="main-btn" style="width:100%;margin-top:12px;">حفظ التعديلات</button>
    </form>
</div>

<?php include "../includes/footer.php"; ?>
