<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "config/db.php";

// استقبال رقم الشركة
$company_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if (!$company_id) {
    require_once "includes/header.php";
    echo "<div style='text-align:center;padding:40px;'>رقم الشركة غير صحيح</div>";
    require_once "includes/footer.php";
    exit;
}

// جلب بيانات الشركة
$stmt = $pdo->prepare("SELECT c.*, cat.name AS category_name, city.name AS city_name
    FROM companies c
    LEFT JOIN categories cat ON c.category_id = cat.id
    LEFT JOIN cities city ON c.city_id = city.id
    WHERE c.id = ? AND c.status = 'approved' LIMIT 1");
$stmt->execute([$company_id]);
$company = $stmt->fetch();

if (!$company) {
    require_once "includes/header.php";
    echo "<div style='text-align:center;padding:40px;'>الشركة غير موجودة أو لم يتم الموافقة عليها بعد</div>";
    require_once "includes/footer.php";
    exit;
}

// تهيئة الصور (JSON)
$images = [];
if (!empty($company['images'])) {
    $images = json_decode($company['images'], true);
}

// تمرير بيانات SEO
$page_title = $company['name'] . " | دليل الشركات";
$page_desc = mb_substr(strip_tags($company['about'] ?? ''), 0, 160);
$page_image = !empty($images[0]) ? "https://alzaahrani.com/dalelapp/uploads/" . $images[0] : "https://alzaahrani.com/dalelapp/assets/og-default.jpg";
$current_url = "https://alzaahrani.com" . $_SERVER['REQUEST_URI'];

include "includes/seo.php"; // ✅ قبل الهيدر
require_once "includes/header.php";

// جلب عروض الشركة
$stmt = $pdo->prepare("SELECT * FROM offers WHERE company_id=? AND status='موافق' ORDER BY id DESC");
$stmt->execute([$company_id]);
$offers = $stmt->fetchAll();

// دالة تنسيق رقم الواتساب
function formatWhatsapp($phone) {
    $phone = preg_replace('/\D/', '', $phone);
    if (strpos($phone, '966') === 0) return $phone;
    if (strpos($phone, '05') === 0) return '966' . substr($phone, 1);
    if (strpos($phone, '5') === 0) return '966' . $phone;
    return $phone;
}
?>

<div class="container-company">
    <!-- بطاقة الشركة -->
    <div class="company-card-pro">
        <div class="company-main-row">
            <div class="company-logo-wrap">
                <img src="<?= htmlspecialchars($company['logo'] ?? 'assets/images/company-default.png') ?>" alt="شعار <?= htmlspecialchars($company['name'] ?? '') ?>">
            </div>
            <div class="company-details">
                <div class="company-header-flex">
                    <h2 class="company-name"><?= htmlspecialchars($company['name'] ?? '') ?></h2>
                    <span class="company-status">نشط</span>
                </div>
                <div class="company-meta">
                    <span><i class="fas fa-map-marker-alt"></i> <?= htmlspecialchars($company['city_name'] ?? '') ?></span>
                    <span style="margin:0 8px;">|</span>
                    <span><i class="fas fa-tag"></i> <?= htmlspecialchars($company['category_name'] ?? '') ?></span>
                </div>
                <div class="company-about"><?= nl2br(htmlspecialchars($company['about'] ?? '')) ?></div>
            </div>
        </div>

        <!-- أزرار التواصل -->
        <div class="company-actions">
            <?php if($company['map_link']): ?>
                <a href="<?= htmlspecialchars($company['map_link']) ?>" target="_blank" class="btn-contact-link map" title="خريطة الموقع"><i class="fas fa-map-marked-alt"></i></a>
            <?php endif; ?>
            <?php if($company['website']): ?>
                <a href="<?= htmlspecialchars($company['website']) ?>" target="_blank" class="btn-contact-link website" title="الموقع الإلكتروني"><i class="fas fa-globe"></i></a>
            <?php endif; ?>
            <?php if($company['email']): ?>
                <a href="mailto:<?= htmlspecialchars($company['email']) ?>" class="btn-contact-link email" title="الإيميل"><i class="fas fa-envelope"></i></a>
            <?php endif; ?>
            <?php if($company['phone']): ?>
                <a href="tel:<?= htmlspecialchars($company['phone']) ?>" class="btn-contact-link phone" title="اتصال"><i class="fas fa-phone-alt"></i></a>
            <?php endif; ?>
            <?php if($company['whatsapp']): ?>
                <a href="https://wa.me/<?= formatWhatsapp($company['whatsapp']) ?>" target="_blank" class="btn-contact-link whatsapp" title="واتساب"><i class="fab fa-whatsapp"></i></a>
            <?php endif; ?>
        </div>

        <!-- المعرض -->
        <?php if (!empty($images)): ?>
            <div class="company-gallery">
                <?php foreach ($images as $img): ?>
                    <a href="<?= htmlspecialchars($img) ?>" class="gallery-thumb" data-fancybox="gallery" data-caption="صورة الشركة">
                        <img src="<?= htmlspecialchars($img) ?>" alt="صورة">
                    </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- عروض -->
    <div class="company-offers-section">
        <h3 class="company-offers-title"><i class="fas fa-tags"></i> عروض الشركة</h3>
        <?php if($offers): ?>
            <div class="company-offers-wrapper">
                <?php foreach($offers as $offer): ?>
                    <?php $offer_exp = $offer['expire_date'] ?? $offer['end_date'] ?? ''; ?>
                    <div class="offer-card-pro">
                        <div class="offer-img2">
                            <img src="<?= htmlspecialchars($offer['image'] ?: 'assets/images/offer-default.png') ?>" alt="صورة العرض">
                        </div>
                        <div class="offer-body">
                            <div class="offer-title"><?= htmlspecialchars($offer['title']) ?></div>
                            <div class="offer-desc"><?= htmlspecialchars(mb_substr($offer['description'], 0, 60, 'utf-8')) ?>...</div>
                            <div class="offer-prices">
                                <?php if (!empty($offer['old_price'])): ?>
                                    <span class="old-price"><?= number_format($offer['old_price']) ?> ريال</span>
                                <?php endif; ?>
                                <span class="new-price"><?= number_format($offer['new_price']) ?> ريال</span>
                            </div>
                            <div class="offer-expire">
                                <i class="fas fa-calendar-alt"></i> <?= htmlspecialchars($offer_exp) ?>
                                <?php if (!empty($offer_exp) && $offer_exp < date('Y-m-d')): ?>
                                    <span style="color:#c00;font-weight:bold;margin-right:8px;">(انتهى العرض)</span>
                                <?php endif; ?>
                            </div>
                            <div class="offer-contact-row">
                                <?php if(!empty($company['phone'])): ?>
                                    <a href="tel:<?= htmlspecialchars($company['phone']) ?>" class="btn-contact-offer phone" title="اتصال"><i class="fas fa-phone-alt"></i></a>
                                <?php endif; ?>
                                <?php if(!empty($company['whatsapp'])): ?>
                                    <a href="https://wa.me/<?= formatWhatsapp($company['whatsapp']) ?>" target="_blank" class="btn-contact-offer whatsapp" title="واتساب"><i class="fab fa-whatsapp"></i></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div style="color:#c00;padding:22px;text-align:center;">لا توجد عروض حالياً.</div>
        <?php endif; ?>
    </div>
</div>

<!-- Fancybox -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox/fancybox.css"/>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox/fancybox.umd.js"></script>
<script>
Fancybox.bind("[data-fancybox]", {
  closeButton: "top",
  Toolbar: {
    display: ["close"]
  }
});
</script>

<!-- CSS -->
<style>
.container-company { max-width:1050px; margin:38px auto; }
.company-card-pro { background:#fff; border-radius:20px; box-shadow:0 0 20px #0000000a; padding:30px; margin-bottom:30px; }
.company-main-row { display:flex; flex-wrap:wrap; gap:20px; }
.company-logo-wrap { width:100px; height:100px; border-radius:20px; overflow:hidden; background:#f4f4f4; display:flex; align-items:center; justify-content:center; }
.company-logo-wrap img { width:80px; height:80px; object-fit:contain; }
.company-details { flex:1; }
.company-header-flex { display:flex; align-items:center; gap:10px; }
.company-name { font-size:24px; font-weight:bold; color:#333; }
.company-status { background:#ece8fd; color:#6d2490; padding:3px 15px; border-radius:12px; font-size:14px; }
.company-meta { color:#777; font-size:15px; margin-top:5px; }
.company-about { margin-top:10px; font-size:15.5px; color:#333; }
.company-actions { margin-top:20px; display:flex; gap:10px; flex-wrap:wrap; }
.btn-contact-link { width:42px; height:42px; background:#7c3aed; color:#fff; display:flex; align-items:center; justify-content:center; border-radius:10px; font-size:18px; }
.btn-contact-link.phone { background:#2ecc71; }
.btn-contact-link.whatsapp { background:#25d366; }
.btn-contact-link.email { background:#3498db; }
.btn-contact-link.map { background:#f39c12; }
.btn-contact-link.website { background:#9b59b6; }

.company-gallery { display:flex; flex-wrap:wrap; gap:10px; margin-top:20px; }
.gallery-thumb { width:90px; height:70px; overflow:hidden; border-radius:8px; box-shadow:0 2px 5px #00000010; }
.gallery-thumb img { width:100%; height:100%; object-fit:cover; }

.company-offers-section { margin-top:40px; }
.company-offers-title { font-size:20px; color:#7c3aed; margin-bottom:20px; }
.company-offers-wrapper { display:flex; flex-wrap:wrap; gap:20px; justify-content:center; }
.offer-card-pro { background:#fff; border-radius:16px; box-shadow:0 2px 10px #00000010; width:310px; overflow:hidden; display:flex; flex-direction:column; }
.offer-img2 img { width:100%; height:160px; object-fit:cover; }
.offer-body { padding:16px; text-align:center; }
.offer-title { font-weight:bold; font-size:18px; margin-bottom:5px; }
.offer-desc { color:#777; font-size:15px; margin-bottom:10px; }
.offer-prices { display:flex; gap:10px; justify-content:center; margin-bottom:6px; font-size:16px; }
.old-price { text-decoration:line-through; color:#aaa; }
.new-price { color:#2ecc71; font-weight:bold; }
.offer-expire { font-size:14px; color:#555; margin-bottom:8px; }
.offer-contact-row { display:flex; justify-content:center; gap:10px; }
.btn-contact-offer { width:38px; height:38px; border-radius:8px; font-size:16px; background:#7c3aed; color:#fff; display:flex; align-items:center; justify-content:center; }
.btn-contact-offer.whatsapp { background:#25d366; }

@media (max-width: 768px) {
  .company-main-row { flex-direction:column; align-items:flex-start; }
  .offer-card-pro { width:100%; }
}
</style>

<?php require_once "includes/footer.php"; ?>
