<?php
require_once "config/db.php";
include "includes/header.php";

// جلب التصنيفات والمدن (للبحث)
$categories = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();
$cities = $pdo->query("SELECT * FROM cities ORDER BY name")->fetchAll();

// جلب الشركات النشطة مع حماية للبيانات المرتبطة
$stmt = $pdo->query("
    SELECT c.*, 
           COALESCE(cat.name, 'غير محدد') AS category_name, 
           COALESCE(city.name, 'غير محددة') AS city_name
    FROM companies c
    LEFT JOIN categories cat ON c.category_id = cat.id
    LEFT JOIN cities city ON c.city_id = city.id
    WHERE c.status = 'approved'
    ORDER BY c.id DESC
");

$companies = $stmt->fetchAll();
?>

<div class="page-header">
  <h1><i class="fas fa-building"></i> جميع الشركات</h1>
</div>

<div class="featured-companies" style="display: flex; flex-wrap: wrap; justify-content: center; gap: 24px;">
  <?php if (!$companies): ?>
    <div style="text-align:center;color:#aaa;padding:30px 0;">لا يوجد شركات حالياً.</div>
  <?php else: ?>
    <?php foreach ($companies as $company): ?>
      <div class="company-card2">
        <!-- صورة الغلاف -->
        <div class="cover-image" style="background-image: url('<?= !empty($company['cover']) ? htmlspecialchars($company['cover']) : 'images/cover-default.png' ?>');">
          <div class="status-badge">نشط</div>
        </div>

        <!-- معلومات الشركة -->
        <div class="company-header">
          <div class="logo-wrap">
            <img src="<?= !empty($company['logo']) ? htmlspecialchars($company['logo']) : 'images/company-default.png' ?>" alt="شعار الشركة">
          </div>
          <div>
            <div class="company-name-badge"><?= htmlspecialchars($company['name']) ?></div>
            <div class="meta">
              <span><i class="fas fa-tag"></i> <?= htmlspecialchars($company['category_name'] ?? 'غير محدد') ?></span>
              <span><i class="fas fa-map-marker-alt"></i> <?= htmlspecialchars($company['city_name'] ?? 'غير محددة') ?></span>
            </div>
          </div>
        </div>

        <?php
          $about = $company['about'] ?? '';
          $desc = mb_substr($about, 0, 72) . (mb_strlen($about) > 72 ? '...' : '');
        ?>
        <p class="description"><?= htmlspecialchars($desc) ?></p>
        <div class="actions">
          <a href="company.php?id=<?= $company['id'] ?>" class="btn-details"><i class="fas fa-eye"></i> التفاصيل</a>
          <?php if (!empty($company['phone'])): ?>
            <a href="tel:<?= htmlspecialchars($company['phone']) ?>" class="btn-contact"><i class="fas fa-phone-alt"></i> اتصل</a>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

<style>
/* ===== تنسيقات البطاقات ===== */
.company-card2 {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 2px 14px #0001;
  padding: 0 0 18px 0;
  width: 100%;
  max-width: 360px;
  margin: 14px auto;
  overflow: hidden;
  display: flex;
  flex-direction: column;
  transition: box-shadow 0.2s;
}
.company-card2:hover { box-shadow: 0 6px 28px #0002; }

.cover-image {
  width: 100%;
  height: 145px;
  background-size: cover;
  background-position: center;
  position: relative;
}
.status-badge {
  position: absolute;
  top: 13px;
  left: 15px;
  background: #ece8fd;
  color: #6d2490;
  font-size: 15px;
  font-weight: 600;
  border-radius: 18px;
  padding: 4px 18px;
  box-shadow: 0 2px 8px #0001;
  z-index: 2;
}
.company-header {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 0 18px;
  margin-top: -32px;
  position: relative;
  z-index: 1;
}
.logo-wrap {
  width: 62px;
  height: 62px;
  border-radius: 50%;
  overflow: hidden;
  border: 2.5px solid #fff;
  background: #fff;
  box-shadow: 0 2px 8px #0001;
  display: flex;
  align-items: center;
  justify-content: center;
}
.logo-wrap img {
  width: 54px;
  height: 54px;
  object-fit: contain;
  background: #f5f5fa;
  border-radius: 50%;
}
.company-name-badge {
  background: #fff;
  color: #6d2490;
  font-size: 18px;
  font-weight: bold;
  border-radius: 15px;
  padding: 6px 20px;
  box-shadow: 0 1px 6px #0001;
  border: 1.5px solid #eaeaea;
  margin-bottom: 4px;
}
.company-header .meta {
  color: #888;
  font-size: 14px;
  margin-bottom: 2px;
}
.description {
  color: #454545;
  font-size: 16px;
  margin: 14px 18px 8px 18px;
  min-height: 40px;
}
.actions {
  display: flex;
  gap: 12px;
  margin: 12px 18px 0 18px;
}
.btn-details {
  background: #6d2490;
  color: #fff;
  padding: 7px 19px;
  border-radius: 9px;
  font-size: 15px;
  text-decoration: none;
  font-weight: 600;
  transition: 0.18s;
}
.btn-details:hover { background: #43126d; }
.btn-contact {
  background: #4eac5d;
  color: #fff;
  padding: 7px 19px;
  border-radius: 9px;
  font-size: 15px;
  text-decoration: none;
  font-weight: 600;
  transition: 0.18s;
}
.btn-contact:hover { background: #338b40; }
</style>

<?php include "includes/footer.php"; ?>
