<?php
// ملف: index.php
declare(strict_types=1);
error_reporting(E_ALL);
ini_set('display_errors', '1');

// 1. تحميل الإعدادات
define('ROOT', __DIR__);
require_once ROOT . '/config/db.php';

// 2. تحميل الهيدر
$header = ROOT . '/includes/header.php';
if (!file_exists($header)) {
    die("<div style='color:red'>خطأ: ملف الهيدر غير موجود</div>");
}
include $header;
?>

<!-- المحتوى الرئيسي -->
<div class="container">
    <?php
    // 3. تحميل المحتوى الديناميكي
    try {
        $sliders = $pdo->query("SELECT * FROM sliders WHERE active=1")->fetchAll();
        foreach ($sliders as $slide) {
            echo '<div class="slide">';
            echo '<img src="' . htmlspecialchars($slide['image']) . '" alt="">';
            echo '</div>';
        }
    } catch (PDOException $e) {
        echo "<div class='error'>خطأ في تحميل السلايدر: " . $e->getMessage() . "</div>";
    }
    ?>
</div>

<?php
// 4. تحميل الفوتر
include ROOT . '/includes/footer.php';