<?php
require_once "config/db.php";
include "includes/header.php";

// جلب المقالات المنشورة فقط
$stmt = $pdo->query("SELECT * FROM posts WHERE status = 'published' ORDER BY created_at DESC");
$posts = $stmt->fetchAll();
?>

<div class="page-header">
  <h1><i class="fas fa-blog"></i> المدونة</h1>
  <p>تابع آخر المقالات والمستجدات من خلال مدونتنا</p>
</div>

<div class="blog-wrapper">
<?php if (!$posts): ?>
  <div style="text-align:center;color:#888;padding:30px 0;">لا توجد مقالات حالياً.</div>
<?php else: ?>
  <?php foreach ($posts as $post): ?>
    <div class="blog-card">
      <div class="blog-image">
        <img src="<?= htmlspecialchars($post['image'] ?: 'assets/images/blog-default.jpg') ?>" alt="<?= htmlspecialchars($post['title']) ?>">
      </div>
      <div class="blog-body">
        <h3 class="blog-title"><?= htmlspecialchars($post['title']) ?></h3>
        <p class="blog-excerpt"><?= mb_substr(strip_tags($post['content']), 0, 90) ?>...</p>
        <a href="post.php?id=<?= $post['id'] ?>" class="blog-read">اقرأ المزيد <i class="fas fa-arrow-left"></i></a>
      </div>
    </div>
  <?php endforeach; ?>
<?php endif; ?>
</div>

<style>
.blog-wrapper {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  justify-content: center;
  margin: 40px auto;
  max-width: 1200px;
}
.blog-card {
  background: #fff;
  border-radius: 15px;
  box-shadow: 0 2px 10px #00000010;
  overflow: hidden;
  max-width: 350px;
  min-width: 280px;
  transition: 0.3s;
}
.blog-card:hover { box-shadow: 0 4px 20px #00000020; }
.blog-image img {
  width: 100%;
  height: 180px;
  object-fit: cover;
}
.blog-body {
  padding: 18px;
}
.blog-title {
  font-size: 18px;
  font-weight: bold;
  margin-bottom: 10px;
  color: #333;
}
.blog-excerpt {
  font-size: 15px;
  color: #777;
  margin-bottom: 12px;
}
.blog-read {
  color: #6d2490;
  font-weight: 600;
  text-decoration: none;
  transition: 0.2s;
}
.blog-read:hover { text-decoration: underline; }
</style>

<?php include "includes/footer.php"; ?>
