// تأثيرات التحميل الأولية مع تحسينات
document.addEventListener('DOMContentLoaded', function() {
    // إضافة تأثير تحميل سلس للصفحة
    document.body.style.opacity = '0';
    document.body.style.transition = 'opacity 0.5s ease';
    
    setTimeout(function() {
        document.body.style.opacity = '1';
    }, 100);

    // تهيئة السلايدرات والوظائف الأخرى
    initSliders();
    initSearchTabs();
});

/**
 * تهيئة جميع السلايدرات في الصفحة
 */
function initSliders() {
    // السلايدر الرئيسي
    if ($('.main-slider').length) {
        $('.main-slider').slick({
            rtl: true,
            dots: true,
            infinite: true,
            speed: 800,
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: true,
            autoplaySpeed: 5000,
            arrows: true,
            pauseOnHover: false,
            cssEase: 'ease-in-out',
            prevArrow: '<button type="button" class="slick-prev" aria-label="السابق"><i class="fas fa-chevron-right"></i></button>',
            nextArrow: '<button type="button" class="slick-next" aria-label="التالي"><i class="fas fa-chevron-left"></i></button>'
        });
    }

    // سلايدر الشركات المميزة
    if ($('.companies-slider').length) {
        $('.companies-slider').slick({
            rtl: true,
            dots: true,
            infinite: true,
            speed: 600,
            slidesToShow: 3,
            slidesToScroll: 1,
            autoplay: true,
            autoplaySpeed: 4000,
            arrows: false,
            pauseOnHover: true,
            cssEase: 'ease-in-out',
            responsive: [
                { 
                    breakpoint: 1024, 
                    settings: { 
                        slidesToShow: 2, 
                        slidesToScroll: 1 
                    } 
                },
                { 
                    breakpoint: 600,  
                    settings: { 
                        slidesToShow: 1, 
                        slidesToScroll: 1,
                        dots: false
                    } 
                }
            ]
        });

        // التحكم بالسلايدر بالأزرار المخصصة
        $('.slider-prev').off('click').on('click', function() {
            $('.companies-slider').slick('slickPrev');
        });
        
        $('.slider-next').off('click').on('click', function() {
            $('.companies-slider').slick('slickNext');
        });
    }
}

/**
 * تهيئة تبويبات البحث
 */
function initSearchTabs() {
    const tabCompanies = document.getElementById("tab-companies");
    const tabOffers = document.getElementById("tab-offers");
    const formCompanies = document.getElementById("form-companies");
    const formOffers = document.getElementById("form-offers");

    if (tabCompanies && tabOffers && formCompanies && formOffers) {
        // تبديل إلى تبويب الشركات
        tabCompanies.addEventListener('click', function(e) {
            e.preventDefault();
            switchTab('companies');
        });

        // تبديل إلى تبويب العروض
        tabOffers.addEventListener('click', function(e) {
            e.preventDefault();
            switchTab('offers');
        });

        // تحديد التبويب الافتراضي حسب وجود hash في URL
        if (window.location.hash === '#offers') {
            switchTab('offers');
        } else {
            switchTab('companies');
        }
    }

    /**
     * تبديل بين التبويبات
     * @param {string} activeTab - التبويب المراد تفعيله ('companies' أو 'offers')
     */
    function switchTab(activeTab) {
        if (activeTab === 'companies') {
            formCompanies.style.display = "block";
            formOffers.style.display = "none";
            tabCompanies.classList.add("active");
            tabOffers.classList.remove("active");
            history.replaceState(null, null, ' ');
        } else {
            formCompanies.style.display = "none";
            formOffers.style.display = "block";
            tabOffers.classList.add("active");
            tabCompanies.classList.remove("active");
            history.replaceState(null, null, '#offers');
        }
    }
}

// إضافة تأثيرات hover للبطاقات
$(document).on('mouseenter', '.company-card, .offer-card2', function() {
    $(this).css('transform', 'translateY(-5px)');
}).on('mouseleave', '.company-card, .offer-card2', function() {
    $(this).css('transform', '');
});

// تحسين تجربة المستخدم للأجهزة المحمولة
function setupMobileMenu() {
    const menuToggle = document.createElement('div');
    menuToggle.className = 'mobile-menu-toggle';
    menuToggle.innerHTML = '<i class="fas fa-bars"></i>';
    document.body.appendChild(menuToggle);

    menuToggle.addEventListener('click', function() {
        document.querySelector('.main-nav ul').classList.toggle('mobile-visible');
        this.classList.toggle('active');
    });
}

// تهيئة القائمة المتنقلة إذا كانت الشاشة صغيرة
if (window.innerWidth <= 768) {
    setupMobileMenu();
}

// إعادة تهيئة القائمة عند تغيير حجم النافذة
window.addEventListener('resize', function() {
    if (window.innerWidth <= 768 && !document.querySelector('.mobile-menu-toggle')) {
        setupMobileMenu();
    } else if (window.innerWidth > 768) {
        const toggle = document.querySelector('.mobile-menu-toggle');
        if (toggle) {
            toggle.remove();
            document.querySelector('.main-nav ul').classList.remove('mobile-visible');
        }
    }
});