<?php
require_once "../config/db.php";
$stmt = $pdo->query("SELECT * FROM sliders ORDER BY id DESC");
$sliders = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إعلانات السلايدر</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            color: #2e2340;
            margin: 0;
        }
        .container {
            max-width: 1050px;
            margin: 45px auto 0 auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            padding: 38px 24px 25px 24px;
            min-height: 540px;
        }
        .header-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 35px;
        }
        .header-bar h2 {
            color: #3e165a;
            font-size: 2rem;
            font-weight: 800;
            margin: 0;
        }
        .home-btn {
            background: linear-gradient(135deg, #3e165a 60%, #7c3aed 100%);
            color: #fff;
            padding: 8px 24px 8px 18px;
            border-radius: 50px;
            border: none;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            transition: background 0.2s, box-shadow 0.2s;
            box-shadow: 0 3px 15px rgba(62,22,90,0.09);
            text-decoration: none !important;
        }
        .home-btn i {
            margin-left: 10px;
            font-size: 1.2em;
        }
        .home-btn:hover {
            background: linear-gradient(135deg, #7c3aed, #3e165a);
        }

        /* جدول السلايدر */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background: #fff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 1px 9px #ece1fd3a;
            font-size: 1rem;
        }
        th, td {
            padding: 14px 7px;
            text-align: center;
        }
        th {
            background: linear-gradient(135deg, #3e165a 80%, #7c3aed 100%);
            color: #fff;
            font-size: 1.05rem;
            font-weight: 700;
            border-bottom: 2px solid #eee;
        }
        tr:nth-child(even) td {
            background: #f5f4fa;
        }
        tr:nth-child(odd) td {
            background: #fff;
        }
        td {
            color: #40215b;
            border-bottom: 1px solid #eee;
            vertical-align: middle;
        }
        .slider-img {
            border-radius: 12px;
            box-shadow: 0 2px 8px #dbdbf3;
            width: 80px;
            height: 48px;
            object-fit: cover;
            background: #fafafd;
        }
        .action-links a {
            color: #7c3aed;
            font-weight: 700;
            margin: 0 5px;
            padding: 4px 10px;
            border-radius: 7px;
            transition: background 0.13s, color 0.12s;
            text-decoration: none !important;
            font-size: 14px;
            border: 1px solid #f0eafd;
        }
        .action-links a:hover {
            background: #7c3aed;
            color: #fff !important;
        }
        .action-links a.delete {
            color: #e74c3c;
            border-color: #ffebeb;
        }
        .action-links a.delete:hover {
            background: #e74c3c;
            color: #fff !important;
        }
        @media (max-width: 700px) {
            .container { padding: 14px 2vw; }
            table, thead, tbody, th, td, tr { font-size: 13px; }
            .header-bar h2 { font-size: 1.1rem; }
            .home-btn { padding: 6px 12px 6px 10px; font-size: 13px; }
            .slider-img { width: 56px; height: 32px; }
        }
		.add-btn {
    background: #7c3aed;
    color: #fff !important;
    padding: 7px 19px 7px 16px;
    border-radius: 25px;
    font-size: 1rem;
    font-weight: 700;
    border: none;
    margin-bottom: 14px;
    display: inline-flex;
    align-items: center;
    transition: background 0.17s;
    text-decoration: none !important;
    box-shadow: 0 2px 10px #e7e2fa9e;
}
.add-btn i {
    margin-left: 7px;
}
.add-btn:hover {
    background: #3e165a;
}

    </style>
</head>
<body>
    <div class="container">
        <div class="header-bar">
       <h2><i class="fa fa-images" style="color:#7c3aed; margin-left:7px;"></i> إعلانات السلايدر</h2>
    <a href="index.php" class="home-btn"><i class="fa fa-home"></i> الرئيسية</a>
</div>
<a href="slider_add.php" class="add-btn"><i class="fa fa-plus"></i> إضافة سلايدر</a>
<table>
        </div>
        <table>
            <thead>
                <tr>
                    <th>الصورة</th>
                    <th>الرابط</th>
                    <th>المالك</th>
                    <th>تاريخ الانتهاء</th>
                    <th>التحكم</th>
                </tr>
            </thead>
            <tbody>
     <?php foreach($sliders as $row): ?>
    <tr>
        <td>
            <?php if (!empty($row['image'])): ?>
                <img src="/uploads/sliders/<?= htmlspecialchars(basename($row['image'])) ?>" class="slider-img" alt="banner">
            <?php else: ?>
                <span style="color:#bbb;">لا توجد صورة</span>
            <?php endif; ?>
        </td>
        <td><?= htmlspecialchars($row['url'] ?? '') ?></td>
        <td><?= htmlspecialchars($row['owner_name'] ?? 'غير محدد') ?></td>
        <td><?= htmlspecialchars($row['expire_date'] ?? 'لا يوجد') ?></td>
        <td class="action-links">
            <a href="slider_edit.php?id=<?= $row['id'] ?>"><i class="fa fa-edit"></i> تعديل</a>
            <a href="slider_delete.php?id=<?= $row['id'] ?>" class="delete" onclick="return confirm('حذف الإعلان؟')"><i class="fa fa-trash"></i> حذف</a>
        </td>
    </tr>
<?php endforeach; ?>

            </tbody>
        </table>
    </div>
</body>
</html>
