<?php
require_once "../config/db.php";

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// جلب بيانات السلايدر
$stmt = $pdo->prepare("SELECT * FROM sliders WHERE id=?");
$stmt->execute([$id]);
$slider = $stmt->fetch();

if (!$slider) {
    die("إعلان غير موجود");
}

// عند حفظ التعديل
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'] ?? '';
    $link = $_POST['link'] ?? '';
    $owner = $_POST['owner'] ?? '';
    $expire_date = $_POST['expire_date'] ?? '';
    $type = $_POST['type'] ?? 'top';
    $active = isset($_POST['active']) ? 1 : 0;

    // معالجة رفع صورة جديدة
    $image = $slider['image'];
    if (!empty($_FILES['image']['name'])) {
        $target = "../uploads/sliders/" . time() . '_' . basename($_FILES['image']['name']);
        if (move_uploaded_file($_FILES['image']['tmp_name'], $target)) {
            $image = substr($target, 3); // إزالة ../ في المسار
        }
    }

    // تحديث البيانات
    $stmt = $pdo->prepare("UPDATE sliders SET title=?, link=?, owner=?, expire_date=?, type=?, image=?, active=? WHERE id=?");
    $stmt->execute([
        $title, $link, $owner, $expire_date, $type, $image, $active, $id
    ]);

    header("Location: sliders.php?msg=updated");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تعديل إعلان سلايدر</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            color: #2e2340;
            margin: 0;
        }
        .container {
            max-width: 520px;
            margin: 45px auto 0 auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            padding: 38px 24px 25px 24px;
            min-height: 320px;
        }
        .top-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 25px;
        }
        h2 {
            color: #3e165a;
            font-size: 1.3rem;
            font-weight: 800;
            margin: 0 0 14px 0;
            display: flex;
            align-items: center;
        }
        h2 i { margin-left: 8px; color: #7c3aed;}
        .back-btn {
            background: linear-gradient(135deg, #3e165a 60%, #7c3aed 100%);
            color: #fff !important;
            padding: 7px 18px 7px 13px;
            border-radius: 50px;
            border: none;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            text-decoration: none;
            transition: background 0.2s;
            box-shadow: 0 3px 15px rgba(62,22,90,0.09);
        }
        .back-btn i { margin-left: 8px; font-size: 1.2em;}
        .back-btn:hover { background: linear-gradient(135deg, #7c3aed, #3e165a); }
        label { font-weight:600; margin-top: 13px; display: block; color: #481c79;}
        input[type=text], input[type=url], input[type=date], select {
            width: 100%;
            padding: 8px 11px;
            margin-top: 6px;
            border-radius: 8px;
            border: 1px solid #e3d7fc;
            background: #f8f6fc;
            font-size: 1rem;
            font-family: inherit;
            transition: border 0.18s;
            margin-bottom: 9px;
        }
        input[type=file] {
            margin-top: 6px;
            margin-bottom: 14px;
        }
        input[type=text]:focus, input[type=url]:focus, input[type=date]:focus, select:focus {
            border-color: #7c3aed;
            outline: none;
        }
        .img-preview {
            max-width: 160px; max-height: 80px; display:block; border-radius: 8px; box-shadow: 0 1px 7px #eaeaea; margin-bottom:9px;
            background: #fafafd; border: 1px solid #eee;
        }
        .form-actions { margin-top: 25px; text-align:center; }
        .btn-main {
            background: #7c3aed;
            color: #fff;
            border: none;
            font-weight: 700;
            border-radius: 50px;
            padding: 11px 35px;
            font-size: 1.09rem;
            cursor: pointer;
            transition: background 0.17s;
        }
        .btn-main:hover { background: #3e165a; }
        @media (max-width: 600px){
            .container { padding: 10px 2vw; }
            h2 { font-size: 1.03rem;}
            .btn-main, .back-btn { padding:7px 10vw; font-size:15px;}
            .img-preview { max-width: 99px;}
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="top-bar">
            <h2><i class="fa fa-images"></i> تعديل إعلان سلايدر</h2>
            <a href="sliders.php" class="back-btn"><i class="fa fa-arrow-right"></i> العودة للقائمة</a>
        </div>
        <form method="post" enctype="multipart/form-data">
            <label>العنوان:</label>
            <input type="text" name="title" value="<?= htmlspecialchars($slider['title'] ?? '') ?>">

            <label>الرابط (اختياري):</label>
            <input type="url" name="link" value="<?= htmlspecialchars($slider['link'] ?? '') ?>">

            <label>صاحب الإعلان:</label>
            <input type="text" name="owner" value="<?= htmlspecialchars($slider['owner'] ?? '') ?>">

            <label>تاريخ انتهاء العرض:</label>
            <input type="date" name="expire_date" value="<?= htmlspecialchars($slider['expire_date'] ?? '') ?>">

            <label>نوع السلايدر:</label>
            <select name="type">
                <option value="top" <?= (isset($slider['type']) && $slider['type']=='top') ? 'selected' : '' ?>>علوي</option>
                <option value="bottom" <?= (isset($slider['type']) && $slider['type']=='bottom') ? 'selected' : '' ?>>سفلي</option>
            </select>

            <label>الصورة:</label>
            <?php if(!empty($slider['image'])): ?>
    <img src="/dalelapp/uploads/sliders/<?= basename($slider['image']) ?>" class="img-preview" alt="صورة الإعلان">
            <?php endif; ?>
            <input type="file" name="image" accept="image/*">

            <label style="margin-top:14px;">
                <input type="checkbox" name="active" <?= !empty($slider['active']) ? 'checked' : '' ?>>
                تفعيل الإعلان
            </label>

            <div class="form-actions">
                <button type="submit" class="btn-main"><i class="fa fa-save"></i> حفظ التعديلات</button>
            </div>
        </form>
    </div>
</body>
</html>
