<?php
require_once "../config/db.php";

$error = '';
$success = '';

// عند الإرسال
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $link = trim($_POST['link'] ?? '');
    $owner = trim($_POST['owner'] ?? '');
    $expire_date = trim($_POST['expire_date'] ?? '');
    $type = $_POST['type'] ?? 'top';
    $active = isset($_POST['active']) ? 1 : 0;
    $image = '';

    // التحقق من رفع صورة
    if (!empty($_FILES['image']['name'])) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $image_name = 'slide_' . time() . '_' . rand(111,999) . '.' . $ext;
        $upload_path = '../uploads/sliders/' . $image_name;
        if (move_uploaded_file($_FILES['image']['tmp_name'], $upload_path)) {
            $image = 'uploads/sliders/' . $image_name;
        } else {
            $error = "فشل رفع الصورة!";
        }
    } else {
        $error = "يجب رفع صورة السلايدر!";
    }

    if (!$error && $title && $image) {
        $stmt = $pdo->prepare("INSERT INTO sliders (title, link, owner, expire_date, type, image, active) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$title, $link, $owner, $expire_date, $type, $image, $active]);
        $success = "تمت إضافة السلايدر بنجاح!";
    } elseif (!$error) {
        $error = "جميع الحقول مطلوبة!";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة سلايدر</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            color: #2e2340;
            margin: 0;
        }
        .container {
            max-width: 480px;
            margin: 40px auto;
            background: #fff;
            padding: 30px 24px 25px 24px;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            min-height: 300px;
        }
        .header-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 24px;
        }
        .header-bar h2 {
            color: #3e165a;
            font-size: 1.35rem;
            font-weight: 800;
            margin: 0;
            display: flex; align-items:center;
        }
        .header-bar h2 i { margin-left: 8px; color: #7c3aed;}
        .back-btn {
            background: linear-gradient(135deg, #3e165a 60%, #7c3aed 100%);
            color: #fff !important;
            padding: 7px 20px 7px 13px;
            border-radius: 50px;
            border: none;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            text-decoration: none;
            transition: background 0.2s;
            box-shadow: 0 3px 15px rgba(62,22,90,0.09);
        }
        .back-btn i { margin-left: 8px; font-size: 1.13em;}
        .back-btn:hover { background: linear-gradient(135deg, #7c3aed, #3e165a); }
        label { font-weight:600; margin-top: 17px; display: block; color: #481c79;}
        input[type=text], input[type=url], input[type=date], select {
            width: 100%;
            padding: 8px 11px;
            margin-top: 7px;
            border-radius: 8px;
            border: 1px solid #e3d7fc;
            background: #f8f6fc;
            font-size: 1rem;
            font-family: inherit;
            transition: border 0.18s;
        }
        input[type=text]:focus, input[type=url]:focus, input[type=date]:focus, select:focus {
            border-color: #7c3aed;
            outline: none;
        }
        .form-actions { margin-top: 23px; text-align:center; }
        .btn-main {
            background: #7c3aed;
            color: #fff;
            border: none;
            font-weight: 700;
            border-radius: 50px;
            padding: 11px 38px;
            font-size: 1.09rem;
            cursor: pointer;
            transition: background 0.17s;
        }
        .btn-main i { margin-left: 6px;}
        .btn-main:hover { background: #3e165a; }
        .alert-error {
            color: #c00;
            background: #fde4e4;
            padding: 8px 18px;
            border-radius: 7px;
            margin-bottom: 17px;
            text-align: right;
            font-weight: bold;
        }
        .alert-success {
            color: #128a24;
            background: #e8faee;
            padding: 8px 18px;
            border-radius: 7px;
            margin-bottom: 17px;
            text-align: right;
            font-weight: bold;
        }
        @media (max-width:600px){
            .container { padding: 10px 2vw; }
            .btn-main, .back-btn { padding:7px 12vw; font-size:15px;}
            h2 { font-size: 1.01rem;}
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header-bar">
            <h2><i class="fa fa-plus"></i> إضافة إعلان سلايدر جديد</h2>
            <a href="sliders.php" class="back-btn"><i class="fa fa-arrow-right"></i> العودة للقائمة</a>
        </div>
        <?php if ($error): ?><div class="alert-error"><?= $error ?></div><?php endif; ?>
        <?php if ($success): ?><div class="alert-success"><?= $success ?></div><?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <label>عنوان السلايدر *</label>
            <input type="text" name="title" required>

            <label>الرابط (اختياري)</label>
            <input type="url" name="link" placeholder="https://example.com">

            <label>صاحب الإعلان</label>
            <input type="text" name="owner">

            <label>تاريخ انتهاء العرض</label>
            <input type="date" name="expire_date">

            <label>نوع السلايدر</label>
            <select name="type">
                <option value="top">علوي</option>
                <option value="bottom">سفلي</option>
            </select>

            <label>الصورة *</label>
            <input type="file" name="image" accept="image/*" required>

            <label><input type="checkbox" name="active" checked> تفعيل السلايدر</label>

            <div class="form-actions">
                <button type="submit" class="btn-main"><i class="fa fa-save"></i> حفظ</button>
            </div>
        </form>
    </div>
</body>
</html>
