<?php
require_once __DIR__ . "/../../includes/auth.php";
require_once __DIR__ . "/../../config/db.php";
$stmt = $pdo->query("SELECT * FROM seo_pages ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إعدادات SEO</title>
  <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
    body {
      font-family: 'Cairo', sans-serif;
      background: #f4f4f9;
      margin: 0;
      padding: 0;
      color: #333;
    }
    .container {
      max-width: 950px;
      margin: 40px auto;
      background: #fff;
      padding: 30px;
      border-radius: 16px;
      box-shadow: 0 4px 16px rgba(0,0,0,0.07);
    }
    h1 {
      font-size: 24px;
      margin-bottom: 25px;
      color: #3e165a;
      display: flex;
      align-items: center;
    }
    h1 i {
      margin-left: 10px;
      color: #7c3aed;
    }
    .actions {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
    }
    .btn {
      padding: 10px 20px;
      border-radius: 30px;
      border: none;
      cursor: pointer;
      font-weight: bold;
      text-decoration: none;
      font-size: 14px;
    }
    .btn-add {
      background: #7c3aed;
      color: #fff;
      box-shadow: 0 2px 8px rgba(124,58,237,0.25);
    }
    .btn-home {
      background: #3e165a;
      color: #fff;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 15px;
    }
    th, td {
      padding: 12px;
      border: 1px solid #eee;
      text-align: center;
      font-size: 14px;
    }
    th {
      background: linear-gradient(to left, #7c3aed, #3e165a);
      color: #fff;
    }
    tr:nth-child(even) {
      background-color: #f9f9f9;
    }
    img {
      width: 60px;
      height: 40px;
      object-fit: cover;
      border-radius: 5px;
    }
    .edit-link {
      color: #7c3aed;
      font-weight: bold;
      text-decoration: none;
    }
    .edit-link i {
      margin-left: 5px;
    }
    @media (max-width: 600px) {
      table, thead, tbody, th, td, tr {
        font-size: 12px;
      }
      .btn {
        padding: 6px 12px;
        font-size: 12px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <h1><i class="fa fa-globe"></i> إعدادات SEO</h1>

    <div class="actions">
      <a href="../index.php" class="btn btn-home"><i class="fa fa-home"></i> الرئيسية</a>
      <a href="add.php" class="btn btn-add"><i class="fa fa-plus"></i> إضافة صفحة</a>
    </div>

    <table>
      <thead>
        <tr>
          <th>الرابط</th>
          <th>العنوان</th>
          <th>الوصف</th>
          <th>صورة OG</th>
          <th>تحكم</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($stmt as $row): ?>
        <tr>
          <td><?= htmlspecialchars($row['page']) ?></td>
          <td><?= htmlspecialchars($row['title']) ?></td>
          <td><?= htmlspecialchars(mb_substr($row['description'], 0, 40)) ?>...</td>
          <td>
            <?php if (!empty($row['custom_image'])): ?>
              <img src="../../uploads/seo/<?= htmlspecialchars($row['custom_image']) ?>" alt="OG">
            <?php else: ?>
              <span style="color: #999;">لا توجد</span>
            <?php endif; ?>
          </td>
          <td>
            <a href="edit.php?id=<?= $row['id'] ?>" class="edit-link"><i class="fa fa-edit"></i> تعديل</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
