<?php
require_once __DIR__ . "/../../includes/auth.php";
require_once __DIR__ . "/../../config/db.php";

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if (!$id) {
    die("رقم الصفحة غير صحيح");
}

$stmt = $pdo->prepare("SELECT * FROM seo_pages WHERE id = ?");
$stmt->execute([$id]);
$page = $stmt->fetch();

if (!$page) {
    die("الصفحة غير موجودة");
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $page_link = $_POST["page"] ?? "";
    $title = $_POST["title"] ?? "";
    $description = $_POST["description"] ?? "";
    $keywords = $_POST["keywords"] ?? "";
    $custom_title = $_POST["custom_title"] ?? "";
    $custom_description = $_POST["custom_description"] ?? "";
    $custom_url = $_POST["custom_url"] ?? "";

    // تحديث الصورة إن وُجدت
    $image = $page['custom_image'];
    if (isset($_FILES["custom_image"]) && $_FILES["custom_image"]["error"] === UPLOAD_ERR_OK) {
        $img_name = time() . "_" . basename($_FILES["custom_image"]["name"]);
        $target = __DIR__ . "/../../uploads/seo/" . $img_name;
        move_uploaded_file($_FILES["custom_image"]["tmp_name"], $target);
        $image = $img_name;
    }

    $update = $pdo->prepare("UPDATE seo_pages SET 
        page = ?, 
        title = ?, 
        description = ?, 
        keywords = ?, 
        custom_title = ?, 
        custom_description = ?, 
        custom_url = ?, 
        custom_image = ? 
        WHERE id = ?");
        
    $update->execute([
        $page_link,
        $title,
        $description,
        $keywords,
        $custom_title,
        $custom_description,
        $custom_url,
        $image,
        $id
    ]);

    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تعديل صفحة SEO</title>
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Cairo&display=swap">
  <style>
    body { font-family: 'Cairo', sans-serif; padding: 40px; background: #f9f9f9; }
    .container { max-width: 800px; background: #fff; padding: 25px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin: auto; }
    h2 { text-align: center; margin-bottom: 20px; color: #3e165a; }
    label { display: block; margin-top: 15px; font-weight: bold; }
    input[type="text"], textarea, input[type="file"] {
      width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px;
    }
    textarea { resize: vertical; min-height: 80px; }
    button {
      margin-top: 20px;
      background: #7c3aed;
      color: white;
      padding: 12px 25px;
      border: none;
      border-radius: 30px;
      cursor: pointer;
      font-weight: bold;
    }
    .current-image {
      margin-top: 10px;
    }
    .current-image img {
      width: 100px;
      border-radius: 6px;
      margin-top: 10px;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>تعديل بيانات صفحة SEO</h2>
    <form action="" method="post" enctype="multipart/form-data">
      <label>رابط الصفحة</label>
      <input type="text" name="page" value="<?= htmlspecialchars($page['page']) ?>" required>

      <label>العنوان</label>
      <input type="text" name="title" value="<?= htmlspecialchars($page['title']) ?>">

      <label>الوصف</label>
      <textarea name="description"><?= htmlspecialchars($page['description']) ?></textarea>

      <label>الكلمات الدلالية (Keywords)</label>
      <textarea name="keywords"><?= htmlspecialchars($page['keywords']) ?></textarea>

      <label>العنوان المخصص (Custom Title)</label>
      <input type="text" name="custom_title" value="<?= htmlspecialchars($page['custom_title']) ?>">

      <label>الوصف المخصص (Custom Description)</label>
      <textarea name="custom_description"><?= htmlspecialchars($page['custom_description']) ?></textarea>

      <label>رابط OG مخصص</label>
      <input type="text" name="custom_url" value="<?= htmlspecialchars($page['custom_url']) ?>">

      <label>صورة OG (اختياري)</label>
      <input type="file" name="custom_image">
      <?php if (!empty($page['custom_image'])): ?>
        <div class="current-image">
          <span>الصورة الحالية:</span><br>
          <img src="../../uploads/seo/<?= htmlspecialchars($page['custom_image']) ?>" alt="صورة OG">
        </div>
      <?php endif; ?>

      <button type="submit">حفظ التعديلات</button>
    </form>
  </div>
</body>
</html>
